/*
 * Decompiled with CFR 0.152.
 */
package net.obj.task;

import java.util.Vector;
import net.obj.task.ITask;
import net.obj.task.TaskInfo;

public class TaskWorker
extends Thread {
    private boolean stop;
    private Vector<ITask> taskQueue = new Vector();
    private TaskHolder taskHolder = new TaskHolder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(ITask task) {
        Vector<ITask> vector = this.taskQueue;
        synchronized (vector) {
            for (ITask queuedTask : this.taskQueue) {
                if (queuedTask.getKind() != task.getKind()) continue;
                System.err.println("Skipped: " + task);
                return;
            }
            this.taskQueue.add(task);
            this.taskQueue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCurrentTask(ITask task) {
        TaskHolder taskHolder = this.taskHolder;
        synchronized (taskHolder) {
            this.taskHolder.currentTask = task;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ITask getCurrentTask() {
        TaskHolder taskHolder = this.taskHolder;
        synchronized (taskHolder) {
            return this.taskHolder.currentTask;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        System.err.println("Task Worker up");
        while (!this.stop) {
            this.setCurrentTask(null);
            Vector<ITask> vector = this.taskQueue;
            synchronized (vector) {
                if (this.taskQueue.size() == 0) {
                    try {
                        this.taskQueue.wait(10000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (this.taskQueue.size() > 0) {
                    this.setCurrentTask(this.taskQueue.remove(0));
                }
            }
            if (this.stop || this.getCurrentTask() == null) continue;
            try {
                long timeStart = System.currentTimeMillis();
                this.getCurrentTask().execute();
                long timeEnd = System.currentTimeMillis();
                System.err.println("Excecution Time for " + this.getCurrentTask().getClass().getName() + ": " + (timeEnd - timeStart));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        System.err.println("Task Worker down");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTasks(Vector<String> taskIds) {
        Vector<ITask> tasksToStop = new Vector<ITask>();
        Vector<ITask> vector = this.taskQueue;
        synchronized (vector) {
            for (ITask task : this.taskQueue) {
                if (!taskIds.contains(task.getTaskIdentifier())) continue;
                tasksToStop.add(task);
            }
            for (ITask task : tasksToStop) {
                this.taskQueue.remove(task);
                taskIds.remove(task.getTaskIdentifier());
            }
            ITask currentTask = this.getCurrentTask();
            if (currentTask != null) {
                for (String taskId : taskIds) {
                    taskId.equals(currentTask.getTaskIdentifier());
                }
            }
        }
    }

    public void stopCurrentTask() {
        ITask currentTask = this.getCurrentTask();
        if (currentTask != null) {
            currentTask.setStop(true);
        }
    }

    public boolean shouldTaskStop() {
        ITask currentTask = this.getCurrentTask();
        if (currentTask != null) {
            return currentTask.isStop();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutDown() {
        this.stop = true;
        Vector<ITask> vector = this.taskQueue;
        synchronized (vector) {
            this.taskQueue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<TaskInfo> getTaskInfos() {
        Vector<TaskInfo> v = new Vector<TaskInfo>();
        Vector<ITask> vector = this.taskQueue;
        synchronized (vector) {
            for (ITask task : this.taskQueue) {
                v.add(task.getTaskInfo());
            }
            ITask currentTask = this.getCurrentTask();
            if (currentTask != null) {
                TaskInfo ti = currentTask.getTaskInfo();
                ti.setActive(true);
                v.add(ti);
            }
        }
        return v;
    }

    private class TaskHolder {
        public ITask currentTask = null;

        private TaskHolder() {
        }
    }
}

