/*
 * Decompiled with CFR 0.152.
 */
package net.obj.transaction;

import java.io.Serializable;
import java.sql.Connection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import net.obj.transaction.CacheTable;
import net.obj.transaction.TRow;
import net.obj.transaction.TransactException;

public abstract class Cache
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private Date cts = new Date();
    private LinkedHashMap<String, CacheTable> cacheTables = new LinkedHashMap();
    private LinkedHashMap<String, LinkedHashMap<String, TRow>> data = new LinkedHashMap();

    public CacheTable addCacheTable(String rowClassName, String tableName, boolean cached) {
        CacheTable cacheTable = new CacheTable(this, rowClassName, tableName, cached);
        this.cacheTables.put(rowClassName, cacheTable);
        this.data.put(rowClassName, new LinkedHashMap());
        return cacheTable;
    }

    public CacheTable getCacheTable(String rowClassName) throws TransactException {
        if (rowClassName == null) {
            throw new TransactException("Invalid index: null", new IllegalArgumentException());
        }
        CacheTable cacheTable = this.cacheTables.get(rowClassName);
        if (cacheTable == null) {
            throw new TransactException("Invalid row class: " + rowClassName, new IllegalArgumentException());
        }
        return cacheTable;
    }

    public LinkedHashMap<String, CacheTable> getCacheTables() {
        return this.cacheTables;
    }

    public LinkedHashMap<String, TRow> getRows(String rowClassName) throws TransactException {
        if (rowClassName == null) {
            throw new TransactException("Invalid index: null", new IllegalArgumentException());
        }
        LinkedHashMap<String, TRow> rows = this.data.get(rowClassName);
        if (rows == null) {
            throw new TransactException("Invalid row class: " + rowClassName, new IllegalArgumentException());
        }
        return rows;
    }

    public TRow getRow(String rowClassName, String key) throws TransactException {
        if (rowClassName == null) {
            throw new TransactException("Invalid index: null", new IllegalArgumentException());
        }
        if (key == null) {
            throw new TransactException("Invalid key: null", new IllegalArgumentException());
        }
        LinkedHashMap<String, TRow> rows = this.data.get(rowClassName);
        if (rows == null) {
            throw new TransactException("Invalid row class: " + rowClassName, new IllegalArgumentException());
        }
        return rows.get(key);
    }

    public LinkedHashMap<String, LinkedHashMap<String, TRow>> getData() {
        return this.data;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void populate(Connection c, Integer clientId) throws TransactException {
        Iterator<String> i = this.cacheTables.keySet().iterator();
        while (i.hasNext()) {
            CacheTable t = this.cacheTables.get(i.next());
            LinkedHashMap<String, TRow> rows = this.data.get(t.getRowClassName());
            t.populate(rows, c, clientId);
        }
    }

    public void populate(Connection c, Integer clientId, List<String> cacheTablesToPopulate) throws TransactException {
        Iterator<String> i = cacheTablesToPopulate.iterator();
        while (i.hasNext()) {
            CacheTable t = this.cacheTables.get(i.next());
            LinkedHashMap<String, TRow> rows = this.data.get(t.getRowClassName());
            t.populate(rows, c, clientId);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }
}

