/*
 * Decompiled with CFR 0.152.
 */
package net.obj.transaction;

import java.io.Serializable;
import java.util.Vector;
import net.obj.transaction.CacheForeignKeyColumn;
import net.obj.transaction.CacheTable;
import net.obj.transaction.TransactException;

public class CacheForeignKey
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String foreignKeyName;
    private CacheTable table;
    private CacheTable parentTable;
    private Vector<CacheForeignKeyColumn> foreignKeyColumns = new Vector();
    private String replication;

    public CacheForeignKey(String foreignKeyName, CacheTable table, CacheTable parentTable) {
        this.foreignKeyName = foreignKeyName;
        this.table = table;
        this.parentTable = parentTable;
    }

    public void addForeignKeyColumn(String columnName, String parentColumnName) throws TransactException {
        CacheForeignKeyColumn foreignKeyColumn = new CacheForeignKeyColumn(this.table.getCacheTableColumn(columnName), this.parentTable.getCacheTableColumn(parentColumnName));
        this.foreignKeyColumns.add(foreignKeyColumn);
    }

    public String getCreateSQL() {
        StringBuffer buf = new StringBuffer();
        String list = "";
        String refList = "";
        String sep = "";
        for (CacheForeignKeyColumn column : this.foreignKeyColumns) {
            list = String.valueOf(list) + sep + column.getColumn().getColumnName();
            refList = String.valueOf(refList) + sep + column.getParentColumn().getColumnName();
            sep = ", ";
        }
        buf.append("ALTER TABLE " + this.table.getTableName() + " ADD CONSTRAINT " + this.foreignKeyName + " FOREIGN KEY (");
        buf.append(list);
        buf.append(") REFERENCES " + this.parentTable.getTableName() + " (" + refList + ")");
        return buf.toString();
    }

    public String getCreateCascadeSQL() {
        StringBuffer buf = new StringBuffer();
        String list = "";
        String refList = "";
        String sep = "";
        for (CacheForeignKeyColumn column : this.foreignKeyColumns) {
            list = String.valueOf(list) + sep + column.getColumn().getColumnName();
            refList = String.valueOf(refList) + sep + column.getParentColumn().getColumnName();
            sep = ", ";
        }
        buf.append("ALTER TABLE " + this.table.getTableName() + " ADD CONSTRAINT " + this.foreignKeyName + " FOREIGN KEY (");
        buf.append(list);
        buf.append(") REFERENCES " + this.parentTable.getTableName() + " (" + refList + ")  ON UPDATE CASCADE\r\n");
        return buf.toString();
    }

    public String getForeignKeyName() {
        return this.foreignKeyName;
    }

    public String getReplication() {
        return this.replication;
    }

    public void setReplication(String replication) {
        this.replication = replication;
    }

    public CacheTable getTable() {
        return this.table;
    }

    public void setTable(CacheTable table) {
        this.table = table;
    }

    public CacheTable getParentTable() {
        return this.parentTable;
    }

    public void setParentTable(CacheTable parentTable) {
        this.parentTable = parentTable;
    }
}

