/*
 * Decompiled with CFR 0.152.
 */
package net.obj.transaction;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.LinkedHashMap;
import net.obj.transaction.Cache;
import net.obj.transaction.CacheForeignKey;
import net.obj.transaction.CacheTableColumn;
import net.obj.transaction.CacheTableConstant;
import net.obj.transaction.CacheTableIndex;
import net.obj.transaction.TRow;
import net.obj.transaction.TransactException;

public class CacheTable
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String rowClassName;
    private String rowClassClassName;
    private String rowClassPackageName;
    private String tableName;
    private Cache cache;
    private boolean cached;
    private LinkedHashMap<String, CacheTableColumn> cacheTableColumns = new LinkedHashMap();
    private boolean statementsInitialized = false;
    private String insertSQL = null;
    private String replication;
    private String insertIdentitySQL = null;
    private String identityInsertOnSQL = null;
    private String identityInsertOffSQL = null;
    private String identitySelectSQL = null;
    private String readSQL = null;
    private String populateSQL = null;
    private String updateSQL = null;
    private String deleteSQL = null;
    private CacheTableColumn identityColumn = null;
    private CacheTableColumn clientIdColumn = null;
    private LinkedHashMap<String, CacheTableIndex> indices = new LinkedHashMap();
    private LinkedHashMap<String, CacheForeignKey> foreignKeys = new LinkedHashMap();
    private LinkedHashMap<String, CacheTableConstant> constants = new LinkedHashMap();

    public String getInsertSQL() {
        return this.insertSQL;
    }

    public CacheTable(Cache cache, String rowClassName, String tableName, boolean cached) {
        this.cache = cache;
        this.rowClassName = rowClassName;
        int i = rowClassName.lastIndexOf(46);
        if (i > 0) {
            this.rowClassPackageName = rowClassName.substring(0, i);
            this.rowClassClassName = rowClassName.substring(i + 1);
        }
        this.tableName = tableName;
        this.cached = cached;
    }

    public CacheTableColumn addCacheTableColumn(String columnName, int sqlType, int length, int precision, int options) {
        CacheTableColumn cacheTableColumn = new CacheTableColumn(this, columnName, sqlType, length, precision, options, null);
        this.cacheTableColumns.put(columnName, cacheTableColumn);
        return cacheTableColumn;
    }

    public CacheTableColumn addCacheTableColumn(String columnName, int sqlType, int length, int precision) {
        return this.addCacheTableColumn(columnName, sqlType, length, precision, 0);
    }

    public CacheTableColumn addCacheTableColumn(String columnName, int sqlType, int length, int precision, int options, String renderingHints) {
        CacheTableColumn cacheTableColumn = new CacheTableColumn(this, columnName, sqlType, length, precision, options, renderingHints);
        this.cacheTableColumns.put(columnName, cacheTableColumn);
        return cacheTableColumn;
    }

    public CacheTableColumn addCacheTableColumn(String columnName, int sqlType, int length, int precision, String renderingHints) {
        return this.addCacheTableColumn(columnName, sqlType, length, precision, 0, renderingHints);
    }

    public CacheForeignKey addCacheForeignKey(String foreignKeyName, CacheTable parentTable) {
        CacheForeignKey foreignKey = new CacheForeignKey(foreignKeyName, this, parentTable);
        this.foreignKeys.put(foreignKeyName, foreignKey);
        return foreignKey;
    }

    public CacheTableIndex addCacheIndex(String indexName, boolean unique) {
        CacheTableIndex index = new CacheTableIndex(this, indexName, unique);
        this.indices.put(indexName, index);
        return index;
    }

    public String getRowClassName() {
        return this.rowClassName;
    }

    public String getRowClassClassName() {
        return this.rowClassClassName;
    }

    public String getRowClassPackageName() {
        return this.rowClassPackageName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public Cache getCache() {
        return this.cache;
    }

    public boolean isCached() {
        return this.cached;
    }

    public synchronized void initializeStatements() throws TransactException {
        if (!this.statementsInitialized) {
            String columnIdentityList = "";
            String columnList = "";
            String setList = "";
            String whereList = "";
            String parameterIdentityList = "";
            String parameterList = "";
            String sep0 = "";
            String sep1 = "";
            String sep2 = "";
            String sep3 = "";
            Iterator<String> i = this.cacheTableColumns.keySet().iterator();
            while (i.hasNext()) {
                CacheTableColumn column = this.cacheTableColumns.get(i.next());
                if (column.isIdentity()) {
                    if (this.identityColumn != null) {
                        throw new TransactException(10, "Column " + this.tableName + "." + column.getColumnName() + " more than one identity column per table");
                    }
                    this.identityColumn = column;
                }
                if (column.isClientId()) {
                    if (this.clientIdColumn != null) {
                        throw new TransactException(10, "Column " + this.tableName + "." + column.getColumnName() + " more than one clientId column per table");
                    }
                    this.clientIdColumn = column;
                }
                if (column.isPrimaryKey()) {
                    whereList = String.valueOf(whereList) + sep3 + column.getColumnName() + "=?";
                    sep3 = " AND ";
                } else if (!column.isIdentity()) {
                    setList = String.valueOf(setList) + sep2 + column.getColumnName() + "=?";
                    sep2 = ", ";
                }
                if (!column.isIdentity()) {
                    columnList = String.valueOf(columnList) + sep1 + column.getColumnName();
                    parameterList = String.valueOf(parameterList) + sep1 + "?";
                    sep1 = ", ";
                }
                columnIdentityList = String.valueOf(columnIdentityList) + sep0 + column.getColumnName();
                parameterIdentityList = String.valueOf(parameterIdentityList) + sep0 + "?";
                sep0 = ", ";
            }
            this.insertSQL = "INSERT INTO " + this.getTableName() + " (" + columnList + ") VALUES (" + parameterList + ")";
            this.insertIdentitySQL = "INSERT INTO " + this.getTableName() + " (" + columnIdentityList + ") VALUES (" + parameterIdentityList + ")";
            this.readSQL = "SELECT " + columnIdentityList + " FROM " + this.getTableName() + " WHERE " + whereList;
            this.populateSQL = "SELECT " + columnIdentityList + " FROM " + this.getTableName();
            if (this.clientIdColumn != null) {
                this.populateSQL = String.valueOf(this.populateSQL) + " WHERE " + this.clientIdColumn.getColumnName() + "=?";
            }
            this.deleteSQL = "DELETE FROM " + this.getTableName() + " WHERE " + whereList;
            this.updateSQL = "UPDATE " + this.getTableName() + " SET " + setList + " WHERE " + whereList;
            if (this.identityColumn != null) {
                this.identityInsertOnSQL = "SET IDENTITY_INSERT dbo." + this.getTableName() + " ON";
                this.identityInsertOffSQL = "SET IDENTITY_INSERT dbo." + this.getTableName() + " OFF";
                this.identitySelectSQL = "SELECT @@IDENTITY";
            }
            this.statementsInitialized = true;
        }
    }

    public String getColumnList(String prefix) throws TransactException {
        String columnIdentityList = "";
        String sep0 = "";
        Iterator<String> i = this.cacheTableColumns.keySet().iterator();
        while (i.hasNext()) {
            CacheTableColumn column = this.cacheTableColumns.get(i.next());
            columnIdentityList = String.valueOf(columnIdentityList) + sep0 + (prefix == null ? "" : String.valueOf(prefix) + ".") + column.getColumnName();
            sep0 = ", ";
        }
        return columnIdentityList;
    }

    public int setPrimaryKey(PreparedStatement ps, int pos, TRow row) throws SQLException, SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        int newPos = pos;
        Iterator<String> i = this.cacheTableColumns.keySet().iterator();
        while (i.hasNext()) {
            CacheTableColumn column = this.cacheTableColumns.get(i.next());
            if (!column.isPrimaryKey()) continue;
            column.setStatement(ps, newPos, row);
            ++newPos;
        }
        return newPos;
    }

    public int setColumns(PreparedStatement ps, int pos, TRow row, boolean withPrimaryKey, boolean identityInsert) throws SQLException, SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        int newPos = pos;
        Iterator<String> i = this.cacheTableColumns.keySet().iterator();
        while (i.hasNext()) {
            CacheTableColumn column = this.cacheTableColumns.get(i.next());
            boolean set = false;
            if (column.isPrimaryKey()) {
                if (withPrimaryKey) {
                    if (column.isIdentity()) {
                        if (identityInsert) {
                            set = true;
                        }
                    } else {
                        set = true;
                    }
                }
            } else if (column.isIdentity()) {
                if (identityInsert) {
                    set = true;
                }
            } else {
                set = true;
            }
            if (!set) continue;
            column.setStatement(ps, newPos, row);
            ++newPos;
        }
        return newPos;
    }

    public int getResult(TRow row, ResultSet r, int pos) throws SQLException, SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        int newPos = pos;
        Iterator<String> i = this.cacheTableColumns.keySet().iterator();
        while (i.hasNext()) {
            CacheTableColumn column = this.cacheTableColumns.get(i.next());
            column.getResult(row, r, newPos++);
        }
        return newPos;
    }

    public TRow update(Connection c, TRow newRow, TRow oldRow) throws TransactException {
        this.initializeStatements();
        PreparedStatement ps = null;
        try {
            ps = c.prepareStatement(this.updateSQL);
            int pos = 1;
            pos = this.setColumns(ps, pos, newRow, false, false);
            pos = this.setPrimaryKey(ps, pos, newRow);
            ps.executeUpdate();
            TRow tRow = newRow;
            return tRow;
        }
        catch (SQLException ex) {
            throw new TransactException(ex);
        }
        catch (SecurityException ex) {
            throw new TransactException(ex);
        }
        catch (IllegalArgumentException ex) {
            throw new TransactException(ex);
        }
        catch (NoSuchMethodException ex) {
            throw new TransactException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new TransactException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new TransactException(ex);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public void identityInsertOn(Connection c) throws SQLException {
        Statement s = null;
        try {
            s = c.createStatement();
            s.execute(this.identityInsertOnSQL);
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public void identityInsertOff(Connection c) {
        block12: {
            Statement s = null;
            try {
                try {
                    s = c.createStatement();
                    s.execute(this.identityInsertOffSQL);
                }
                catch (SQLException ix) {
                    ix.printStackTrace();
                    if (s == null) break block12;
                    try {
                        s.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
            finally {
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
    }

    public TRow insert(Connection c, TRow newRow, boolean identityInsert) throws TransactException {
        this.initializeStatements();
        PreparedStatement ps = null;
        ResultSet r = null;
        try {
            if (this.identityColumn != null && identityInsert) {
                this.identityInsertOn(c);
            }
            int pos = 1;
            ps = identityInsert ? c.prepareStatement(this.insertIdentitySQL) : c.prepareStatement(this.insertSQL);
            pos = this.setColumns(ps, pos, newRow, true, identityInsert);
            ps.executeUpdate();
            if (this.identityColumn != null && !identityInsert) {
                ps.close();
                ps = null;
                ps = c.prepareStatement(this.identitySelectSQL);
                r = ps.executeQuery();
                if (r.next()) {
                    this.identityColumn.getResult(newRow, r, 1);
                }
            }
            if (this.identityColumn != null && identityInsert) {
                this.identityInsertOff(c);
            }
            TRow tRow = newRow;
            return tRow;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            throw new TransactException("update failed", ex);
        }
        catch (SecurityException ex) {
            throw new TransactException("update failed", ex);
        }
        catch (IllegalArgumentException ex) {
            throw new TransactException("update failed", ex);
        }
        catch (NoSuchMethodException ex) {
            throw new TransactException("update failed", ex);
        }
        catch (IllegalAccessException ex) {
            throw new TransactException("update failed", ex);
        }
        catch (InvocationTargetException ex) {
            throw new TransactException("update failed", ex);
        }
        finally {
            if (this.identityColumn != null && identityInsert) {
                this.identityInsertOff(c);
            }
            if (r != null) {
                try {
                    r.close();
                }
                catch (SQLException sQLException) {}
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public TRow delete(Connection c, TRow oldRow) throws TransactException {
        this.initializeStatements();
        PreparedStatement ps = null;
        try {
            ps = c.prepareStatement(this.deleteSQL);
            int pos = 1;
            pos = this.setPrimaryKey(ps, pos, oldRow);
            ps.executeUpdate();
            TRow tRow = oldRow;
            return tRow;
        }
        catch (SQLException ex) {
            throw new TransactException("delete failed", ex);
        }
        catch (SecurityException ex) {
            throw new TransactException("delete failed", ex);
        }
        catch (IllegalArgumentException ex) {
            throw new TransactException("delete failed", ex);
        }
        catch (NoSuchMethodException ex) {
            throw new TransactException("delete failed", ex);
        }
        catch (IllegalAccessException ex) {
            throw new TransactException("delete failed", ex);
        }
        catch (InvocationTargetException ex) {
            throw new TransactException("delete failed", ex);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public TRow read(Connection c, TRow key, TRow row) throws TransactException {
        this.initializeStatements();
        PreparedStatement ps = null;
        ResultSet r = null;
        try {
            ps = c.prepareStatement(this.readSQL);
            int pos = 1;
            pos = this.setPrimaryKey(ps, pos, key);
            r = ps.executeQuery();
            if (r.next()) {
                this.getResult(row, r, 1);
                TRow tRow = row;
                return tRow;
            }
            try {
                throw new TransactException(11, "not found");
            }
            catch (SQLException ex) {
                throw new TransactException("read failed", ex);
            }
            catch (SecurityException ex) {
                throw new TransactException("read failed", ex);
            }
            catch (IllegalArgumentException ex) {
                throw new TransactException("read failed", ex);
            }
            catch (NoSuchMethodException ex) {
                throw new TransactException("read failed", ex);
            }
            catch (IllegalAccessException ex) {
                throw new TransactException("read failed", ex);
            }
            catch (InvocationTargetException ex) {
                throw new TransactException("read failed", ex);
            }
        }
        finally {
            if (r != null) {
                try {
                    r.close();
                }
                catch (SQLException sQLException) {}
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public TRow update(LinkedHashMap<String, TRow> rows, TRow newRow, TRow oldRow) throws TransactException {
        TRow row = rows.get(oldRow.getKey());
        if (row != null) {
            rows.put(newRow.getKey(), newRow);
            return newRow;
        }
        return null;
    }

    public TRow insert(LinkedHashMap<String, TRow> rows, TRow row) throws TransactException {
        rows.put(row.getKey(), row);
        return row;
    }

    public TRow delete(LinkedHashMap<String, TRow> rows, TRow row) throws TransactException {
        rows.remove(row.getKey());
        return row;
    }

    public TRow read(LinkedHashMap<String, TRow> rows, TRow key) throws TransactException {
        TRow row = rows.get(key.getKey());
        if (row != null) {
            try {
                return (TRow)row.clone();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
                throw new TransactException(e, row.getClass().getName());
            }
        }
        return null;
    }

    public String getCreateSQL() {
        return this.getCreateSQL(true);
    }

    public String getCreateSQL(boolean newLine) {
        StringBuffer buf = new StringBuffer();
        buf.append("CREATE TABLE " + this.getTableName() + " (");
        String pkList = "";
        String pkSep = "";
        String sep = newLine ? "\n    " : " ";
        Iterator<String> i = this.cacheTableColumns.keySet().iterator();
        while (i.hasNext()) {
            CacheTableColumn column = this.cacheTableColumns.get(i.next());
            if (column.isPrimaryKey()) {
                pkList = String.valueOf(pkList) + pkSep + column.getColumnName();
                pkSep = ", ";
            }
            buf.append(String.valueOf(sep) + column.getCreateSQL());
            String string = sep = newLine ? ",\n    " : ", ";
        }
        if (newLine) {
            buf.append("\n    PRIMARY KEY (" + pkList + ")");
            buf.append(")\r\n");
        } else {
            buf.append(" PRIMARY KEY (" + pkList + ")");
            buf.append(")");
        }
        return buf.toString();
    }

    public LinkedHashMap<String, CacheTableColumn> getCacheTableColumns() {
        return this.cacheTableColumns;
    }

    public CacheTableColumn getCacheTableColumn(String columnName) throws TransactException {
        CacheTableColumn column = this.cacheTableColumns.get(columnName);
        if (column == null) {
            throw new TransactException(10, "Metadata: " + this.tableName + " does not contain column " + columnName);
        }
        return column;
    }

    public LinkedHashMap<String, CacheForeignKey> getForeignKeys() {
        return this.foreignKeys;
    }

    public LinkedHashMap<String, CacheTableIndex> getIndices() {
        return this.indices;
    }

    public void populate(LinkedHashMap<String, TRow> rows, Connection c, Integer clientId) throws TransactException {
        if (this.cached) {
            this.initializeStatements();
            PreparedStatement ps = null;
            ResultSet r = null;
            try {
                try {
                    ps = c.prepareStatement(this.populateSQL);
                    if (this.clientIdColumn != null) {
                        if (clientId == null) {
                            throw new TransactException(12, "Cannot populate with clientId=null");
                        }
                        ps.setInt(1, clientId);
                    }
                    r = ps.executeQuery();
                    Class<?> cls = Class.forName(this.rowClassName);
                    while (r.next()) {
                        Object o = cls.newInstance();
                        if (!(o instanceof TRow)) continue;
                        TRow row = (TRow)o;
                        this.getResult(row, r, 1);
                        rows.put(row.getKey(), row);
                    }
                }
                catch (SQLException ex) {
                    throw new TransactException("populate failed > " + this.tableName, ex);
                }
                catch (SecurityException ex) {
                    throw new TransactException("populate failed", ex);
                }
                catch (IllegalArgumentException ex) {
                    throw new TransactException("populate failed", ex);
                }
                catch (NoSuchMethodException ex) {
                    throw new TransactException("populate failed", ex);
                }
                catch (IllegalAccessException ex) {
                    throw new TransactException("populate failed", ex);
                }
                catch (InvocationTargetException ex) {
                    throw new TransactException("populate failed", ex);
                }
                catch (ClassNotFoundException ex) {
                    throw new TransactException("populate failed", ex);
                }
                catch (InstantiationException ex) {
                    throw new TransactException(ex);
                }
            }
            finally {
                if (r != null) {
                    try {
                        r.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
    }

    public String getPopulateSQL() throws TransactException {
        this.initializeStatements();
        return this.populateSQL;
    }

    public CacheTableColumn getClientIdColumn() {
        return this.clientIdColumn;
    }

    public void addConstant(String type, String name, String value) {
        CacheTableConstant constant = new CacheTableConstant();
        constant.setName(name);
        constant.setType(type);
        constant.setValue(value);
        this.constants.put(constant.getName(), constant);
    }

    public LinkedHashMap<String, CacheTableConstant> getConstants() {
        return this.constants;
    }

    public void copyTo(TRow source, TRow target) {
        Iterator<String> i = this.getCacheTableColumns().keySet().iterator();
        while (i.hasNext()) {
            CacheTableColumn ctc = this.getCacheTableColumns().get(i.next());
            try {
                ctc.setValue(target, ctc.getValue(source));
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (TransactException e) {
                e.printStackTrace();
            }
        }
    }

    public String getReplication() {
        return this.replication;
    }

    public void setReplication(String replication) {
        this.replication = replication;
    }

    public String toString() {
        return this.getTableName();
    }
}

