/*
 * Decompiled with CFR 0.152.
 */
package net.obj.transaction;

import java.io.Serializable;
import java.util.Vector;
import net.obj.transaction.CacheTable;
import net.obj.transaction.CacheTableIndexColumn;
import net.obj.transaction.TransactException;

public class CacheTableIndex
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String indexName;
    private CacheTable table;
    private boolean unique = false;
    private Vector<CacheTableIndexColumn> indexColumns = new Vector();

    public CacheTableIndex(CacheTable table, String indexName, boolean unique) {
        this.indexName = indexName;
        this.table = table;
        this.unique = unique;
    }

    public void addTableIndexColumn(String columnName, boolean descending) throws TransactException {
        CacheTableIndexColumn indexColumn = new CacheTableIndexColumn(this.table.getCacheTableColumn(columnName), descending);
        this.indexColumns.add(indexColumn);
    }

    public String getCreateSQL() {
        StringBuffer buf = new StringBuffer();
        String list = "";
        String sep = "";
        for (CacheTableIndexColumn column : this.indexColumns) {
            list = String.valueOf(list) + sep + column.getColumn().getColumnName();
            if (column.isDescending()) {
                list = String.valueOf(list) + " DESCENDING";
            } else if (column.isDescending()) {
                list = String.valueOf(list) + " ASCENDING";
            }
            sep = ", ";
        }
        buf.append("CREATE" + (this.unique ? " UNIQUE" : "") + " INDEX " + this.getIndexName() + " ON " + this.table.getTableName() + " (" + list + ")");
        return buf.toString();
    }

    public String getIndexName() {
        return this.indexName;
    }
}

