/*
 * Decompiled with CFR 0.152.
 */
package net.obj.transaction;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Vector;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

public class CompressedObjectBuffer
implements Serializable {
    private static final long serialVersionUID = 1L;
    private byte[] bytes;
    private boolean compress;

    public void setObject(Vector<Serializable> vo, boolean compress) throws IOException {
        this.compress = compress;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        if (compress) {
            DeflaterOutputStream dout = new DeflaterOutputStream(bout);
            ObjectOutputStream oout = new ObjectOutputStream(dout);
            Iterator<Serializable> io = vo.iterator();
            while (io.hasNext()) {
                oout.writeUnshared(io.next());
            }
            oout.flush();
            oout.close();
            dout.close();
        } else {
            ObjectOutputStream oout = new ObjectOutputStream(bout);
            Iterator<Serializable> io = vo.iterator();
            while (io.hasNext()) {
                oout.writeUnshared(io.next());
            }
            oout.flush();
            oout.close();
        }
        bout.flush();
        bout.close();
        this.bytes = bout.toByteArray();
    }

    public void getObjects(Vector<Serializable> vo) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bin = new ByteArrayInputStream(this.bytes);
        if (this.compress) {
            InflaterInputStream iin = new InflaterInputStream(bin);
            ObjectInputStream oin = new ObjectInputStream(iin);
            try {
                Object o;
                while ((o = oin.readUnshared()) != null) {
                    vo.add((Serializable)o);
                }
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
            oin.close();
            iin.close();
        } else {
            ObjectInputStream oin = new ObjectInputStream(bin);
            try {
                Object o;
                while ((o = oin.readUnshared()) != null) {
                    vo.add((Serializable)o);
                }
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
            oin.close();
        }
        bin.close();
    }

    public String toString() {
        return super.toString() + " " + (this.bytes != null ? "" + this.bytes.length : "null");
    }
}

