/*
 * Decompiled with CFR 0.152.
 */
package net.obj.transaction;

import java.io.Serializable;
import java.sql.Connection;
import net.obj.transaction.Cache;
import net.obj.transaction.CacheTable;
import net.obj.transaction.TRow;
import net.obj.transaction.TransactException;
import net.obj.transaction.Transaction;

public class TRead
extends Transaction {
    private static final long serialVersionUID = 1L;
    private TRow key;
    private TRow row;

    public void setKey(TRow key) {
        this.key = key;
    }

    public TRow getKey() {
        return this.key;
    }

    public void setRow(TRow row) {
        this.row = row;
    }

    public TRow getRow() {
        return this.row;
    }

    @Override
    public Serializable executeSQL(Connection connection, Cache cache) throws TransactException {
        if (this.key == null) {
            throw new TransactException(14, "cannot read null key");
        }
        return cache.getCacheTable(this.key.getClass().getName()).read(connection, this.key, this.row);
    }

    @Override
    public Serializable executeCache(Cache cache) throws TransactException {
        if (this.key == null) {
            throw new TransactException(14, "cannot read null key");
        }
        CacheTable table = cache.getCacheTable(this.key.getClass().getName());
        if (!table.isCached()) {
            return null;
        }
        return table.read(cache.getRows(this.key.getClass().getName()), this.key);
    }
}

