/*
 * Decompiled with CFR 0.152.
 */
package net.obj.transaction;

import java.io.Serializable;
import java.sql.Connection;
import net.obj.transaction.Cache;
import net.obj.transaction.TRow;
import net.obj.transaction.TransactException;
import net.obj.transaction.Transaction;

public class TReplicationInsert
extends Transaction {
    private static final long serialVersionUID = 1L;
    private TRow row;
    private boolean identityInsert = false;

    public void setRow(TRow row) {
        this.row = row;
    }

    public TRow getRow() {
        return this.row;
    }

    @Override
    public Serializable executeSQL(Connection connection, Cache cache) throws TransactException {
        if (this.row == null) {
            throw new TransactException(14, "cannot insert null row");
        }
        TRow row = cache.getCacheTable(this.row.getClass().getName()).insert(connection, this.row, this.identityInsert);
        this.setNotify(false);
        return row;
    }

    @Override
    public Serializable executeCache(Cache cache) throws TransactException {
        if (this.row == null) {
            throw new TransactException(14, "cannot insert null row");
        }
        TRow row = cache.getCacheTable(this.row.getClass().getName()).insert(cache.getRows(this.row.getClass().getName()), this.row);
        this.setNotify(false);
        return row;
    }

    public void setIdentityInsert(boolean identityInsert) {
        this.identityInsert = identityInsert;
    }

    public boolean isIdentityInsert() {
        return this.identityInsert;
    }
}

