/*
 * Decompiled with CFR 0.152.
 */
package net.obj.transaction;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.obj.transaction.IXMLAsyncResultListener;
import net.obj.transaction.XMLPrintWriter;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLData
implements Serializable {
    public static final long serialVersionUID = 0L;
    private XMLData parent = null;
    private Vector<XMLData> children = new Vector();
    private LinkedHashMap<String, String> attributes = new LinkedHashMap();
    private String qName;
    private StringBuffer chars = new StringBuffer();
    private String content = "";
    private static Class<?>[] knownTypes = new Class[]{Date.class, String.class, Double.class, Integer.class, Long.class, Short.class, Boolean.class};
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss.SSS");

    public Vector<XMLData> getChildren() {
        return this.children;
    }

    public XMLData getParent() {
        return this.parent;
    }

    public void setParent(XMLData parent) {
        this.parent = parent;
    }

    public XMLData(String qName) {
        this.qName = qName;
    }

    public LinkedHashMap<String, String> getAttributes() {
        return this.attributes;
    }

    public String getQName() {
        return this.qName;
    }

    public void setQName(String qName) {
        this.qName = qName;
    }

    public void setAttribute(String key, String value) {
        if (value == null) {
            this.attributes.remove(key);
        } else {
            this.attributes.put(key, value);
        }
    }

    public void setAttribute(String key, Double value) {
        if (value == null) {
            this.attributes.remove(key);
        } else {
            this.attributes.put(key, "" + value);
        }
    }

    public void setAttribute(String key, Long value) {
        if (value == null) {
            this.attributes.remove(key);
        } else {
            this.attributes.put(key, "" + value);
        }
    }

    public String getAttributeValue(String key) {
        return this.attributes.get(key);
    }

    public XMLData addChild(XMLData child) {
        child.setParent(this);
        this.children.add(child);
        return child;
    }

    public void print(XMLPrintWriter out) throws IOException {
        out.print("<" + this.qName);
        for (String key : this.attributes.keySet()) {
            String value = this.attributes.get(key);
            out.printAttribute(key, value);
        }
        if (this.children.size() != 0) {
            out.println(">");
        }
        Iterator<Object> i = this.children.iterator();
        while (i.hasNext()) {
            ((XMLData)i.next()).print(out);
        }
        if (this.children.size() == 0) {
            out.println("/>");
        } else {
            out.println("</" + this.qName + ">");
        }
    }

    public void appendAttribute(StringBuffer buf, String key, Object value) throws IOException {
        if (value != null) {
            if (value.toString().trim().equals("")) {
                return;
            }
            buf.append(" " + key + "=\"");
            buf.append(XMLPrintWriter.quoteString(value.toString()));
            buf.append("\"");
        }
    }

    public void print(StringBuffer out) throws IOException {
        out.append("<" + this.qName);
        for (String key : this.attributes.keySet()) {
            String value = this.attributes.get(key);
            this.appendAttribute(out, key, value);
        }
        if (this.children.size() != 0) {
            out.append(">\r\n");
        }
        Iterator<Object> i = this.children.iterator();
        while (i.hasNext()) {
            ((XMLData)i.next()).print(out);
        }
        if (this.children.size() == 0) {
            out.append("/>\r\n");
        } else {
            out.append("</" + this.qName + ">");
        }
    }

    public void print(PrintStream out) throws IOException {
        out.print("<" + this.qName);
        for (String key : this.attributes.keySet()) {
            String value = this.attributes.get(key);
            if (value == null || value.toString().trim().equals("")) continue;
            out.print(" " + key + "=\"");
            out.print(XMLPrintWriter.quoteString(value.toString()));
            out.print("\"");
        }
        if (this.children.size() != 0) {
            out.println(">");
        }
        Iterator<Object> i = this.children.iterator();
        while (i.hasNext()) {
            ((XMLData)i.next()).print(out);
        }
        if (this.children.size() == 0) {
            out.println("/>");
        } else {
            out.println("</" + this.qName + ">");
        }
    }

    public static XMLData parse(InputStream in) throws IOException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            XMLDataHandler handler = new XMLDataHandler();
            InputSource inputSource = new InputSource(in);
            saxParser.parse(inputSource, (DefaultHandler)handler);
            XMLData xMLData = handler.getXMLData();
            return xMLData;
        }
        catch (SAXParseException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
        catch (SAXException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public static XMLData parse(String in) throws IOException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            XMLDataHandler handler = new XMLDataHandler();
            InputSource inputSource = new InputSource(new StringReader(in));
            saxParser.parse(inputSource, (DefaultHandler)handler);
            return handler.getXMLData();
        }
        catch (SAXParseException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
        catch (SAXException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void removeLastChild() {
        if (this.children.size() > 0) {
            this.children.remove(this.children.size() - 1);
        }
    }

    public void closeTag() {
        this.setContent(this.chars.toString().trim());
    }

    public void characters(char[] ch, int start, int length) {
        this.chars.append(new String(ch, start, length));
    }

    public static void parse(InputStream in, IXMLAsyncResultListener l) throws IOException {
        try {
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                SAXParser saxParser = factory.newSAXParser();
                XMLViewHandler handler = new XMLViewHandler(l);
                InputSource inputSource = new InputSource(in);
                saxParser.parse(inputSource, (DefaultHandler)handler);
            }
            catch (SAXParseException e) {
                e.printStackTrace();
                throw new IOException(e.getMessage());
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
                throw new IOException(e.getMessage());
            }
            catch (SAXException e) {
                e.printStackTrace();
                throw new IOException(e.getMessage());
            }
            catch (IOException e) {
                e.printStackTrace();
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void setObjectAsParameters(Object o, String tagName, String prefix, XMLData xmlData) {
        Method[] am = o.getClass().getMethods();
        int i = 0;
        while (i < am.length) {
            Class<?>[] ap;
            String name = am[i].getName();
            if (name.startsWith("get") && (ap = am[i].getParameterTypes()).length == 0) {
                boolean known = false;
                Class<?> rt = am[i].getReturnType();
                if (rt != null) {
                    int c = 0;
                    while (c < knownTypes.length) {
                        if (knownTypes[c].getName().equals(rt.getName())) {
                            known = true;
                            break;
                        }
                        ++c;
                    }
                }
                if (known) {
                    String key = String.valueOf(prefix) + am[i].getName().substring(3).toLowerCase();
                    try {
                        Object rv = am[i].invoke(o, null);
                        if (rv != null) {
                            XMLData parameter = xmlData.addChild(new XMLData(tagName));
                            parameter.setAttribute("name", key);
                            if (rt.getName().equals("java.util.Date")) {
                                parameter.setAttribute("value", sdf.format((Date)rv));
                            } else {
                                parameter.setAttribute("value", rv.toString());
                            }
                        }
                    }
                    catch (Exception ignore) {
                        ignore.printStackTrace();
                    }
                }
            }
            ++i;
        }
    }

    public static Date getDateParameter(Hashtable<String, String> parameters, String key) {
        String s = parameters.get(key);
        if (s != null) {
            try {
                return sdf.parse(s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public Date getDateAttribute(String key) {
        String s = this.getAttributeValue(key);
        if (s != null) {
            try {
                return sdf.parse(s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static String getDateString(Date date) {
        if (date == null) {
            return null;
        }
        return sdf.format(date);
    }

    public static Boolean getBooleanParameter(Hashtable<String, String> parameters, String key) {
        String s = parameters.get(key);
        if (s != null) {
            try {
                return new Boolean(s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static Double getDoubleParameter(Hashtable<String, String> parameters, String key) {
        String s = parameters.get(key);
        if (s != null) {
            try {
                return new Double(s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static Long getLongParameter(Hashtable<String, String> parameters, String key) {
        String s = parameters.get(key);
        if (s != null) {
            try {
                return new Long(s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static Integer getIntegerParameter(Hashtable<String, String> parameters, String key) {
        String s = parameters.get(key);
        if (s != null) {
            try {
                return new Integer(s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static Short getShortParameter(Hashtable<String, String> parameters, String key) {
        String s = parameters.get(key);
        if (s != null) {
            try {
                return new Short(s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static String getStringParameter(Hashtable<String, String> parameters, String key) {
        return parameters.get(key);
    }

    public static void setObject(Object o, String prefix, Hashtable<String, String> parameters) {
        Method[] am = o.getClass().getMethods();
        int i = 0;
        while (i < am.length) {
            Class<?>[] ap;
            String name = am[i].getName();
            if (name.startsWith("set") && (ap = am[i].getParameterTypes()).length == 1) {
                String key = String.valueOf(prefix) + am[i].getName().substring(3).toLowerCase();
                Object[] ao = null;
                if (ap[0].getName().equals("java.lang.String")) {
                    ao = new Object[]{XMLData.getStringParameter(parameters, key)};
                } else if (ap[0].getName().equals("java.lang.Integer")) {
                    ao = new Object[]{XMLData.getIntegerParameter(parameters, key)};
                } else if (ap[0].getName().equals("java.lang.Double")) {
                    ao = new Object[]{XMLData.getDoubleParameter(parameters, key)};
                } else if (ap[0].getName().equals("java.lang.Long")) {
                    ao = new Object[]{XMLData.getLongParameter(parameters, key)};
                } else if (ap[0].getName().equals("java.util.Date")) {
                    ao = new Object[]{XMLData.getDateParameter(parameters, key)};
                } else if (ap[0].getName().equals("java.lang.Short")) {
                    ao = new Object[]{XMLData.getShortParameter(parameters, key)};
                } else if (ap[0].getName().equals("java.lang.Boolean")) {
                    ao = new Object[]{XMLData.getBooleanParameter(parameters, key)};
                }
                if (ao != null) {
                    try {
                        am[i].invoke(o, ao);
                    }
                    catch (Exception ignore) {
                        ignore.printStackTrace();
                    }
                }
            }
            ++i;
        }
    }

    public Hashtable<String, String> getChildKeyValuePairs(String qname, String keyName, String valueName) {
        Hashtable<String, String> parameters = new Hashtable<String, String>();
        for (XMLData child : this.children) {
            if (!child.getQName().equalsIgnoreCase(qname)) continue;
            String key = child.getAttributes().get(keyName);
            String value = child.getAttributes().get(valueName);
            if (key == null || value == null) continue;
            parameters.put(key, value);
        }
        return parameters;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("<" + this.qName);
        for (String key : this.attributes.keySet()) {
            String value = this.attributes.get(key);
            buf.append(" " + key + "=\"" + XMLPrintWriter.quoteString(value) + "\"");
        }
        if (this.children == null) {
            buf.append("/>\r\n");
        } else {
            buf.append(">\r\n");
            for (XMLData child : this.children) {
                buf.append(child.toString());
            }
            buf.append("</" + this.qName + ">\r\n");
        }
        return buf.toString();
    }

    private static class XMLDataHandler
    extends DefaultHandler {
        private XMLData root = null;
        private Vector<XMLData> stack = new Vector();

        private XMLDataHandler() {
        }

        public XMLData getXMLData() {
            return this.root;
        }

        @Override
        public void endElement(String uri, String localname, String qname) {
            if (this.stack.size() > 0) {
                XMLData current = this.stack.get(this.stack.size() - 1);
                current.closeTag();
                if (current.getChildren().size() == 0 && current.getAttributes().size() == 0 && current.getParent() != null) {
                    String value = current.getContent();
                    if (value != null && !value.isEmpty()) {
                        current.getParent().setAttribute(current.getQName(), value);
                    }
                    current.getParent().removeLastChild();
                }
                this.stack.remove(this.stack.size() - 1);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.stack.size() > 0) {
                XMLData current = this.stack.get(this.stack.size() - 1);
                current.characters(ch, start, length);
            }
        }

        @Override
        public void startElement(String uri, String localname, String qname, Attributes attributes) {
            XMLData parent = null;
            if (this.stack.size() > 0) {
                parent = this.stack.elementAt(this.stack.size() - 1);
            }
            XMLData element = new XMLData(qname);
            int i = 0;
            while (i < attributes.getLength()) {
                element.setAttribute(attributes.getQName(i), attributes.getValue(i));
                ++i;
            }
            if (parent == null) {
                this.root = element;
            } else {
                parent.addChild(element);
            }
            parent = element;
            this.stack.add(element);
        }
    }

    private static class XMLViewHandler
    extends DefaultHandler {
        private XMLData row = null;
        private IXMLAsyncResultListener l = null;

        public XMLViewHandler(IXMLAsyncResultListener l) {
            this.l = l;
        }

        @Override
        public void endElement(String uri, String localname, String qname) {
            if (qname.equals("row")) {
                this.l.processRow(this.row);
                this.row = null;
            }
        }

        @Override
        public void startElement(String uri, String localname, String qname, Attributes attributes) {
            if (qname.equals("row")) {
                this.row = new XMLData(qname);
            } else if (qname.equals("col") && this.row != null) {
                XMLData col = new XMLData(qname);
                int i = 0;
                while (i < attributes.getLength()) {
                    col.setAttribute(attributes.getQName(i), attributes.getValue(i));
                    ++i;
                }
                this.row.addChild(col);
            }
        }
    }
}

