/*
 * Decompiled with CFR 0.152.
 */
package net.timeglobe.dbtool;

import de.obj.utils.XMLPrintWriter2;
import de.timeglobe.catalog.Catalog;
import de.timeglobe.catalog.JdbcCatalog;
import de.timeglobe.db.BackupTable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class ExportCatalog {
    private String database1;
    private String dbms1;
    private String driver1;
    private String url1;
    private String uid1;
    private String pwd1;

    public static void main(String[] args) throws Exception {
        ExportCatalog ec = new ExportCatalog();
        ec.setDatabase1("db_pos_s59p1");
        ec.setDbms1("derby");
        ec.setDriver1("org.apache.derby.jdbc.EmbeddedDriver");
        ec.setUrl1("jdbc:derby:C:/temp/db_pos_s59p1");
        ec.setUid1("");
        ec.setPwd1("");
        ec.execute();
    }

    public void execute() throws Exception {
        JdbcCatalog jc1 = new JdbcCatalog();
        Connection c1 = null;
        Catalog catalog1 = null;
        FileOutputStream fop = null;
        File file = new File("C:/temp/backupCatalog.xml");
        try {
            try {
                fop = new FileOutputStream(file);
                if (!file.exists()) {
                    file.createNewFile();
                }
                c1 = this.getConnection(this.driver1, this.url1, this.uid1, this.pwd1);
                System.err.println("Retrieved connection 1");
                catalog1 = jc1.load(c1, this.getDatabaseDialect(this.getDbms1()), this.database1);
                PrintWriter w = new PrintWriter(System.err);
                XMLPrintWriter2 xw = new XMLPrintWriter2(new PrintWriter(new OutputStreamWriter((OutputStream)fop, "UTF-8")));
                BackupTable bu = new BackupTable("database1", xw, fop, w);
                catalog1.exportCatalog(c1, bu, xw, w);
                fop.flush();
                fop.close();
                System.err.println("Finished");
            }
            catch (Exception e) {
                throw new Exception(e);
            }
        }
        catch (Throwable throwable) {
            this.closeConnection(c1);
            if (fop != null) {
                try {
                    fop.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new Exception(e);
                }
            }
            throw throwable;
        }
        this.closeConnection(c1);
        if (fop != null) {
            try {
                fop.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new Exception(e);
            }
        }
    }

    public Connection getConnection(String driver, String url, String uid, String pwd) throws SQLException, ClassNotFoundException {
        Class.forName(driver);
        Connection connection = DriverManager.getConnection(url, uid, pwd);
        connection.setAutoCommit(false);
        return connection;
    }

    private int getDatabaseDialect(String dbms) {
        if (dbms.equals("derby")) {
            return 2;
        }
        return 1;
    }

    public void closeConnection(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public String getDatabase1() {
        return this.database1;
    }

    public void setDatabase1(String database1) {
        this.database1 = database1;
    }

    public String getDriver1() {
        return this.driver1;
    }

    public void setDriver1(String driver1) {
        this.driver1 = driver1;
    }

    public String getUrl1() {
        return this.url1;
    }

    public void setUrl1(String url1) {
        this.url1 = url1;
    }

    public String getUid1() {
        return this.uid1;
    }

    public void setUid1(String uid1) {
        this.uid1 = uid1;
    }

    public String getPwd1() {
        return this.pwd1;
    }

    public void setPwd1(String pwd1) {
        this.pwd1 = pwd1;
    }

    public String getDbms1() {
        return this.dbms1;
    }

    public void setDbms1(String dbms1) {
        this.dbms1 = dbms1;
    }
}

