/*
 * Decompiled with CFR 0.152.
 */
package net.timeglobe.dbtool;

import de.timeglobe.catalog.Catalog;
import de.timeglobe.catalog.JdbcCatalog;
import de.timeglobe.db.RestoreByXMLStructure;
import java.io.File;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import net.timeglobe.dbtool.script.SqlScriptExecutor;

public class RestoreDatabase {
    private Integer catalogDatabaseId;
    private String dataBaseName;
    private Hashtable<String, Object> keyReplacements = new Hashtable();

    public void restoreDatabase(PrintWriter printWriter, Connection connection, Catalog catalog, String jarFile, String scriptFile, Boolean stopOnError) throws Exception {
        String backupDir = null;
        String fileName = null;
        printWriter.println("*** DROP DATABASE");
        printWriter.flush();
        this.dropDatabaseContent(connection, printWriter);
        printWriter.println("*** CREATE DATABASE");
        printWriter.flush();
        this.createTables(connection, printWriter, catalog);
        printWriter.println("*** IMPORT DATA");
        printWriter.flush();
        RestoreByXMLStructure restoreByXMLStructure = new RestoreByXMLStructure();
        File file = new File(jarFile);
        fileName = file.getName();
        backupDir = file.getParent();
        restoreByXMLStructure.setBackUpDirectory(backupDir);
        restoreByXMLStructure.setFileName(fileName);
        restoreByXMLStructure.setConnection(connection);
        restoreByXMLStructure.setCatalog(catalog);
        restoreByXMLStructure.setStopOnError(stopOnError);
        if (this.keyReplacements != null) {
            restoreByXMLStructure.setKeyReplacements(this.keyReplacements);
        }
        restoreByXMLStructure.executeImmediately(printWriter);
        if (scriptFile != null) {
            SqlScriptExecutor sse = new SqlScriptExecutor();
            sse.executeScripts(connection, new File(scriptFile));
        }
        printWriter.println("*** IMPORT CREATE KEYS");
        printWriter.flush();
        this.createKeys(connection, printWriter, catalog);
    }

    private void dropDatabaseContent(Connection c, PrintWriter w) {
        JdbcCatalog jdbcCatalog = new JdbcCatalog();
        try {
            Catalog catalog = jdbcCatalog.load(c, this.catalogDatabaseId, this.dataBaseName);
            catalog.dropViews(c, this.catalogDatabaseId, false, w);
            catalog.dropIndices(c, this.catalogDatabaseId, false, w);
            catalog.dropForeignKeys(c, this.catalogDatabaseId, false, w);
            catalog.dropTables(c, this.catalogDatabaseId, false, w);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    private void createTables(Connection c, PrintWriter w, Catalog catalog) {
        try {
            catalog.createTables(c, this.catalogDatabaseId, false, w);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void createKeys(Connection c, PrintWriter w, Catalog catalog) {
        try {
            catalog.createIndices(c, this.catalogDatabaseId, false, w);
            catalog.createForeignKeys(c, this.catalogDatabaseId, false, w);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public Integer getCatalogDatabaseId() {
        return this.catalogDatabaseId;
    }

    public void setCatalogDatabaseId(Integer catalogDatabaseId) {
        this.catalogDatabaseId = catalogDatabaseId;
    }

    public String getDataBaseName() {
        return this.dataBaseName;
    }

    public void setDataBaseName(String dataBaseName) {
        this.dataBaseName = dataBaseName;
    }

    public void addKeyReplacement(String key, Object value) {
        this.keyReplacements.put(key, value);
    }
}

