/*
 * Decompiled with CFR 0.152.
 */
package net.timeglobe.dbtool;

import de.obj.utils.IObservableSubject;
import de.obj.utils.IObserver;
import de.timeglobe.db.ExtractSQLsSimple;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.List;

public class ScriptRunner
implements IObservableSubject {
    private Connection connection;
    private List<IObserver> listObserver = new ArrayList<IObserver>();
    private String currentSQL;

    public void runSQLs(String script, Connection connection) throws Exception {
        this.connection = connection;
        ArrayList<Object> sqlObjects = new ArrayList();
        ExtractSQLsSimple extractSqls = new ExtractSQLsSimple();
        sqlObjects = extractSqls.getSQLs(script);
        for (ExtractSQLsSimple.SQLObject sQLObject : sqlObjects) {
            if (sQLObject.getSqlType() == 1) continue;
            this.currentSQL = sQLObject.getSql();
            this.notifyObservers();
            this.executeSQL(sQLObject.getSql());
        }
    }

    private void executeSQL(String sql) throws Exception {
        PreparedStatement ps = null;
        if (sql != null) {
            try {
                try {
                    ps = this.connection.prepareStatement(sql);
                    int n = ps.executeUpdate();
                }
                catch (Exception e) {
                    throw new Exception("Error running sql: " + sql + " " + e.getMessage(), e.getCause());
                }
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
    }

    @Override
    public void addEventListener(IObserver observer) {
        this.listObserver.add(observer);
    }

    @Override
    public void removeEventListener(IObserver observer) {
        this.listObserver.remove(observer);
    }

    @Override
    public void notifyObservers() {
        for (IObserver observer : this.listObserver) {
            observer.update(this);
        }
    }

    public String getCurrentSQL() {
        return this.currentSQL;
    }

    public void setCurrentSQL(String currentSQL) {
        this.currentSQL = currentSQL;
    }
}

