/*
 * Decompiled with CFR 0.152.
 */
package at.asitplus.regkassen.core;

import at.asitplus.regkassen.common.RKSuite;
import at.asitplus.regkassen.common.TypeOfReceipt;
import at.asitplus.regkassen.common.util.CashBoxUtils;
import at.asitplus.regkassen.common.util.CryptoUtil;
import at.asitplus.regkassen.core.base.cashboxsimulation.CashBoxInstruction;
import at.asitplus.regkassen.core.base.receiptdata.ReceiptPackage;
import at.asitplus.regkassen.core.base.receiptdata.ReceiptRepresentationForSignature;
import at.asitplus.regkassen.core.base.receiptdata.SimplifiedReceipt;
import at.asitplus.regkassen.core.modules.DEP.DEPExportFormat;
import at.asitplus.regkassen.core.modules.init.CashBoxParameters;
import at.asitplus.regkassen.core.modules.print.ReceiptPrintType;
import at.asitplus.regkassen.core.modules.signature.jws.JWSModule;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import org.apache.commons.math3.util.Precision;

public class DemoCashBox {
    protected CashBoxParameters cashBoxParameters;
    protected long turnoverCounter = 0L;

    public DemoCashBox(CashBoxParameters cashBoxParameters) {
        this.cashBoxParameters = cashBoxParameters;
    }

    public CashBoxParameters getCashBoxParameters() {
        return this.cashBoxParameters;
    }

    public void executeSimulation(List<CashBoxInstruction> cashBoxInstructions) {
        for (CashBoxInstruction cashBoxInstruction : cashBoxInstructions) {
            this.createStoreAndSignReceiptPackage(cashBoxInstruction);
        }
    }

    public DEPExportFormat exportDEP() {
        return this.cashBoxParameters.getDepModul().exportDEP();
    }

    public List<ReceiptPackage> getStoredReceipts() {
        return this.cashBoxParameters.getDepModul().getStoredReceipts();
    }

    public byte[] printReceipt(ReceiptPackage receiptPackage, ReceiptPrintType receiptPrintType) {
        return this.cashBoxParameters.getPrinterModule().printReceipt(receiptPackage, receiptPrintType);
    }

    public List<byte[]> printReceipt(List<ReceiptPackage> receiptPackageList, ReceiptPrintType receiptPrintType) {
        return this.cashBoxParameters.getPrinterModule().printReceipt(receiptPackageList, receiptPrintType);
    }

    protected synchronized void createStoreAndSignReceiptPackage(CashBoxInstruction cashBoxInstruction) {
        String el10_encryptedTurnOverValue;
        double el9_taxSet_BESONDERS;
        double el8_taxSet_NULL;
        double el7_taxSet_ERMAESSIGT2;
        double el6_taxSet_ERMAESSIGT1;
        double el5_taxSet_NORMAL;
        JWSModule signatureDevice = this.cashBoxParameters.getJwsSignatureModules().get(cashBoxInstruction.getUsedSignatureDevice());
        RKSuite rkSuiteOfSignatureDevice = signatureDevice.getRKSuite();
        String el12_chainValue = "";
        RKSuite el1_rkSuite = signatureDevice.getRKSuite();
        String el2_cashboxID = this.cashBoxParameters.getCashBoxId();
        String el3_receiptID = cashBoxInstruction.getReceiptIdentifier();
        Date el4_timeAndData = null;
        if (cashBoxInstruction.getDateToUse() != null) {
            try {
                el4_timeAndData = CashBoxUtils.convertISO8601toDate((String)cashBoxInstruction.getDateToUse());
            }
            catch (ParseException e) {
                System.err.println("Fatal error, cannot parse date from cashbox instruction file: " + cashBoxInstruction.getDateToUse() + " is not a valid date");
                System.exit(-1);
            }
        } else {
            el4_timeAndData = new Date();
        }
        String el11_certificateSerialNumberOrCompanyAndKeyID = signatureDevice.getSerialNumberOfKeyID();
        TypeOfReceipt typeOfReceipt = cashBoxInstruction.getTypeOfReceipt();
        SimplifiedReceipt simplifiedReceipt = cashBoxInstruction.getSimplifiedReceipt();
        if (typeOfReceipt == TypeOfReceipt.START_BELEG) {
            el5_taxSet_NORMAL = 0.0;
            el6_taxSet_ERMAESSIGT1 = 0.0;
            el7_taxSet_ERMAESSIGT2 = 0.0;
            el8_taxSet_NULL = 0.0;
            el9_taxSet_BESONDERS = 0.0;
            el10_encryptedTurnOverValue = this.encryptTurnOverCounter(this.cashBoxParameters.getCashBoxId(), el3_receiptID, rkSuiteOfSignatureDevice, this.cashBoxParameters.getTurnOverCounterLengthInBytes());
            el12_chainValue = this.calculateChainValue(null, rkSuiteOfSignatureDevice);
        } else if (typeOfReceipt == TypeOfReceipt.STANDARD_BELEG) {
            el5_taxSet_NORMAL = Precision.round((double)simplifiedReceipt.getTaxSetNormal(), (int)2);
            el6_taxSet_ERMAESSIGT1 = Precision.round((double)simplifiedReceipt.getTaxSetErmaessigt1(), (int)2);
            el7_taxSet_ERMAESSIGT2 = Precision.round((double)simplifiedReceipt.getTaxSetErmaessigt2(), (int)2);
            el8_taxSet_NULL = Precision.round((double)simplifiedReceipt.getTaxSetNull(), (int)2);
            el9_taxSet_BESONDERS = Precision.round((double)simplifiedReceipt.getTaxSetBesonders(), (int)2);
            this.updateTurnOverCounter(simplifiedReceipt);
            el10_encryptedTurnOverValue = this.encryptTurnOverCounter(this.cashBoxParameters.getCashBoxId(), el3_receiptID, rkSuiteOfSignatureDevice, this.cashBoxParameters.getTurnOverCounterLengthInBytes());
            if (this.getStoredReceipts().size() > 0) {
                el12_chainValue = this.calculateChainValue(this.getStoredReceipts().get(this.getStoredReceipts().size() - 1).getJwsCompactRepresentation(), rkSuiteOfSignatureDevice);
            }
        } else if (typeOfReceipt == TypeOfReceipt.STORNO_BELEG) {
            el5_taxSet_NORMAL = Precision.round((double)simplifiedReceipt.getTaxSetNormal(), (int)2);
            el6_taxSet_ERMAESSIGT1 = Precision.round((double)simplifiedReceipt.getTaxSetErmaessigt1(), (int)2);
            el7_taxSet_ERMAESSIGT2 = Precision.round((double)simplifiedReceipt.getTaxSetErmaessigt2(), (int)2);
            el8_taxSet_NULL = Precision.round((double)simplifiedReceipt.getTaxSetNull(), (int)2);
            el9_taxSet_BESONDERS = Precision.round((double)simplifiedReceipt.getTaxSetBesonders(), (int)2);
            this.updateTurnOverCounter(simplifiedReceipt);
            el10_encryptedTurnOverValue = CashBoxUtils.base64Encode((byte[])"STO".getBytes(), (boolean)false);
            if (this.getStoredReceipts().size() > 0) {
                el12_chainValue = this.calculateChainValue(this.getStoredReceipts().get(this.getStoredReceipts().size() - 1).getJwsCompactRepresentation(), rkSuiteOfSignatureDevice);
            }
        } else if (typeOfReceipt == TypeOfReceipt.TRAINING_BELEG) {
            el5_taxSet_NORMAL = Precision.round((double)simplifiedReceipt.getTaxSetNormal(), (int)2);
            el6_taxSet_ERMAESSIGT1 = Precision.round((double)simplifiedReceipt.getTaxSetErmaessigt1(), (int)2);
            el7_taxSet_ERMAESSIGT2 = Precision.round((double)simplifiedReceipt.getTaxSetErmaessigt2(), (int)2);
            el8_taxSet_NULL = Precision.round((double)simplifiedReceipt.getTaxSetNull(), (int)2);
            el9_taxSet_BESONDERS = Precision.round((double)simplifiedReceipt.getTaxSetBesonders(), (int)2);
            el10_encryptedTurnOverValue = CashBoxUtils.base64Encode((byte[])"TRA".getBytes(), (boolean)false);
            if (this.getStoredReceipts().size() > 0) {
                el12_chainValue = this.calculateChainValue(this.getStoredReceipts().get(this.getStoredReceipts().size() - 1).getJwsCompactRepresentation(), rkSuiteOfSignatureDevice);
            }
        } else if (typeOfReceipt == TypeOfReceipt.NULL_BELEG) {
            el5_taxSet_NORMAL = 0.0;
            el6_taxSet_ERMAESSIGT1 = 0.0;
            el7_taxSet_ERMAESSIGT2 = 0.0;
            el8_taxSet_NULL = 0.0;
            el9_taxSet_BESONDERS = 0.0;
            el10_encryptedTurnOverValue = this.encryptTurnOverCounter(this.cashBoxParameters.getCashBoxId(), el3_receiptID, rkSuiteOfSignatureDevice, this.cashBoxParameters.getTurnOverCounterLengthInBytes());
            if (this.getStoredReceipts().size() > 0) {
                el12_chainValue = this.calculateChainValue(this.getStoredReceipts().get(this.getStoredReceipts().size() - 1).getJwsCompactRepresentation(), rkSuiteOfSignatureDevice);
            }
        } else {
            return;
        }
        ReceiptRepresentationForSignature receiptRepresentationForSignature = new ReceiptRepresentationForSignature();
        receiptRepresentationForSignature.setCashBoxID(el2_cashboxID);
        receiptRepresentationForSignature.setReceiptIdentifier(el3_receiptID);
        receiptRepresentationForSignature.setReceiptDateAndTime(el4_timeAndData);
        receiptRepresentationForSignature.setSumTaxSetNormal(el5_taxSet_NORMAL);
        receiptRepresentationForSignature.setSumTaxSetErmaessigt1(el6_taxSet_ERMAESSIGT1);
        receiptRepresentationForSignature.setSumTaxSetErmaessigt2(el7_taxSet_ERMAESSIGT2);
        receiptRepresentationForSignature.setSumTaxSetNull(el8_taxSet_NULL);
        receiptRepresentationForSignature.setSumTaxSetBesonders(el9_taxSet_BESONDERS);
        receiptRepresentationForSignature.setEncryptedTurnoverValue(el10_encryptedTurnOverValue);
        receiptRepresentationForSignature.setSignatureCertificateSerialNumber(el11_certificateSerialNumberOrCompanyAndKeyID);
        receiptRepresentationForSignature.setSignatureValuePreviousReceipt(el12_chainValue);
        String plainData = receiptRepresentationForSignature.getDataToBeSigned(el1_rkSuite);
        String signedJWSCompactRep = signatureDevice.signMachineCodeRepOfReceipt(plainData, (boolean)cashBoxInstruction.isSignatureDeviceDamaged());
        ReceiptPackage receiptPackage = new ReceiptPackage();
        receiptPackage.setCertificateChain(signatureDevice.getSignatureModule().getCertificateChain());
        receiptPackage.setSigningCertificate(signatureDevice.getSignatureModule().getSigningCertificate());
        receiptPackage.setJwsCompactRepresentation(signedJWSCompactRep);
        this.cashBoxParameters.getDepModul().storeReceipt(receiptPackage);
    }

    protected void updateTurnOverCounter(SimplifiedReceipt SimplifiedReceipt2) {
        double sumTaxTypeNormal = Precision.round((double)SimplifiedReceipt2.getTaxSetNormal(), (int)2);
        double sumTaxTypeErmaessigt1 = Precision.round((double)SimplifiedReceipt2.getTaxSetErmaessigt1(), (int)2);
        double sumTaxTypeErmaessigt2 = Precision.round((double)SimplifiedReceipt2.getTaxSetErmaessigt2(), (int)2);
        double sumTaxTypeNull = Precision.round((double)SimplifiedReceipt2.getTaxSetNull(), (int)2);
        double sumTaxTypeBesonders = Precision.round((double)SimplifiedReceipt2.getTaxSetBesonders(), (int)2);
        long tempSum = 0L;
        tempSum = (long)((double)tempSum + Precision.round((double)(sumTaxTypeNormal * 100.0), (int)0));
        tempSum = (long)((double)tempSum + Precision.round((double)(sumTaxTypeErmaessigt1 * 100.0), (int)0));
        tempSum = (long)((double)tempSum + Precision.round((double)(sumTaxTypeErmaessigt2 * 100.0), (int)0));
        tempSum = (long)((double)tempSum + Precision.round((double)(sumTaxTypeNull * 100.0), (int)0));
        tempSum = (long)((double)tempSum + Precision.round((double)(sumTaxTypeBesonders * 100.0), (int)0));
        this.turnoverCounter += tempSum;
    }

    protected String encryptTurnOverCounter(String cashBoxIDUTF8String, String receiptIdentifierUTF8String, RKSuite rkSuite, int turnOverCounterLengthInBytes) {
        try {
            String IVUTF8StringRepresentation = cashBoxIDUTF8String + receiptIdentifierUTF8String;
            MessageDigest messageDigest = MessageDigest.getInstance(rkSuite.getHashAlgorithmForPreviousSignatureValue());
            byte[] hashValue = messageDigest.digest(IVUTF8StringRepresentation.getBytes());
            byte[] concatenatedHashValue = new byte[16];
            System.arraycopy(hashValue, 0, concatenatedHashValue, 0, 16);
            String base64EncryptedTurnOverValue1 = null;
            base64EncryptedTurnOverValue1 = CryptoUtil.encryptCTR((byte[])concatenatedHashValue, (Long)this.turnoverCounter, (SecretKey)this.cashBoxParameters.getTurnOverCounterAESKey(), (int)turnOverCounterLengthInBytes);
            String base64EncryptedTurnOverValue2 = CryptoUtil.encryptCFB((byte[])concatenatedHashValue, (Long)this.turnoverCounter, (SecretKey)this.cashBoxParameters.getTurnOverCounterAESKey(), (int)turnOverCounterLengthInBytes);
            String base64EncryptedTurnOverValue3 = CryptoUtil.encryptECB((byte[])concatenatedHashValue, (Long)this.turnoverCounter, (SecretKey)this.cashBoxParameters.getTurnOverCounterAESKey(), (int)turnOverCounterLengthInBytes);
            if (!base64EncryptedTurnOverValue1.equals(base64EncryptedTurnOverValue2)) {
                System.out.println("ENCRYPTION ERROR IN METHOD updateTurnOverCounter, MUST NOT HAPPEN");
                System.exit(-1);
            }
            if (!base64EncryptedTurnOverValue1.equals(base64EncryptedTurnOverValue3)) {
                System.out.println("ENCRYPTION ERROR IN METHOD updateTurnOverCounter, MUST NOT HAPPEN");
                System.exit(-1);
            }
            long testPlainOverTurnOverReconstructed1 = CryptoUtil.decryptCTR((byte[])concatenatedHashValue, (String)base64EncryptedTurnOverValue1, (SecretKey)this.cashBoxParameters.getTurnOverCounterAESKey());
            long testPlainOverTurnOverReconstructed2 = CryptoUtil.decryptCFB((byte[])concatenatedHashValue, (String)base64EncryptedTurnOverValue2, (SecretKey)this.cashBoxParameters.getTurnOverCounterAESKey());
            long testPlainOverTurnOverReconstructed3 = CryptoUtil.decryptECB((byte[])concatenatedHashValue, (String)base64EncryptedTurnOverValue3, (SecretKey)this.cashBoxParameters.getTurnOverCounterAESKey());
            if (testPlainOverTurnOverReconstructed1 != testPlainOverTurnOverReconstructed2) {
                System.out.println("DECRYPTION ERROR IN METHOD updateTurnOverCounter, MUST NOT HAPPEN");
                System.exit(-1);
            }
            if (testPlainOverTurnOverReconstructed1 != testPlainOverTurnOverReconstructed3) {
                System.out.println("DECRYPTION ERROR IN METHOD updateTurnOverCounter, MUST NOT HAPPEN");
                System.exit(-1);
            }
            if (this.turnoverCounter != testPlainOverTurnOverReconstructed1) {
                System.out.println("DECRYPTION ERROR IN METHOD updateTurnOverCounter, MUST NOT HAPPEN");
                System.exit(-1);
            }
            return base64EncryptedTurnOverValue1;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (NoSuchProviderException e) {
            e.printStackTrace();
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (InvalidAlgorithmParameterException e) {
            e.printStackTrace();
        }
        catch (IllegalBlockSizeException e) {
            e.printStackTrace();
        }
        catch (BadPaddingException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected String calculateChainValue(String previousReceiptJWSRepresentation, RKSuite rkSuite) {
        try {
            String inputForChainCalculation = previousReceiptJWSRepresentation == null ? this.cashBoxParameters.getCashBoxId() : previousReceiptJWSRepresentation;
            MessageDigest md = MessageDigest.getInstance(rkSuite.getHashAlgorithmForPreviousSignatureValue());
            md.update(inputForChainCalculation.getBytes());
            byte[] digest = md.digest();
            int bytesToExtract = rkSuite.getNumberOfBytesExtractedFromPrevSigHash();
            byte[] conDigest = new byte[bytesToExtract];
            System.arraycopy(digest, 0, conDigest, 0, bytesToExtract);
            return CashBoxUtils.base64Encode((byte[])conDigest, (boolean)false);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }
}

