/*
 * Decompiled with CFR 0.152.
 */
package at.asitplus.regkassen.core.base.cashboxsimulation;

import at.asitplus.regkassen.common.SignatureDeviceType;
import at.asitplus.regkassen.common.util.CashBoxUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.ByteArrayInputStream;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;

public class CertificateOrPublicKeyContainer {
    protected String id;
    protected SignatureDeviceType signatureDeviceType;
    protected String signatureCertificateOrPublicKey;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public SignatureDeviceType getSignatureDeviceType() {
        return this.signatureDeviceType;
    }

    public void setSignatureDeviceType(SignatureDeviceType signatureDeviceType) {
        this.signatureDeviceType = signatureDeviceType;
    }

    public String getSignatureCertificateOrPublicKey() {
        return this.signatureCertificateOrPublicKey;
    }

    public void setSignatureCertificateOrPublicKey(String signatureCertificateOrPublicKey) {
        this.signatureCertificateOrPublicKey = signatureCertificateOrPublicKey;
    }

    @JsonIgnore
    public PublicKey getPublicKey() {
        PublicKey publicKey = null;
        try {
            if (this.signatureDeviceType == SignatureDeviceType.CERTIFICATE) {
                X509Certificate cert = this.getCertificate();
                publicKey = cert.getPublicKey();
            } else {
                KeyFactory fact = KeyFactory.getInstance("ECDSA", "BC");
                publicKey = fact.generatePublic(new X509EncodedKeySpec(CashBoxUtils.base64Decode((String)this.signatureCertificateOrPublicKey, (boolean)false)));
            }
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (InvalidKeySpecException e) {
            e.printStackTrace();
        }
        catch (NoSuchProviderException e) {
            e.printStackTrace();
        }
        return publicKey;
    }

    @JsonIgnore
    public X509Certificate getCertificate() {
        try {
            if (this.signatureDeviceType == SignatureDeviceType.PUBLIC_KEY) {
                return null;
            }
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream in = new ByteArrayInputStream(CashBoxUtils.base64Decode((String)this.signatureCertificateOrPublicKey, (boolean)false));
            X509Certificate cert = (X509Certificate)certFactory.generateCertificate(in);
            return cert;
        }
        catch (CertificateException e) {
            e.printStackTrace();
            return null;
        }
    }
}

