/*
 * Decompiled with CFR 0.152.
 */
package at.asitplus.regkassen.core.base.receiptdata;

import at.asitplus.regkassen.common.RKSuite;
import at.asitplus.regkassen.common.util.CashBoxUtils;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.math3.util.Precision;

public class ReceiptRepresentationForSignature {
    @JsonProperty(value="Kassen-ID")
    protected String cashBoxID;
    @JsonProperty(value="Belegnummer")
    protected String receiptIdentifier;
    @JsonProperty(value="Beleg-Datum-Uhrzeit")
    protected Date receiptDateAndTime;
    @JsonProperty(value="Betrag-Satz-Normal")
    protected double sumTaxSetNormal;
    @JsonProperty(value="Betrag-Satz-Ermaessigt-1")
    protected double sumTaxSetErmaessigt1;
    @JsonProperty(value="Betrag-Satz-Ermaessigt-2")
    protected double sumTaxSetErmaessigt2;
    @JsonProperty(value="Betrag-Satz-Null")
    protected double sumTaxSetNull;
    @JsonProperty(value="Betrag-Satz-Besonders")
    protected double sumTaxSetBesonders;
    @JsonProperty(value="Stand-Umsatz-Zaehler-AES256-ICM")
    protected String encryptedTurnoverValue;
    @JsonProperty(value="Zertifikat-Seriennummer")
    protected String signatureCertificateSerialNumber;
    @JsonProperty(value="Sig-Voriger-Beleg")
    protected String signatureValuePreviousReceipt;

    public String getDataToBeSigned(RKSuite rkSuite) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.GERMAN);
        nf.setMinimumFractionDigits(2);
        nf.setMaximumFractionDigits(2);
        DecimalFormat decimalFormat = (DecimalFormat)nf;
        return "_" + rkSuite.getSuiteID() + "_" + this.cashBoxID + "_" + this.receiptIdentifier + "_" + dateFormat.format(this.receiptDateAndTime) + "_" + decimalFormat.format(this.sumTaxSetNormal) + "_" + decimalFormat.format(this.sumTaxSetErmaessigt1) + "_" + decimalFormat.format(this.sumTaxSetErmaessigt2) + "_" + decimalFormat.format(this.sumTaxSetNull) + "_" + decimalFormat.format(this.sumTaxSetBesonders) + "_" + this.encryptedTurnoverValue + "_" + this.signatureCertificateSerialNumber + "_" + this.signatureValuePreviousReceipt;
    }

    public String getOCRCodeRepresentationWithoutSignature(RKSuite rkSuite) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.GERMAN);
        nf.setMinimumFractionDigits(2);
        nf.setMaximumFractionDigits(2);
        DecimalFormat decimalFormat = (DecimalFormat)nf;
        String base32RepOfSignatureValuePreviousReceipt = CashBoxUtils.base32Encode((byte[])CashBoxUtils.base64Decode((String)this.signatureValuePreviousReceipt, (boolean)false));
        String base32EncryptedTurnoverValue = CashBoxUtils.base32Encode((byte[])CashBoxUtils.base64Decode((String)this.encryptedTurnoverValue, (boolean)false));
        return "_" + rkSuite.getSuiteID() + "_" + this.cashBoxID + "_" + this.receiptIdentifier + "_" + dateFormat.format(this.receiptDateAndTime) + "_" + decimalFormat.format(this.sumTaxSetNormal) + "_" + decimalFormat.format(this.sumTaxSetErmaessigt1) + "_" + decimalFormat.format(this.sumTaxSetErmaessigt2) + "_" + decimalFormat.format(this.sumTaxSetNull) + "_" + decimalFormat.format(this.sumTaxSetBesonders) + "_" + base32EncryptedTurnoverValue + "_" + this.signatureCertificateSerialNumber + "_" + base32RepOfSignatureValuePreviousReceipt;
    }

    public String getCashBoxID() {
        return this.cashBoxID;
    }

    public void setCashBoxID(String cashBoxID) {
        this.cashBoxID = cashBoxID;
    }

    public String getReceiptIdentifier() {
        return this.receiptIdentifier;
    }

    public void setReceiptIdentifier(String receiptIdentifier) {
        this.receiptIdentifier = receiptIdentifier;
    }

    public Date getReceiptDateAndTime() {
        return this.receiptDateAndTime;
    }

    public void setReceiptDateAndTime(Date receiptDateAndTime) {
        this.receiptDateAndTime = receiptDateAndTime;
    }

    public double getSumTaxSetNormal() {
        return Precision.round((double)this.sumTaxSetNormal, (int)2);
    }

    public void setSumTaxSetNormal(double sumTaxSetNormal) {
        this.sumTaxSetNormal = sumTaxSetNormal;
    }

    public double getSumTaxSetErmaessigt1() {
        return Precision.round((double)this.sumTaxSetErmaessigt1, (int)2);
    }

    public void setSumTaxSetErmaessigt1(double sumTaxSetErmaessigt1) {
        this.sumTaxSetErmaessigt1 = sumTaxSetErmaessigt1;
    }

    public double getSumTaxSetErmaessigt2() {
        return Precision.round((double)this.sumTaxSetErmaessigt2, (int)2);
    }

    public void setSumTaxSetErmaessigt2(double sumTaxSetErmaessigt2) {
        this.sumTaxSetErmaessigt2 = sumTaxSetErmaessigt2;
    }

    public double getSumTaxSetNull() {
        return Precision.round((double)this.sumTaxSetNull, (int)2);
    }

    public void setSumTaxSetNull(double sumTaxSetNull) {
        this.sumTaxSetNull = sumTaxSetNull;
    }

    public double getSumTaxSetBesonders() {
        return Precision.round((double)this.sumTaxSetBesonders, (int)2);
    }

    public void setSumTaxSetBesonders(double sumTaxSetBesonders) {
        this.sumTaxSetBesonders = sumTaxSetBesonders;
    }

    public String getEncryptedTurnoverValue() {
        return this.encryptedTurnoverValue;
    }

    public void setEncryptedTurnoverValue(String encryptedTurnoverValue) {
        this.encryptedTurnoverValue = encryptedTurnoverValue;
    }

    public String getSignatureCertificateSerialNumber() {
        return this.signatureCertificateSerialNumber;
    }

    public void setSignatureCertificateSerialNumber(String signatureCertificateSerialNumber) {
        this.signatureCertificateSerialNumber = signatureCertificateSerialNumber;
    }

    public String getSignatureValuePreviousReceipt() {
        return this.signatureValuePreviousReceipt;
    }

    public void setSignatureValuePreviousReceipt(String signatureValuePreviousReceipt) {
        this.signatureValuePreviousReceipt = signatureValuePreviousReceipt;
    }
}

