/*
 * Decompiled with CFR 0.152.
 */
package at.asitplus.regkassen.core.modules.print;

import at.asitplus.regkassen.common.MachineCodeValue;
import at.asitplus.regkassen.common.TaxType;
import at.asitplus.regkassen.common.util.CashBoxUtils;
import at.asitplus.regkassen.core.base.receiptdata.ReceiptPackage;
import at.asitplus.regkassen.core.modules.print.PrinterModule;
import at.asitplus.regkassen.core.modules.print.ReceiptPrintType;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.apache.pdfbox.exceptions.COSVisitorException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.edit.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1AfmPfbFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDPixelMap;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObject;

public class SimplePDFPrinterModule
implements PrinterModule {
    @Override
    public List<byte[]> printReceipt(List<ReceiptPackage> receiptPackages, ReceiptPrintType receiptPrintType) {
        ArrayList<byte[]> pdfReceipts = new ArrayList<byte[]>();
        for (ReceiptPackage receiptPackage : receiptPackages) {
            pdfReceipts.add(this.printReceipt(receiptPackage, receiptPrintType));
        }
        return pdfReceipts;
    }

    @Override
    public byte[] printReceipt(ReceiptPackage receiptPackage, ReceiptPrintType receiptPrintType) {
        try {
            PDDocument document = new PDDocument();
            PDPage page = new PDPage(PDPage.PAGE_SIZE_A6);
            document.addPage(page);
            PDRectangle rect = page.getMediaBox();
            PDPageContentStream cos = new PDPageContentStream(document, page);
            int line = 1;
            String qrCodeRepresentation = CashBoxUtils.getQRCodeRepresentationFromJWSCompactRepresentation((String)receiptPackage.getJwsCompactRepresentation());
            this.addTaxTypeToPDF(cos, rect, line++, CashBoxUtils.getValueFromMachineCode((String)qrCodeRepresentation, (MachineCodeValue)MachineCodeValue.SUM_TAX_SET_NORMAL), TaxType.SATZ_NORMAL);
            this.addTaxTypeToPDF(cos, rect, line++, CashBoxUtils.getValueFromMachineCode((String)qrCodeRepresentation, (MachineCodeValue)MachineCodeValue.SUM_TAX_SET_ERMAESSIGT1), TaxType.SATZ_ERMAESSIGT_1);
            this.addTaxTypeToPDF(cos, rect, line++, CashBoxUtils.getValueFromMachineCode((String)qrCodeRepresentation, (MachineCodeValue)MachineCodeValue.SUM_TAX_SET_ERMAESSIGT2), TaxType.SATZ_ERMAESSIGT_2);
            this.addTaxTypeToPDF(cos, rect, line++, CashBoxUtils.getValueFromMachineCode((String)qrCodeRepresentation, (MachineCodeValue)MachineCodeValue.SUM_TAX_SET_BESONDERS), TaxType.SATZ_BESONDERS);
            this.addTaxTypeToPDF(cos, rect, line++, CashBoxUtils.getValueFromMachineCode((String)qrCodeRepresentation, (MachineCodeValue)MachineCodeValue.SUM_TAX_SET_NULL), TaxType.SATZ_NULL);
            String signatureValue = CashBoxUtils.getValueFromMachineCode((String)qrCodeRepresentation, (MachineCodeValue)MachineCodeValue.SIGNATURE_VALUE);
            String decodedSignatureValue = new String(CashBoxUtils.base64Decode((String)signatureValue, (boolean)false));
            boolean secDeviceWasDamaged = "Sicherheitseinrichtung ausgefallen".equals(decodedSignatureValue);
            if (secDeviceWasDamaged) {
                PDType1Font fontPlain = PDType1Font.HELVETICA;
                cos.beginText();
                cos.setFont((PDFont)fontPlain, 8.0f);
                cos.moveTextPositionByAmount(20.0f, rect.getHeight() - (float)(20 * line));
                cos.drawString("SICHERHEITSEINRICHTUNG AUSGEFALLEN");
                cos.endText();
                ++line;
            }
            if (receiptPrintType == ReceiptPrintType.OCR) {
                this.addOCRCodeToPDF(document, cos, rect, line++, receiptPackage);
            } else {
                BufferedImage image = this.createQRCode(receiptPackage);
                PDPixelMap ximage = new PDPixelMap(document, image);
                float scale = 2.0f;
                cos.drawXObject((PDXObject)ximage, 25.0f, 0.0f, (float)ximage.getWidth() * 2.0f, (float)ximage.getHeight() * 2.0f);
            }
            cos.close();
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            document.save((OutputStream)bOut);
            document.close();
            return bOut.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (COSVisitorException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected void addTaxTypeToPDF(PDPageContentStream cos, PDRectangle rect, int line, String sum, TaxType taxType) {
        PDType1Font fontPlain = PDType1Font.HELVETICA;
        try {
            cos.beginText();
            cos.setFont((PDFont)fontPlain, 8.0f);
            cos.moveTextPositionByAmount(20.0f, rect.getHeight() - (float)(20 * line));
            cos.drawString(taxType.getTaxTypeString() + ": " + sum);
            cos.endText();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void addOCRCodeToPDF(PDDocument doc, PDPageContentStream cos, PDRectangle rect, int line, ReceiptPackage receiptPackage) {
        try {
            InputStream inputStreamAFM = this.getClass().getClassLoader().getResourceAsStream("OCRA.afm");
            InputStream inputStreamPFB = this.getClass().getClassLoader().getResourceAsStream("OCRA.pfb");
            PDType1AfmPfbFont font = new PDType1AfmPfbFont(doc, inputStreamAFM, inputStreamPFB);
            String ocrRepresentation = CashBoxUtils.getOCRCodeRepresentationFromJWSCompactRepresentation((String)receiptPackage.getJwsCompactRepresentation());
            int CHARS_PER_LINE = 40;
            int index = 0;
            while (index >= 0) {
                String partOCR;
                if (ocrRepresentation.length() > 40) {
                    partOCR = ocrRepresentation.substring(0, 40);
                    ocrRepresentation = ocrRepresentation.substring(40);
                } else {
                    partOCR = ocrRepresentation.substring(0);
                    index = -1;
                }
                cos.beginText();
                cos.setFont((PDFont)font, 8.0f);
                cos.moveTextPositionByAmount(20.0f, rect.getHeight() - (float)(20 * line));
                cos.drawString(partOCR);
                cos.endText();
                ++line;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected BufferedImage createQRCode(ReceiptPackage receiptPackage) {
        try {
            String qrCodeRepresentation = CashBoxUtils.getQRCodeRepresentationFromJWSCompactRepresentation((String)receiptPackage.getJwsCompactRepresentation());
            int size = 128;
            Hashtable<EncodeHintType, ErrorCorrectionLevel> hintMap = new Hashtable<EncodeHintType, ErrorCorrectionLevel>();
            hintMap.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.M);
            QRCodeWriter qrCodeWriter = new QRCodeWriter();
            BitMatrix byteMatrix = qrCodeWriter.encode(qrCodeRepresentation, BarcodeFormat.QR_CODE, 128, 128, hintMap);
            int crunchifyWidth = byteMatrix.getWidth();
            BufferedImage image = new BufferedImage(crunchifyWidth, crunchifyWidth, 1);
            image.createGraphics();
            Graphics2D graphics = (Graphics2D)image.getGraphics();
            graphics.setColor(Color.WHITE);
            graphics.fillRect(0, 0, crunchifyWidth, crunchifyWidth);
            graphics.setColor(Color.BLACK);
            for (int i = 0; i < crunchifyWidth; ++i) {
                for (int j = 0; j < crunchifyWidth; ++j) {
                    if (!byteMatrix.get(i, j)) continue;
                    graphics.fillRect(i, j, 1, 1);
                }
            }
            return image;
        }
        catch (WriterException e) {
            e.printStackTrace();
            return null;
        }
    }
}

