/*
 * Decompiled with CFR 0.152.
 */
package at.asitplus.regkassen.core.modules.signature.jws;

import at.asitplus.regkassen.common.RKSuite;
import at.asitplus.regkassen.common.util.CashBoxUtils;
import at.asitplus.regkassen.core.modules.signature.jws.AbstractJWSModule;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.crypto.ECDSASigner;
import java.security.interfaces.ECPrivateKey;

public class ComNimbusdsJwsModule
extends AbstractJWSModule {
    protected JWSSigner jwsSigner;

    @Override
    public String signMachineCodeRepOfReceipt(String machineCodeRepOfReceipt, boolean signatureDeviceIsDamaged) {
        ECPrivateKey key = (ECPrivateKey)this.openSystemSignatureModule.getSigningKey();
        try {
            this.jwsSigner = new ECDSASigner(key);
        }
        catch (JOSEException e) {
            e.printStackTrace();
        }
        if (signatureDeviceIsDamaged) {
            String jwsHeader = "eyJhbGciOiJFUzI1NiJ9";
            String jwsPayload = CashBoxUtils.base64Encode((byte[])machineCodeRepOfReceipt.getBytes(), (boolean)true);
            String jwsSignature = CashBoxUtils.base64Encode((byte[])"Sicherheitseinrichtung ausgefallen".getBytes(), (boolean)true);
            String jwsCompactRep = jwsHeader + "." + jwsPayload + "." + jwsSignature;
            return jwsCompactRep;
        }
        try {
            JWSObject jwsObject = new JWSObject(new JWSHeader(JWSAlgorithm.parse((String)RKSuite.R1_AT0.getJwsSignatureAlgorithm())), new Payload(machineCodeRepOfReceipt));
            jwsObject.sign(this.jwsSigner);
            return jwsObject.serialize();
        }
        catch (JOSEException e) {
            e.printStackTrace();
            return null;
        }
    }
}

