/*
 * Decompiled with CFR 0.152.
 */
package at.asitplus.regkassen.core.modules.signature.jws;

import at.asitplus.regkassen.common.util.CashBoxUtils;
import at.asitplus.regkassen.common.util.CryptoUtil;
import at.asitplus.regkassen.core.modules.signature.jws.AbstractJWSModule;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;

public class ManualJWSModule
extends AbstractJWSModule {
    @Override
    public String signMachineCodeRepOfReceipt(String machineCodeRepOfReceipt, boolean signatureDeviceIsDamaged) {
        try {
            if (signatureDeviceIsDamaged) {
                String jwsHeader = "eyJhbGciOiJFUzI1NiJ9";
                String jwsPayload = CashBoxUtils.base64Encode((byte[])machineCodeRepOfReceipt.getBytes(), (boolean)true);
                String jwsSignature = CashBoxUtils.base64Encode((byte[])"Sicherheitseinrichtung ausgefallen".getBytes(), (boolean)true);
                String jwsCompactRep = jwsHeader + "." + jwsPayload + "." + jwsSignature;
                return jwsCompactRep;
            }
            String jwsHeaderBase64Url = "eyJhbGciOiJFUzI1NiJ9";
            String jwsPayloadBase64Url = CashBoxUtils.base64Encode((byte[])machineCodeRepOfReceipt.getBytes(), (boolean)true);
            String jwsDataToBeSigned = jwsHeaderBase64Url + "." + jwsPayloadBase64Url;
            Signature signature = Signature.getInstance("SHA256withECDSA");
            signature.initSign(this.openSystemSignatureModule.getSigningKey());
            signature.update(jwsDataToBeSigned.getBytes());
            byte[] signatureResult = signature.sign();
            byte[] jwsSignature = CryptoUtil.convertDEREncodedSignatureToJWSConcatenated((byte[])signatureResult);
            String jwsSignatureBase64Url = CashBoxUtils.base64Encode((byte[])jwsSignature, (boolean)true);
            return jwsHeaderBase64Url + "." + jwsPayloadBase64Url + "." + jwsSignatureBase64Url;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (SignatureException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}

