/*
 * Decompiled with CFR 0.152.
 */
package at.asitplus.regkassen.core.modules.signature.rawsignatureprovider;

import at.asitplus.regkassen.common.RKSuite;
import at.asitplus.regkassen.core.modules.signature.rawsignatureprovider.SignatureModule;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.cert.CertIOException;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public class NEVER_USE_IN_A_REAL_SYSTEM_SoftwareCertificateOpenSystemSignatureModule
implements SignatureModule {
    protected PrivateKey signingKey;
    protected Certificate signingCertificate;
    protected List<Certificate> certificateChain;
    protected RKSuite rkSuite;
    protected String serialNumberOrKeyId;
    protected boolean closedSystemSignatureDevice;

    public NEVER_USE_IN_A_REAL_SYSTEM_SoftwareCertificateOpenSystemSignatureModule(RKSuite rkSuite, String keyIdForClosedSystem) {
        this.rkSuite = rkSuite;
        this.closedSystemSignatureDevice = rkSuite.getZdaID().startsWith("AT0");
        this.serialNumberOrKeyId = keyIdForClosedSystem;
        this.intialise();
    }

    public void intialise() {
        try {
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("EC");
            kpg.initialize(256);
            KeyPair caKeyPair = kpg.generateKeyPair();
            KeyPair signingKeyPair = kpg.generateKeyPair();
            PrivateKey caKey = caKeyPair.getPrivate();
            this.signingKey = signingKeyPair.getPrivate();
            X509v3CertificateBuilder caBuilder = new X509v3CertificateBuilder(new X500Name("CN=RegKassa ZDA"), BigInteger.valueOf(new SecureRandom().nextLong()), new Date(System.currentTimeMillis() - 10000L), new Date(System.currentTimeMillis() + 86400000L), new X500Name("CN=RegKassa CA"), SubjectPublicKeyInfo.getInstance((Object)caKeyPair.getPublic().getEncoded()));
            caBuilder.addExtension(X509Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(false));
            caBuilder.addExtension(X509Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(128));
            X509CertificateHolder caHolder = caBuilder.build(new JcaContentSignerBuilder("SHA256withECDSA").setProvider("BC").build(caKey));
            X509Certificate caCertificate = new JcaX509CertificateConverter().setProvider("BC").getCertificate(caHolder);
            this.certificateChain = new ArrayList<Certificate>();
            this.certificateChain.add(caCertificate);
            long serialNumberCertificate = new SecureRandom().nextLong();
            if (!this.closedSystemSignatureDevice) {
                this.serialNumberOrKeyId = Long.toHexString(serialNumberCertificate);
            }
            X509v3CertificateBuilder certBuilder = new X509v3CertificateBuilder(new X500Name("CN=RegKassa CA"), BigInteger.valueOf(Math.abs(serialNumberCertificate)), new Date(System.currentTimeMillis() - 10000L), new Date(System.currentTimeMillis() + 86400000L), new X500Name("CN=Signing certificate"), SubjectPublicKeyInfo.getInstance((Object)signingKeyPair.getPublic().getEncoded()));
            certBuilder.addExtension(X509Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(false));
            certBuilder.addExtension(X509Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(128));
            X509CertificateHolder certHolder = certBuilder.build(new JcaContentSignerBuilder("SHA256withECDSA").setProvider("BC").build(caKey));
            this.signingCertificate = new JcaX509CertificateConverter().setProvider("BC").getCertificate(certHolder);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (OperatorCreationException e) {
            e.printStackTrace();
        }
        catch (CertIOException e) {
            e.printStackTrace();
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
    }

    @Override
    public PrivateKey getSigningKey() {
        return this.signingKey;
    }

    @Override
    public Certificate getSigningCertificate() {
        return this.signingCertificate;
    }

    @Override
    public PublicKey getSigningPublicKey() {
        return this.signingCertificate.getPublicKey();
    }

    @Override
    public byte[] signData(byte[] dataToBeSigned) {
        try {
            Signature signature = Signature.getInstance("SHA256withECDSA");
            signature.initSign(this.getSigningKey());
            signature.update(dataToBeSigned);
            return signature.sign();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (SignatureException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public String getSerialNumberOfKeyID() {
        return this.serialNumberOrKeyId;
    }

    @Override
    public boolean isClosedSystemSignatureDevice() {
        return this.closedSystemSignatureDevice;
    }

    @Override
    public List<Certificate> getCertificateChain() {
        return this.certificateChain;
    }

    @Override
    public RKSuite getRKSuite() {
        return this.rkSuite;
    }
}

