/*
 * Decompiled with CFR 0.152.
 */
package at.asitplus.regkassen.core.modules.signature.rawsignatureprovider;

import at.asitplus.regkassen.common.RKSuite;
import at.asitplus.regkassen.core.modules.signature.rawsignatureprovider.SignatureModule;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import sun.security.pkcs11.SunPKCS11;

public class PKSC11SystemSignatureModule
implements SignatureModule {
    public static final String DLL_64 = "ENTER_PATH_TO_P11_LIB_64_HERE";
    public static final String DLL = "ENTER_PATH_TO_P11_LIB_HERE";
    public static final String KEY_ALIAS = "ENTER_KEY_ALIAS_HERE";
    private KeyStore ks;
    protected RKSuite rkSuite;
    protected boolean closedSystemSignatureDevice;
    protected String serialNumberOrKeyId;

    public PKSC11SystemSignatureModule(RKSuite rkSuite, String keyIdForClosedSystem) {
        this.closedSystemSignatureDevice = rkSuite.getSuiteID().startsWith("AT0");
        this.serialNumberOrKeyId = keyIdForClosedSystem;
        this.initialize();
    }

    private void initialize() {
        String arch = System.getProperty("sun.arch.data.model");
        String pkcs11ConfigSettings = null;
        if (arch.equalsIgnoreCase("64")) {
            pkcs11ConfigSettings = "name=pkcs11\nlibrary=ENTER_PATH_TO_P11_LIB_64_HERE";
        } else if (arch.equalsIgnoreCase("86")) {
            pkcs11ConfigSettings = "name=pkcs11\nlibrary=ENTER_PATH_TO_P11_LIB_HERE";
        } else {
            System.err.println("Error: unknown architecture: " + arch);
            return;
        }
        byte[] pkcs11ConfigBytes = pkcs11ConfigSettings.getBytes();
        ByteArrayInputStream confStream = new ByteArrayInputStream(pkcs11ConfigBytes);
        SunPKCS11 pkcs11 = new SunPKCS11((InputStream)confStream);
        Security.addProvider(pkcs11);
        try {
            this.ks = KeyStore.getInstance("PKCS11");
            this.ks.load(null, null);
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public PrivateKey getSigningKey() {
        try {
            return (PrivateKey)this.ks.getKey(KEY_ALIAS, null);
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
            return null;
        }
        catch (UnrecoverableKeyException e) {
            e.printStackTrace();
            return null;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Certificate getSigningCertificate() {
        try {
            Certificate c = this.ks.getCertificate(KEY_ALIAS);
            return c;
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public List<Certificate> getCertificateChain() {
        try {
            Certificate[] chain = this.ks.getCertificateChain(KEY_ALIAS);
            return new ArrayList<Certificate>(Arrays.asList(chain));
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public PublicKey getSigningPublicKey() {
        try {
            X509Certificate c = (X509Certificate)this.ks.getCertificate(KEY_ALIAS);
            return c.getPublicKey();
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public byte[] signData(byte[] dataToBeSigned) {
        try {
            Signature signature = Signature.getInstance("SHA256withECDSA");
            signature.initSign(this.getSigningKey());
            signature.update(dataToBeSigned);
            return signature.sign();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (SignatureException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public String getSerialNumberOfKeyID() {
        if (this.closedSystemSignatureDevice) {
            return this.serialNumberOrKeyId;
        }
        try {
            X509Certificate c = (X509Certificate)this.ks.getCertificate(KEY_ALIAS);
            return Long.toHexString(c.getSerialNumber().longValue());
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean isClosedSystemSignatureDevice() {
        return this.closedSystemSignatureDevice;
    }

    @Override
    public RKSuite getRKSuite() {
        return this.rkSuite;
    }
}

