/*
 * Decompiled with CFR 0.152.
 */
package at.asitplus.regkassenprototyping.testdb;

import at.asitplus.regkassen.common.MachineCodeValue;
import at.asitplus.regkassen.common.util.CashBoxUtils;
import at.asitplus.regkassen.verification.common.BaseVerificationModule;
import at.asitplus.regkassen.verification.common.data.AuthLevel;
import at.asitplus.regkassen.verification.common.data.VerificationInputOutput;
import at.asitplus.regkassen.verification.common.data.VerificationProperty;
import at.asitplus.regkassen.verification.common.data.VerificationResult;
import at.asitplus.regkassenprototyping.testdb.TestDB;
import at.asitplus.regkassenprototyping.testdb.testdata.DBTestcase;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class GeneratedTestDB
implements TestDB {
    private final Map<String, String> cashBoxId2AESKey;
    private final Map<String, String> id2certOrPubKey;
    private final Set<String> receipts = new HashSet<String>();

    public GeneratedTestDB(Collection<DBTestcase> object) {
        this.cashBoxId2AESKey = new HashMap<String, String>();
        this.id2certOrPubKey = new HashMap<String, String>();
        object = object.iterator();
        while (object.hasNext()) {
            DBTestcase dBTestcase = (DBTestcase)object.next();
            this.cashBoxId2AESKey.put(CashBoxUtils.getValueFromMachineCode((String)dBTestcase.getReceipt(), (MachineCodeValue)MachineCodeValue.CASHBOX_ID), dBTestcase.getBase64AESKey());
            this.id2certOrPubKey.put(CashBoxUtils.getValueFromMachineCode((String)dBTestcase.getReceipt(), (MachineCodeValue)MachineCodeValue.CERTIFICATE_SERIAL_NUMBER_OR_COMPANYID_AND_KEYID), dBTestcase.getBase64CertOrPK());
            this.receipts.add(dBTestcase.getReceipt());
        }
    }

    @Override
    public String getAesKey1(String string) {
        return this.cashBoxId2AESKey.get(string);
    }

    @Override
    public String getPubKeyOrCert(String string) {
        return this.id2certOrPubKey.get(string);
    }

    public Set<String> getReceipts() {
        return new HashSet<String>(this.receipts);
    }

    @Override
    public String getAesKey2(String string) {
        return this.cashBoxId2AESKey.get(string);
    }

    public static VerificationResult prepareReceipt(String string) {
        return BaseVerificationModule.prepareInput((VerificationProperty[])new VerificationProperty[]{new VerificationProperty(VerificationInputOutput.RECEIPT, string), new VerificationProperty(VerificationInputOutput.AUTH_LEVEL, (Enum)AuthLevel.CASHBOX), new VerificationProperty(VerificationInputOutput.LANGUAGE, "de"), new VerificationProperty(VerificationInputOutput.AUTH_CODE, "dummy"), new VerificationProperty(VerificationInputOutput.SID, Integer.toHexString(CashBoxUtils.getValueFromMachineCode((String)string, (MachineCodeValue)MachineCodeValue.CERTIFICATE_SERIAL_NUMBER_OR_COMPANYID_AND_KEYID).hashCode()))});
    }
}

