/*
 * Decompiled with CFR 0.152.
 */
package at.asitplus.regkassenprototyping.testdb;

import at.asitplus.regkassen.common.MachineCodeValue;
import at.asitplus.regkassen.common.util.CashBoxUtils;
import at.asitplus.regkassen.core.base.cashboxsimulation.CertificateOrPublicKeyContainer;
import at.asitplus.regkassen.core.base.cashboxsimulation.CryptographicMaterialContainer;
import at.asitplus.regkassen.verification.common.rpc.RKObjectMapper;
import at.asitplus.regkassenprototyping.testdb.TestDB;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;

public class TestDatabase
implements TestDB {
    private static TestDatabase instance;
    private static final String ROOT = "example-output-0.7.1";
    private static final String RECEIPTS = "qr-code-rep.json";
    private static final String SCENARIO_DESCRIPTION = "TESTSUITE_TEST_SZENARIO_[0-9]+\\.json";
    private static final String CBID = "cashBoxId";
    private static final String AESKEY = "base64AesKey";
    private static final String CRYPTO_CONTAINER = "cryptographicMaterialContainer.json";
    private final Map<String, String> cashBoxId2AESKey;
    private final Map<String, String> id2certOrPubKey;
    private final Set<String> closedReceipts = new HashSet<String>();
    private final Set<String> openReceipts = new HashSet<String>();
    private final Set<String> receiptsIDsWithWorkingSignatureDevices = new HashSet<String>();

    public static TestDatabase getInstance() {
        if (instance == null) {
            try {
                instance = new TestDatabase();
            }
            catch (IOException iOException) {
                IOException iOException2 = iOException;
                iOException.printStackTrace();
            }
        }
        return instance;
    }

    private TestDatabase() throws IOException {
        Object object = new Reflections("", new Scanner[]{new ResourcesScanner()});
        object = object.getResources(Pattern.compile(".*\\.json"));
        this.cashBoxId2AESKey = new HashMap<String, String>();
        this.id2certOrPubKey = new HashMap<String, String>();
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (String)object.next();
            if (!((String)object2).startsWith(ROOT)) continue;
            Object object3 = ((String)object2).split(Pattern.quote("/"));
            if (((String)(object3 = object3[((String[])object3).length - 1])).matches(SCENARIO_DESCRIPTION)) {
                object3 = (JsonNode)RKObjectMapper.load((InputStream)this.getClass().getClassLoader().getResourceAsStream((String)object2), JsonNode.class);
                this.cashBoxId2AESKey.put(object3.get(CBID).textValue(), object3.get(AESKEY).textValue());
                object2 = object3.get("cashBoxInstructionList").elements();
                while (object2.hasNext()) {
                    object3 = (JsonNode)object2.next();
                    if (object3.get("signatureDeviceDamaged").booleanValue()) continue;
                    String string = object3.get("receiptIdentifier").textValue();
                    this.receiptsIDsWithWorkingSignatureDevices.add(string);
                }
                continue;
            }
            if (((String)object3).equals(CRYPTO_CONTAINER)) {
                object3 = (CryptographicMaterialContainer)RKObjectMapper.load((InputStream)this.getClass().getClassLoader().getResourceAsStream((String)object2), CryptographicMaterialContainer.class);
                object2 = object3.getCertificateOrPublicKeyMap();
                for (String string : object2.keySet()) {
                    this.id2certOrPubKey.put(string, ((CertificateOrPublicKeyContainer)object2.get(string)).getSignatureCertificateOrPublicKey());
                }
                continue;
            }
            if (!((String)object3).equals(RECEIPTS)) continue;
            object3 = (String[])RKObjectMapper.load((InputStream)this.getClass().getClassLoader().getResourceAsStream((String)object2), String[].class);
            if (((String)object2).contains("closed")) {
                this.closedReceipts.addAll(Arrays.asList(object3));
                continue;
            }
            this.openReceipts.addAll(Arrays.asList(object3));
        }
    }

    public Set<String> getReceipts(boolean bl) {
        return new HashSet<String>(bl ? this.closedReceipts : this.openReceipts);
    }

    public Set<String> getSerialnumbers(boolean bl) {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : this.getReceipts(bl)) {
            hashSet.add(CashBoxUtils.getValueFromMachineCode((String)string, (MachineCodeValue)MachineCodeValue.CERTIFICATE_SERIAL_NUMBER_OR_COMPANYID_AND_KEYID));
        }
        return hashSet;
    }

    public Set<String> getReceiptsIDsWithWorkingSignatureDevices() {
        return this.receiptsIDsWithWorkingSignatureDevices;
    }

    public void print() {
        System.out.println(RKObjectMapper.stringify(this.cashBoxId2AESKey));
        System.out.println(RKObjectMapper.stringify(this.id2certOrPubKey));
    }

    @Override
    public String getPubKeyOrCert(String string) {
        if (!this.id2certOrPubKey.containsKey(string)) {
            return null;
        }
        return this.id2certOrPubKey.get(string);
    }

    public Set<String> getMismatchingPubkeys(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(this.id2certOrPubKey.values());
        hashSet.remove(this.getPubKeyOrCert(string));
        return hashSet;
    }

    @Override
    public String getAesKey1(String string) {
        if (!this.cashBoxId2AESKey.containsKey(string)) {
            return null;
        }
        return this.cashBoxId2AESKey.get(string);
    }

    @Override
    public String getAesKey2(String string) {
        if (!this.cashBoxId2AESKey.containsKey(string)) {
            return null;
        }
        return this.cashBoxId2AESKey.get(string);
    }
}

