/*
 * Decompiled with CFR 0.152.
 */
package at.asitplus.regkassenprototyping.testdb.testdata;

import at.asitplus.regkassen.common.MachineCodeValue;
import at.asitplus.regkassen.common.TypeOfReceipt;
import at.asitplus.regkassen.common.util.CashBoxUtils;
import at.asitplus.regkassen.verification.common.rpc.RKObjectMapper;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;

public class DBTestcase {
    private final String receipt;
    private final String base64AESKey;
    private final String base64CertOrPK;
    private final TypeOfReceipt receiptType;
    private final boolean signed;
    private final boolean closed;

    public DBTestcase(String string, SecretKey secretKey, PublicKey publicKey, TypeOfReceipt typeOfReceipt) {
        this(string, CashBoxUtils.base64Encode((byte[])secretKey.getEncoded(), (boolean)false), CashBoxUtils.base64Encode((byte[])publicKey.getEncoded(), (boolean)false), typeOfReceipt, CashBoxUtils.getValueFromMachineCode((String)string, (MachineCodeValue)MachineCodeValue.SIGNATURE_VALUE).equals("U2ljaGVyaGVpdHNlaW5yaWNodHVuZyBhdXNnZWZhbGxlbg=="), CashBoxUtils.getValueFromMachineCode((String)string, (MachineCodeValue)MachineCodeValue.CERTIFICATE_SERIAL_NUMBER_OR_COMPANYID_AND_KEYID).contains("-"));
    }

    public DBTestcase(String string, SecretKey secretKey, X509Certificate x509Certificate, TypeOfReceipt typeOfReceipt) throws CertificateEncodingException {
        this(string, CashBoxUtils.base64Encode((byte[])secretKey.getEncoded(), (boolean)false), CashBoxUtils.base64Encode((byte[])x509Certificate.getEncoded(), (boolean)false), typeOfReceipt, CashBoxUtils.getValueFromMachineCode((String)string, (MachineCodeValue)MachineCodeValue.SIGNATURE_VALUE).equals("U2ljaGVyaGVpdHNlaW5yaWNodHVuZyBhdXNnZWZhbGxlbg=="), CashBoxUtils.getValueFromMachineCode((String)string, (MachineCodeValue)MachineCodeValue.CERTIFICATE_SERIAL_NUMBER_OR_COMPANYID_AND_KEYID).contains("-"));
    }

    private DBTestcase(String string, String string2, String string3, TypeOfReceipt typeOfReceipt, boolean bl, boolean bl2) {
        this.receipt = string;
        this.base64AESKey = string2;
        this.base64CertOrPK = string3;
        this.signed = bl;
        this.receiptType = typeOfReceipt;
        this.closed = bl2;
    }

    public String getReceipt() {
        return this.receipt;
    }

    public String getBase64AESKey() {
        return this.base64AESKey;
    }

    public String getBase64CertOrPK() {
        return this.base64CertOrPK;
    }

    public TypeOfReceipt getReceiptType() {
        return this.receiptType;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public String toString() {
        return RKObjectMapper.stringify((Object)this);
    }
}

