/*
 * Decompiled with CFR 0.152.
 */
package at.asitplus.regkassenprototyping.testdb.testdata;

import at.asitplus.regkassen.common.RKSuite;
import at.asitplus.regkassen.common.TypeOfReceipt;
import at.asitplus.regkassen.common.util.CashBoxUtils;
import at.asitplus.regkassen.common.util.CryptoUtil;
import at.asitplus.regkassen.core.DemoCashBox;
import at.asitplus.regkassen.core.base.cashboxsimulation.CashBoxInstruction;
import at.asitplus.regkassen.core.base.cashboxsimulation.CashBoxSimulation;
import at.asitplus.regkassen.core.base.receiptdata.ReceiptPackage;
import at.asitplus.regkassen.core.base.receiptdata.SimplifiedReceipt;
import at.asitplus.regkassen.core.modules.DEP.DEPModule;
import at.asitplus.regkassen.core.modules.DEP.SimpleMemoryDEPModule;
import at.asitplus.regkassen.core.modules.init.CashBoxParameters;
import at.asitplus.regkassen.core.modules.print.PrinterModule;
import at.asitplus.regkassen.core.modules.print.SimplePDFPrinterModule;
import at.asitplus.regkassen.core.modules.signature.jws.JWSModule;
import at.asitplus.regkassen.core.modules.signature.jws.ManualJWSModule;
import at.asitplus.regkassen.core.modules.signature.rawsignatureprovider.NEVER_USE_IN_A_REAL_SYSTEM_SoftwareCertificateOpenSystemSignatureModule;
import at.asitplus.regkassen.core.modules.signature.rawsignatureprovider.NEVER_USE_IN_A_REAL_SYSTEM_SoftwareKeySignatureModule;
import at.asitplus.regkassen.core.modules.signature.rawsignatureprovider.SignatureModule;
import at.asitplus.regkassenprototyping.testdb.testdata.DBTestcase;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;

public class TestcaseGenerator {
    private static Random rnd = new Random(42L);

    public static DBTestcase generate(boolean bl, TypeOfReceipt typeOfReceipt, boolean bl2) {
        byte[] byArray = new byte[24];
        rnd.nextBytes(byArray);
        return TestcaseGenerator.generate(bl, typeOfReceipt, bl2, CashBoxUtils.base64Encode((byte[])byArray, (boolean)false));
    }

    public static DBTestcase generate(boolean bl, TypeOfReceipt typeOfReceipt, boolean bl2, String object) {
        Object object2;
        Object object3;
        CashBoxSimulation cashBoxSimulation = new CashBoxSimulation();
        cashBoxSimulation.setCashBoxId((String)object);
        cashBoxSimulation.setCompanyID("U:ATU12345678");
        cashBoxSimulation.setNumberOfSignatureDevices(1);
        object = CryptoUtil.createAESKey();
        cashBoxSimulation.setBase64AesKey(CashBoxUtils.base64Encode((byte[])object.getEncoded(), (boolean)false));
        cashBoxSimulation.setSimulationRunLabel("Test Case Generator");
        object = new CashBoxInstruction();
        byte[] byArray = new byte[24];
        rnd.nextBytes(byArray);
        object.setReceiptIdentifier(CashBoxUtils.base64Encode((byte[])byArray, (boolean)false));
        object.setSignatureDeviceDamaged(Boolean.valueOf(!bl2));
        object.setTypeOfReceipt(typeOfReceipt);
        object.setDateToUse(CashBoxUtils.convertDateToISO8601((Date)new Date()));
        object.setUsedSignatureDevice(Integer.valueOf(0));
        SimplifiedReceipt simplifiedReceipt = new SimplifiedReceipt();
        simplifiedReceipt.setTaxSetBesonders(Double.valueOf(1.0));
        simplifiedReceipt.setTaxSetErmaessigt1(Double.valueOf(20.0));
        simplifiedReceipt.setTaxSetErmaessigt2(Double.valueOf(4.0));
        simplifiedReceipt.setTaxSetNormal(Double.valueOf(0.9));
        simplifiedReceipt.setTaxSetNull(Double.valueOf(0.55));
        object.setSimplifiedReceipt(simplifiedReceipt);
        CashBoxParameters cashBoxParameters = new CashBoxParameters();
        cashBoxParameters.setCashBoxId(cashBoxSimulation.getCashBoxId());
        cashBoxParameters.setTurnOverCounterAESKey(CryptoUtil.convertBase64KeyToSecretKey((String)cashBoxSimulation.getBase64AesKey()));
        cashBoxParameters.setDepModul((DEPModule)new SimpleMemoryDEPModule());
        cashBoxParameters.setPrinterModule((PrinterModule)new SimplePDFPrinterModule());
        cashBoxParameters.setCompanyID(cashBoxSimulation.getCompanyID());
        for (int i = 0; i < cashBoxSimulation.getNumberOfSignatureDevices(); ++i) {
            object3 = new ManualJWSModule();
            object2 = !bl ? new NEVER_USE_IN_A_REAL_SYSTEM_SoftwareCertificateOpenSystemSignatureModule(RKSuite.R1_AT100, null) : new NEVER_USE_IN_A_REAL_SYSTEM_SoftwareKeySignatureModule(cashBoxSimulation.getCompanyID() + "-K" + new BigInteger(byArray).abs().toString());
            object3.setOpenSystemSignatureModule((SignatureModule)object2);
            cashBoxParameters.getJwsSignatureModules().add(object3);
        }
        DemoCashBox demoCashBox = new DemoCashBox(cashBoxParameters);
        object3 = new LinkedList();
        if (typeOfReceipt != TypeOfReceipt.START_BELEG) {
            object2 = new CashBoxInstruction();
            object2.setReceiptIdentifier(CashBoxUtils.base64Encode((byte[])byArray, (boolean)false));
            object2.setSignatureDeviceDamaged(Boolean.valueOf(!bl2));
            object2.setTypeOfReceipt(TypeOfReceipt.START_BELEG);
            object2.setDateToUse(CashBoxUtils.convertDateToISO8601((Date)new Date()));
            object2.setUsedSignatureDevice(Integer.valueOf(0));
            object2.setSimplifiedReceipt(simplifiedReceipt);
            object3.add(object2);
        }
        object3.add(object);
        cashBoxSimulation.setCashBoxInstructionList((List)object3);
        demoCashBox.executeSimulation(cashBoxSimulation.getCashBoxInstructionList());
        object2 = (ReceiptPackage)demoCashBox.getStoredReceipts().get(typeOfReceipt == TypeOfReceipt.START_BELEG ? 0 : 1);
        String string = object2.getJwsCompactRepresentation();
        string = CashBoxUtils.getQRCodeRepresentationFromJWSCompactRepresentation((String)string);
        object = null;
        if (bl) {
            PublicKey publicKey = ((JWSModule)demoCashBox.getCashBoxParameters().getJwsSignatureModules().get(0)).getSignatureModule().getSigningPublicKey();
            object = new DBTestcase(string, cashBoxParameters.getTurnOverCounterAESKey(), publicKey, typeOfReceipt);
        } else {
            Serializable serializable = ((JWSModule)demoCashBox.getCashBoxParameters().getJwsSignatureModules().get(0)).getSignatureModule().getSigningCertificate();
            try {
                object = new DBTestcase(string, cashBoxParameters.getTurnOverCounterAESKey(), (X509Certificate)serializable, typeOfReceipt);
            }
            catch (CertificateEncodingException certificateEncodingException) {
                serializable = certificateEncodingException;
                certificateEncodingException.printStackTrace();
            }
        }
        return object;
    }
}

