/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fonts.CIDFont;
import org.apache.fop.fonts.CodePointMapping;
import org.apache.fop.fonts.CustomFont;
import org.apache.fop.fonts.EmbeddingMode;
import org.apache.fop.fonts.FontDescriptor;
import org.apache.fop.fonts.FontMetrics;
import org.apache.fop.fonts.FontType;
import org.apache.fop.fonts.LazyFont;
import org.apache.fop.fonts.MultiByteFont;
import org.apache.fop.fonts.SimpleSingleByteEncoding;
import org.apache.fop.fonts.SingleByteEncoding;
import org.apache.fop.fonts.SingleByteFont;
import org.apache.fop.fonts.Typeface;
import org.apache.fop.fonts.truetype.FontFileReader;
import org.apache.fop.fonts.truetype.TTFSubSetFile;
import org.apache.fop.fonts.type1.PFBData;
import org.apache.fop.fonts.type1.PFBParser;
import org.apache.fop.pdf.AbstractPDFFontStream;
import org.apache.fop.pdf.AbstractPDFStream;
import org.apache.fop.pdf.PDFAction;
import org.apache.fop.pdf.PDFAnnotList;
import org.apache.fop.pdf.PDFArray;
import org.apache.fop.pdf.PDFCIDFont;
import org.apache.fop.pdf.PDFCIDFontDescriptor;
import org.apache.fop.pdf.PDFCIDSystemInfo;
import org.apache.fop.pdf.PDFDestination;
import org.apache.fop.pdf.PDFDests;
import org.apache.fop.pdf.PDFDeviceColorSpace;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFEmbeddedFiles;
import org.apache.fop.pdf.PDFEncoding;
import org.apache.fop.pdf.PDFFileSpec;
import org.apache.fop.pdf.PDFFont;
import org.apache.fop.pdf.PDFFontDescriptor;
import org.apache.fop.pdf.PDFFontNonBase14;
import org.apache.fop.pdf.PDFFontType0;
import org.apache.fop.pdf.PDFFunction;
import org.apache.fop.pdf.PDFGState;
import org.apache.fop.pdf.PDFGoTo;
import org.apache.fop.pdf.PDFGoToRemote;
import org.apache.fop.pdf.PDFICCBasedColorSpace;
import org.apache.fop.pdf.PDFICCStream;
import org.apache.fop.pdf.PDFInfo;
import org.apache.fop.pdf.PDFInternalLink;
import org.apache.fop.pdf.PDFJavaScriptLaunchAction;
import org.apache.fop.pdf.PDFLaunch;
import org.apache.fop.pdf.PDFLink;
import org.apache.fop.pdf.PDFMetadata;
import org.apache.fop.pdf.PDFNameTreeNode;
import org.apache.fop.pdf.PDFNames;
import org.apache.fop.pdf.PDFOutline;
import org.apache.fop.pdf.PDFOutputIntent;
import org.apache.fop.pdf.PDFPage;
import org.apache.fop.pdf.PDFPageLabels;
import org.apache.fop.pdf.PDFPages;
import org.apache.fop.pdf.PDFPattern;
import org.apache.fop.pdf.PDFRectangle;
import org.apache.fop.pdf.PDFReference;
import org.apache.fop.pdf.PDFResourceContext;
import org.apache.fop.pdf.PDFResources;
import org.apache.fop.pdf.PDFRoot;
import org.apache.fop.pdf.PDFSeparationColorSpace;
import org.apache.fop.pdf.PDFShading;
import org.apache.fop.pdf.PDFStream;
import org.apache.fop.pdf.PDFT1Stream;
import org.apache.fop.pdf.PDFTTFStream;
import org.apache.fop.pdf.PDFText;
import org.apache.fop.pdf.PDFToUnicodeCMap;
import org.apache.fop.pdf.PDFUri;
import org.apache.fop.pdf.PDFWArray;
import org.apache.xmlgraphics.java2d.color.ColorUtil;
import org.apache.xmlgraphics.java2d.color.NamedColorSpace;
import org.apache.xmlgraphics.xmp.Metadata;

public class PDFFactory {
    public static final int DEFAULT_PDF_RESOLUTION = 72;
    private PDFDocument document;
    private Log log = LogFactory.getLog(PDFFactory.class);
    private int subsetFontCounter = -1;
    private static final String EMBEDDED_FILE = "embedded-file:";

    public PDFFactory(PDFDocument document) {
        this.document = document;
    }

    public final PDFDocument getDocument() {
        return this.document;
    }

    public PDFRoot makeRoot(PDFPages pages) {
        PDFRoot pdfRoot = new PDFRoot(++this.document.objectcount, pages);
        pdfRoot.setDocument(this.getDocument());
        this.getDocument().addTrailerObject(pdfRoot);
        return pdfRoot;
    }

    public PDFPages makePages() {
        PDFPages pdfPages = new PDFPages(++this.document.objectcount);
        pdfPages.setDocument(this.getDocument());
        this.getDocument().addTrailerObject(pdfPages);
        return pdfPages;
    }

    public PDFResources makeResources() {
        PDFResources pdfResources = new PDFResources(++this.document.objectcount);
        pdfResources.setDocument(this.getDocument());
        this.getDocument().addTrailerObject(pdfResources);
        return pdfResources;
    }

    protected PDFInfo makeInfo(String prod) {
        PDFInfo pdfInfo = new PDFInfo();
        pdfInfo.setProducer(prod);
        this.getDocument().registerObject(pdfInfo);
        return pdfInfo;
    }

    public PDFMetadata makeMetadata(Metadata meta, boolean readOnly) {
        PDFMetadata pdfMetadata = new PDFMetadata(meta, readOnly);
        this.getDocument().registerObject(pdfMetadata);
        return pdfMetadata;
    }

    public PDFOutputIntent makeOutputIntent() {
        PDFOutputIntent outputIntent = new PDFOutputIntent();
        this.getDocument().registerObject(outputIntent);
        return outputIntent;
    }

    public PDFPage makePage(PDFResources resources, int pageIndex, Rectangle2D mediaBox, Rectangle2D cropBox, Rectangle2D bleedBox, Rectangle2D trimBox) {
        PDFPage page = new PDFPage(resources, pageIndex, mediaBox, cropBox, bleedBox, trimBox);
        this.getDocument().assignObjectNumber(page);
        this.getDocument().getPages().addPage(page);
        return page;
    }

    public PDFPage makePage(PDFResources resources, int pageWidth, int pageHeight, int pageIndex) {
        Rectangle2D.Double mediaBox = new Rectangle2D.Double(0.0, 0.0, pageWidth, pageHeight);
        return this.makePage(resources, pageIndex, mediaBox, mediaBox, mediaBox, mediaBox);
    }

    public PDFPage makePage(PDFResources resources, int pageWidth, int pageHeight) {
        return this.makePage(resources, pageWidth, pageHeight, -1);
    }

    public PDFFunction makeFunction(int theFunctionType, List theDomain, List theRange, List theSize, int theBitsPerSample, int theOrder, List theEncode, List theDecode, StringBuffer theFunctionDataStream, List theFilter) {
        PDFFunction function = new PDFFunction(theFunctionType, theDomain, theRange, theSize, theBitsPerSample, theOrder, theEncode, theDecode, theFunctionDataStream, theFilter);
        PDFFunction oldfunc = this.getDocument().findFunction(function);
        if (oldfunc == null) {
            this.getDocument().registerObject(function);
        } else {
            function = oldfunc;
        }
        return function;
    }

    public PDFFunction makeFunction(int theFunctionType, List theDomain, List theRange, List theCZero, List theCOne, double theInterpolationExponentN) {
        PDFFunction function = new PDFFunction(theFunctionType, theDomain, theRange, theCZero, theCOne, theInterpolationExponentN);
        PDFFunction oldfunc = this.getDocument().findFunction(function);
        if (oldfunc == null) {
            this.getDocument().registerObject(function);
        } else {
            function = oldfunc;
        }
        return function;
    }

    public PDFFunction makeFunction(int theFunctionType, List theDomain, List theRange, List theFunctions, List theBounds, List theEncode) {
        PDFFunction function = new PDFFunction(theFunctionType, theDomain, theRange, theFunctions, theBounds, theEncode);
        PDFFunction oldfunc = this.getDocument().findFunction(function);
        if (oldfunc == null) {
            this.getDocument().registerObject(function);
        } else {
            function = oldfunc;
        }
        return function;
    }

    public PDFFunction makeFunction(int theNumber, int theFunctionType, List theDomain, List theRange, StringBuffer theFunctionDataStream) {
        PDFFunction function = new PDFFunction(theFunctionType, theDomain, theRange, theFunctionDataStream);
        PDFFunction oldfunc = this.getDocument().findFunction(function);
        if (oldfunc == null) {
            this.getDocument().registerObject(function);
        } else {
            function = oldfunc;
        }
        return function;
    }

    public PDFShading makeShading(PDFResourceContext res, int theShadingType, PDFDeviceColorSpace theColorSpace, List theBackground, List theBBox, boolean theAntiAlias, List theDomain, List theMatrix, PDFFunction theFunction) {
        PDFShading shading = new PDFShading(theShadingType, theColorSpace, theBackground, theBBox, theAntiAlias, theDomain, theMatrix, theFunction);
        PDFShading oldshad = this.getDocument().findShading(shading);
        if (oldshad == null) {
            this.getDocument().registerObject(shading);
        } else {
            shading = oldshad;
        }
        if (res != null) {
            res.getPDFResources().addShading(shading);
        } else {
            this.getDocument().getResources().addShading(shading);
        }
        return shading;
    }

    public PDFShading makeShading(PDFResourceContext res, int theShadingType, PDFDeviceColorSpace theColorSpace, List theBackground, List theBBox, boolean theAntiAlias, List theCoords, List theDomain, PDFFunction theFunction, List theExtend) {
        PDFShading shading = new PDFShading(theShadingType, theColorSpace, theBackground, theBBox, theAntiAlias, theCoords, theDomain, theFunction, theExtend);
        PDFShading oldshad = this.getDocument().findShading(shading);
        if (oldshad == null) {
            this.getDocument().registerObject(shading);
        } else {
            shading = oldshad;
        }
        if (res != null) {
            res.getPDFResources().addShading(shading);
        } else {
            this.getDocument().getResources().addShading(shading);
        }
        return shading;
    }

    public PDFShading makeShading(PDFResourceContext res, int theShadingType, PDFDeviceColorSpace theColorSpace, List theBackground, List theBBox, boolean theAntiAlias, int theBitsPerCoordinate, int theBitsPerComponent, int theBitsPerFlag, List theDecode, PDFFunction theFunction) {
        PDFShading shading = new PDFShading(theShadingType, theColorSpace, theBackground, theBBox, theAntiAlias, theBitsPerCoordinate, theBitsPerComponent, theBitsPerFlag, theDecode, theFunction);
        PDFShading oldshad = this.getDocument().findShading(shading);
        if (oldshad == null) {
            this.getDocument().registerObject(shading);
        } else {
            shading = oldshad;
        }
        if (res != null) {
            res.getPDFResources().addShading(shading);
        } else {
            this.getDocument().getResources().addShading(shading);
        }
        return shading;
    }

    public PDFShading makeShading(PDFResourceContext res, int theShadingType, PDFDeviceColorSpace theColorSpace, List theBackground, List theBBox, boolean theAntiAlias, int theBitsPerCoordinate, int theBitsPerComponent, List theDecode, int theVerticesPerRow, PDFFunction theFunction) {
        PDFShading shading = new PDFShading(theShadingType, theColorSpace, theBackground, theBBox, theAntiAlias, theBitsPerCoordinate, theBitsPerComponent, theDecode, theVerticesPerRow, theFunction);
        PDFShading oldshad = this.getDocument().findShading(shading);
        if (oldshad == null) {
            this.getDocument().registerObject(shading);
        } else {
            shading = oldshad;
        }
        if (res != null) {
            res.getPDFResources().addShading(shading);
        } else {
            this.getDocument().getResources().addShading(shading);
        }
        return shading;
    }

    public PDFPattern makePattern(PDFResourceContext res, int thePatternType, PDFResources theResources, int thePaintType, int theTilingType, List theBBox, double theXStep, double theYStep, List theMatrix, List theXUID, StringBuffer thePatternDataStream) {
        PDFPattern pattern = new PDFPattern(theResources, 1, thePaintType, theTilingType, theBBox, theXStep, theYStep, theMatrix, theXUID, thePatternDataStream);
        PDFPattern oldpatt = this.getDocument().findPattern(pattern);
        if (oldpatt == null) {
            this.getDocument().registerObject(pattern);
        } else {
            pattern = oldpatt;
        }
        if (res != null) {
            res.getPDFResources().addPattern(pattern);
        } else {
            this.getDocument().getResources().addPattern(pattern);
        }
        return pattern;
    }

    public PDFPattern makePattern(PDFResourceContext res, int thePatternType, PDFShading theShading, List theXUID, StringBuffer theExtGState, List theMatrix) {
        PDFPattern pattern = new PDFPattern(2, theShading, theXUID, theExtGState, theMatrix);
        PDFPattern oldpatt = this.getDocument().findPattern(pattern);
        if (oldpatt == null) {
            this.getDocument().registerObject(pattern);
        } else {
            pattern = oldpatt;
        }
        if (res != null) {
            res.getPDFResources().addPattern(pattern);
        } else {
            this.getDocument().getResources().addPattern(pattern);
        }
        return pattern;
    }

    public PDFPattern makeGradient(PDFResourceContext res, boolean radial, PDFDeviceColorSpace theColorspace, List theColors, List theBounds, List theCoords, List theMatrix) {
        PDFShading myShad;
        double interpolation = 1.0;
        ArrayList<PDFFunction> theFunctions = new ArrayList<PDFFunction>();
        int lastPosition = theColors.size() - 1;
        for (int currentPosition = 0; currentPosition < lastPosition; ++currentPosition) {
            Color currentColor = (Color)theColors.get(currentPosition);
            Color nextColor = (Color)theColors.get(currentPosition + 1);
            if (!currentColor.getColorSpace().isCS_sRGB()) {
                currentColor = ColorUtil.toSRGBColor((Color)currentColor);
                theColors.set(currentPosition, currentColor);
            }
            if (!nextColor.getColorSpace().isCS_sRGB()) {
                nextColor = ColorUtil.toSRGBColor((Color)nextColor);
                theColors.set(currentPosition + 1, nextColor);
            }
            List theCzero = this.toColorVector(currentColor);
            List theCone = this.toColorVector(nextColor);
            PDFFunction myfunc = this.makeFunction(2, null, null, theCzero, theCone, interpolation);
            theFunctions.add(myfunc);
        }
        PDFFunction myfunky = this.makeFunction(3, null, null, theFunctions, theBounds, null);
        if (radial) {
            if (theCoords.size() == 6) {
                myShad = this.makeShading(res, 3, this.getDocument().getPDFColorSpace(), null, null, false, theCoords, null, myfunky, null);
            } else {
                ArrayList newCoords = new ArrayList();
                newCoords.add(theCoords.get(0));
                newCoords.add(theCoords.get(1));
                newCoords.add(theCoords.get(2));
                newCoords.add(theCoords.get(0));
                newCoords.add(theCoords.get(1));
                newCoords.add(new Double(0.0));
                myShad = this.makeShading(res, 3, this.getDocument().getPDFColorSpace(), null, null, false, newCoords, null, myfunky, null);
            }
        } else {
            myShad = this.makeShading(res, 2, this.getDocument().getPDFColorSpace(), null, null, false, theCoords, null, myfunky, null);
        }
        PDFPattern myPattern = this.makePattern(res, 2, myShad, null, null, theMatrix);
        return myPattern;
    }

    private List toColorVector(Color nextColor) {
        ArrayList<Double> vector = new ArrayList<Double>();
        float[] comps = nextColor.getColorComponents(null);
        int c = comps.length;
        for (int i = 0; i < c; ++i) {
            vector.add(new Double(comps[i]));
        }
        return vector;
    }

    protected PDFDestination getUniqueDestination(PDFDestination newdest) {
        PDFDestination existing = this.getDocument().findDestination(newdest);
        if (existing != null) {
            return existing;
        }
        this.getDocument().addDestination(newdest);
        return newdest;
    }

    public PDFDestination makeDestination(String idRef, Object goToRef) {
        PDFDestination destination = new PDFDestination(idRef, goToRef);
        return this.getUniqueDestination(destination);
    }

    public PDFNames makeNames() {
        PDFNames names = new PDFNames();
        this.getDocument().assignObjectNumber(names);
        this.getDocument().addTrailerObject(names);
        return names;
    }

    public PDFPageLabels makePageLabels() {
        PDFPageLabels pageLabels = new PDFPageLabels();
        this.getDocument().assignObjectNumber(pageLabels);
        this.getDocument().addTrailerObject(pageLabels);
        return pageLabels;
    }

    public PDFDests makeDests(List destinationList) {
        boolean deep = true;
        PDFDests dests = new PDFDests();
        PDFArray kids = new PDFArray(dests);
        for (PDFDestination dest : destinationList) {
            PDFNameTreeNode node = new PDFNameTreeNode();
            this.getDocument().registerObject(node);
            node.setLowerLimit(dest.getIDRef());
            node.setUpperLimit(dest.getIDRef());
            node.setNames(new PDFArray(node));
            PDFArray names = node.getNames();
            names.add(dest);
            kids.add(node);
        }
        dests.setLowerLimit(((PDFNameTreeNode)kids.get(0)).getLowerLimit());
        dests.setUpperLimit(((PDFNameTreeNode)kids.get(kids.length() - 1)).getUpperLimit());
        dests.setKids(kids);
        this.getDocument().registerObject(dests);
        return dests;
    }

    public PDFNameTreeNode makeNameTreeNode() {
        PDFNameTreeNode node = new PDFNameTreeNode();
        this.getDocument().registerObject(node);
        return node;
    }

    public PDFLink makeLink(Rectangle2D rect, PDFAction pdfAction) {
        if (rect == null || pdfAction == null) {
            return null;
        }
        PDFLink link = new PDFLink(rect);
        link.setAction(pdfAction);
        this.getDocument().registerObject(link);
        return link;
    }

    public PDFLink makeLink(Rectangle2D rect, String page, String dest) {
        PDFLink link = new PDFLink(rect);
        this.getDocument().registerObject(link);
        PDFGoTo gt = new PDFGoTo(page);
        gt.setDestination(dest);
        this.getDocument().registerObject(gt);
        PDFInternalLink internalLink = new PDFInternalLink(gt.referencePDF());
        link.setAction(internalLink);
        return link;
    }

    public PDFLink makeLink(Rectangle2D rect, String destination, int linkType, float yoffset) {
        PDFLink link = new PDFLink(rect);
        if (linkType == 0) {
            link.setAction(this.getExternalAction(destination, false));
        } else {
            String goToReference = this.getGoToReference(destination, yoffset);
            PDFInternalLink internalLink = new PDFInternalLink(goToReference);
            link.setAction(internalLink);
        }
        PDFLink oldlink = this.getDocument().findLink(link);
        if (oldlink == null) {
            this.getDocument().registerObject(link);
        } else {
            link = oldlink;
        }
        return link;
    }

    public PDFAction getExternalAction(String target, boolean newWindow) {
        String targetLo = target.toLowerCase();
        if (target.startsWith(EMBEDDED_FILE)) {
            String filename = target.substring(EMBEDDED_FILE.length());
            return this.getActionForEmbeddedFile(filename, newWindow);
        }
        if (targetLo.startsWith("http://")) {
            return new PDFUri(target);
        }
        if (targetLo.startsWith("https://")) {
            return new PDFUri(target);
        }
        if (targetLo.startsWith("file://")) {
            target = target.substring("file://".length());
            return this.getLaunchAction(target);
        }
        if (targetLo.endsWith(".pdf")) {
            return this.getGoToPDFAction(target, null, -1, newWindow);
        }
        int index = targetLo.indexOf(".pdf#page=");
        if (index > 0) {
            String filename = target.substring(0, index + 4);
            int page = Integer.parseInt(target.substring(index + 10));
            return this.getGoToPDFAction(filename, null, page, newWindow);
        }
        index = targetLo.indexOf(".pdf#dest=");
        if (index > 0) {
            String filename = target.substring(0, index + 4);
            String dest = target.substring(index + 10);
            return this.getGoToPDFAction(filename, dest, -1, newWindow);
        }
        return new PDFUri(target);
    }

    private PDFAction getActionForEmbeddedFile(String filename, boolean newWindow) {
        PDFNames names = this.getDocument().getRoot().getNames();
        if (names == null) {
            throw new IllegalStateException("No Names dictionary present. Cannot create Launch Action for embedded file: " + filename);
        }
        PDFEmbeddedFiles embeddedFiles = names.getEmbeddedFiles();
        if (embeddedFiles == null) {
            throw new IllegalStateException("No /EmbeddedFiles name tree present. Cannot create Launch Action for embedded file: " + filename);
        }
        filename = PDFText.toPDFString(filename, '_');
        PDFArray files = embeddedFiles.getNames();
        PDFReference embeddedFileRef = null;
        for (int i = 0; i < files.length(); ++i) {
            String name = (String)files.get(i);
            PDFReference ref = (PDFReference)files.get(++i);
            if (!name.equals(filename)) continue;
            embeddedFileRef = ref;
            break;
        }
        if (embeddedFileRef == null) {
            throw new IllegalStateException("No embedded file with name " + filename + " present.");
        }
        StringBuffer scriptBuffer = new StringBuffer();
        scriptBuffer.append("this.exportDataObject({cName:\"");
        scriptBuffer.append(filename);
        scriptBuffer.append("\", nLaunch:2});");
        PDFJavaScriptLaunchAction action = new PDFJavaScriptLaunchAction(scriptBuffer.toString());
        return action;
    }

    public String getGoToReference(String pdfPageRef, float yoffset) {
        return this.getPDFGoTo(pdfPageRef, new Point2D.Float(0.0f, yoffset)).referencePDF();
    }

    public PDFGoTo getPDFGoTo(String pdfPageRef, Point2D position) {
        this.getDocument().getProfile().verifyActionAllowed();
        PDFGoTo gt = new PDFGoTo(pdfPageRef, position);
        PDFGoTo oldgt = this.getDocument().findGoTo(gt);
        if (oldgt == null) {
            this.getDocument().assignObjectNumber(gt);
            this.getDocument().addTrailerObject(gt);
        } else {
            gt = oldgt;
        }
        return gt;
    }

    private PDFGoToRemote getGoToPDFAction(String file, String dest, int page, boolean newWindow) {
        this.getDocument().getProfile().verifyActionAllowed();
        PDFFileSpec fileSpec = new PDFFileSpec(file);
        PDFFileSpec oldspec = this.getDocument().findFileSpec(fileSpec);
        if (oldspec == null) {
            this.getDocument().registerObject(fileSpec);
        } else {
            fileSpec = oldspec;
        }
        PDFGoToRemote remote = dest == null && page == -1 ? new PDFGoToRemote(fileSpec, newWindow) : (dest != null ? new PDFGoToRemote(fileSpec, dest, newWindow) : new PDFGoToRemote(fileSpec, page, newWindow));
        PDFGoToRemote oldremote = this.getDocument().findGoToRemote(remote);
        if (oldremote == null) {
            this.getDocument().registerObject(remote);
        } else {
            remote = oldremote;
        }
        return remote;
    }

    private PDFLaunch getLaunchAction(String file) {
        this.getDocument().getProfile().verifyActionAllowed();
        PDFFileSpec fileSpec = new PDFFileSpec(file);
        PDFFileSpec oldSpec = this.getDocument().findFileSpec(fileSpec);
        if (oldSpec == null) {
            this.getDocument().registerObject(fileSpec);
        } else {
            fileSpec = oldSpec;
        }
        PDFLaunch launch = new PDFLaunch(fileSpec);
        PDFLaunch oldLaunch = this.getDocument().findLaunch(launch);
        if (oldLaunch == null) {
            this.getDocument().registerObject(launch);
        } else {
            launch = oldLaunch;
        }
        return launch;
    }

    public PDFOutline makeOutline(PDFOutline parent, String label, String actionRef, boolean showSubItems) {
        PDFOutline pdfOutline = new PDFOutline(label, actionRef, showSubItems);
        if (parent != null) {
            parent.addOutline(pdfOutline);
        }
        this.getDocument().registerObject(pdfOutline);
        return pdfOutline;
    }

    public PDFOutline makeOutline(PDFOutline parent, String label, PDFAction pdfAction, boolean showSubItems) {
        return pdfAction == null ? null : this.makeOutline(parent, label, pdfAction.getAction(), showSubItems);
    }

    public PDFOutline makeOutline(PDFOutline parent, String label, String destination, float yoffset, boolean showSubItems) {
        String goToRef = this.getGoToReference(destination, yoffset);
        return this.makeOutline(parent, label, goToRef, showSubItems);
    }

    public PDFEncoding makeEncoding(String encodingName) {
        PDFEncoding encoding = new PDFEncoding(encodingName);
        this.getDocument().registerObject(encoding);
        return encoding;
    }

    public PDFFont makeFont(String fontname, String basefont, String encoding, FontMetrics metrics, FontDescriptor descriptor) {
        PDFFont preRegisteredfont = this.getDocument().findFont(fontname);
        if (preRegisteredfont != null) {
            return preRegisteredfont;
        }
        boolean forceToUnicode = true;
        if (descriptor == null) {
            PDFFont font = new PDFFont(fontname, FontType.TYPE1, basefont, encoding);
            this.getDocument().registerObject(font);
            if (forceToUnicode && !PDFEncoding.isPredefinedEncoding(encoding)) {
                CodePointMapping mapping;
                if (encoding != null) {
                    mapping = CodePointMapping.getMapping(encoding);
                } else {
                    Typeface tf = (Typeface)metrics;
                    mapping = CodePointMapping.getMapping(tf.getEncodingName());
                }
                this.generateToUnicodeCmap(font, mapping);
            }
            return font;
        }
        FontType fonttype = metrics.getFontType();
        String fontPrefix = descriptor.isSubsetEmbedded() ? this.createSubsetFontPrefix() : "";
        String subsetFontName = fontPrefix + basefont;
        PDFFontDescriptor pdfdesc = this.makeFontDescriptor(descriptor, fontPrefix);
        PDFFont font = null;
        font = PDFFont.createFont(fontname, fonttype, subsetFontName, null);
        this.getDocument().registerObject(font);
        if (fonttype == FontType.TYPE0) {
            font.setEncoding(encoding);
            CIDFont cidMetrics = metrics instanceof LazyFont ? (CIDFont)((LazyFont)metrics).getRealFont() : (CIDFont)metrics;
            PDFCIDSystemInfo sysInfo = new PDFCIDSystemInfo(cidMetrics.getRegistry(), cidMetrics.getOrdering(), cidMetrics.getSupplement());
            PDFCIDFont cidFont = new PDFCIDFont(subsetFontName, cidMetrics.getCIDType(), cidMetrics.getDefaultWidth(), this.getFontWidths(cidMetrics), sysInfo, (PDFCIDFontDescriptor)pdfdesc);
            this.getDocument().registerObject(cidFont);
            PDFToUnicodeCMap cmap = new PDFToUnicodeCMap(cidMetrics.getCIDSet().getChars(), "fop-ucs-H", new PDFCIDSystemInfo("Adobe", "Identity", 0), false);
            this.getDocument().registerObject(cmap);
            ((PDFFontType0)font).setCMAP(cmap);
            ((PDFFontType0)font).setDescendantFonts(cidFont);
        } else {
            PDFFontNonBase14 nonBase14 = (PDFFontNonBase14)font;
            nonBase14.setDescriptor(pdfdesc);
            SingleByteFont singleByteFont = metrics instanceof LazyFont ? (SingleByteFont)((LazyFont)metrics).getRealFont() : (SingleByteFont)metrics;
            int firstChar = singleByteFont.getFirstChar();
            int lastChar = singleByteFont.getLastChar();
            nonBase14.setWidthMetrics(firstChar, lastChar, new PDFArray(null, metrics.getWidths()));
            SingleByteEncoding mapping = singleByteFont.getEncoding();
            if (singleByteFont.isSymbolicFont()) {
                if (forceToUnicode) {
                    this.generateToUnicodeCmap(nonBase14, mapping);
                }
            } else if (PDFEncoding.isPredefinedEncoding(mapping.getName())) {
                font.setEncoding(mapping.getName());
            } else {
                Object pdfEncoding = this.createPDFEncoding(mapping, singleByteFont.getFontName());
                if (pdfEncoding instanceof PDFEncoding) {
                    font.setEncoding((PDFEncoding)pdfEncoding);
                } else {
                    font.setEncoding((String)pdfEncoding);
                }
                if (forceToUnicode) {
                    this.generateToUnicodeCmap(nonBase14, mapping);
                }
            }
            if (singleByteFont.hasAdditionalEncodings()) {
                int c = singleByteFont.getAdditionalEncodingCount();
                for (int i = 0; i < c; ++i) {
                    SimpleSingleByteEncoding addEncoding = singleByteFont.getAdditionalEncoding(i);
                    String name = fontname + "_" + (i + 1);
                    Object pdfenc = this.createPDFEncoding(addEncoding, singleByteFont.getFontName());
                    PDFFontNonBase14 addFont = (PDFFontNonBase14)PDFFont.createFont(name, fonttype, basefont, pdfenc);
                    addFont.setDescriptor(pdfdesc);
                    addFont.setWidthMetrics(addEncoding.getFirstChar(), addEncoding.getLastChar(), new PDFArray(null, singleByteFont.getAdditionalWidths(i)));
                    this.getDocument().registerObject(addFont);
                    this.getDocument().getResources().addFont(addFont);
                    if (!forceToUnicode) continue;
                    this.generateToUnicodeCmap(addFont, addEncoding);
                }
            }
        }
        return font;
    }

    private void generateToUnicodeCmap(PDFFont font, SingleByteEncoding encoding) {
        PDFToUnicodeCMap cmap = new PDFToUnicodeCMap(encoding.getUnicodeCharMap(), "fop-ucs-H", new PDFCIDSystemInfo("Adobe", "Identity", 0), true);
        this.getDocument().registerObject(cmap);
        font.setToUnicode(cmap);
    }

    public Object createPDFEncoding(SingleByteEncoding encoding, String fontName) {
        return PDFEncoding.createPDFEncoding(encoding, fontName);
    }

    private PDFWArray getFontWidths(CIDFont cidFont) {
        PDFWArray warray = new PDFWArray();
        int[] widths = cidFont.getCIDSet().getWidths();
        warray.addEntry(0, widths);
        return warray;
    }

    private String createSubsetFontPrefix() {
        ++this.subsetFontCounter;
        DecimalFormat counterFormat = new DecimalFormat("00000");
        String counterString = counterFormat.format(this.subsetFontCounter);
        StringBuffer sb = new StringBuffer("E");
        for (char c : counterString.toCharArray()) {
            sb.append((char)(c + 17));
        }
        sb.append("+");
        return sb.toString();
    }

    private PDFFontDescriptor makeFontDescriptor(FontDescriptor desc, String fontPrefix) {
        PDFFontDescriptor descriptor = null;
        descriptor = desc.getFontType() == FontType.TYPE0 ? new PDFCIDFontDescriptor(fontPrefix + desc.getEmbedFontName(), desc.getFontBBox(), desc.getCapHeight(), desc.getFlags(), desc.getItalicAngle(), desc.getStemV(), null) : new PDFFontDescriptor(desc.getEmbedFontName(), desc.getAscender(), desc.getDescender(), desc.getCapHeight(), desc.getFlags(), new PDFRectangle(desc.getFontBBox()), desc.getItalicAngle(), desc.getStemV());
        this.getDocument().registerObject(descriptor);
        if (desc.isEmbeddable()) {
            CustomFont font;
            AbstractPDFStream stream = this.makeFontFile(desc);
            if (stream != null) {
                descriptor.setFontFile(desc.getFontType(), stream);
                this.getDocument().registerObject(stream);
            }
            if ((font = this.getCustomFont(desc)) instanceof CIDFont) {
                CIDFont cidFont = (CIDFont)font;
                this.buildCIDSet(descriptor, cidFont);
            }
        }
        return descriptor;
    }

    private void buildCIDSet(PDFFontDescriptor descriptor, CIDFont cidFont) {
        BitSet cidSet = cidFont.getCIDSet().getGlyphIndices();
        PDFStream pdfStream = this.makeStream(null, true);
        ByteArrayOutputStream baout = new ByteArrayOutputStream(cidSet.length() / 8 + 1);
        int value = 0;
        int c = cidSet.length();
        for (int i = 0; i < c; ++i) {
            int shift = i % 8;
            boolean b = cidSet.get(i);
            if (b) {
                value |= 1 << 7 - shift;
            }
            if (shift != 7) continue;
            baout.write(value);
            value = 0;
        }
        baout.write(value);
        try {
            pdfStream.setData(baout.toByteArray());
            descriptor.setCIDSet(pdfStream);
        }
        catch (IOException ioe) {
            this.log.error((Object)("Failed to write CIDSet [" + cidFont + "] " + cidFont.getEmbedFontName()), (Throwable)ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractPDFStream makeFontFile(FontDescriptor desc) {
        if (desc.getFontType() == FontType.OTHER) {
            throw new IllegalArgumentException("Trying to embed unsupported font type: " + desc.getFontType());
        }
        CustomFont font = this.getCustomFont(desc);
        InputStream in = null;
        try {
            AbstractPDFFontStream embeddedFont;
            in = font.getInputStream();
            if (in == null) {
                AbstractPDFStream abstractPDFStream = null;
                return abstractPDFStream;
            }
            if (desc.getFontType() == FontType.TYPE0) {
                byte[] fontBytes;
                MultiByteFont mbfont = (MultiByteFont)font;
                FontFileReader reader = new FontFileReader(in);
                if (font.getEmbeddingMode() == EmbeddingMode.FULL) {
                    fontBytes = reader.getAllBytes();
                } else {
                    TTFSubSetFile ttfFile = new TTFSubSetFile();
                    ttfFile.readFont(reader, mbfont.getTTCName(), mbfont.getUsedGlyphs());
                    fontBytes = ttfFile.getFontSubset();
                }
                embeddedFont = new PDFTTFStream(fontBytes.length);
                ((PDFTTFStream)embeddedFont).setData(fontBytes, fontBytes.length);
            } else if (desc.getFontType() == FontType.TYPE1) {
                PFBParser parser = new PFBParser();
                PFBData pfb = parser.parsePFB(in);
                embeddedFont = new PDFT1Stream();
                ((PDFT1Stream)embeddedFont).setData(pfb);
            } else {
                byte[] file = IOUtils.toByteArray((InputStream)in);
                embeddedFont = new PDFTTFStream(file.length);
                ((PDFTTFStream)embeddedFont).setData(file, file.length);
            }
            AbstractPDFFontStream abstractPDFFontStream = embeddedFont;
            return abstractPDFFontStream;
        }
        catch (IOException ioe) {
            this.log.error((Object)("Failed to embed font [" + desc + "] " + desc.getEmbedFontName()), (Throwable)ioe);
            AbstractPDFStream abstractPDFStream = null;
            return abstractPDFStream;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    private CustomFont getCustomFont(FontDescriptor desc) {
        Typeface tempFont = desc instanceof LazyFont ? ((LazyFont)desc).getRealFont() : (Typeface)((Object)desc);
        if (!(tempFont instanceof CustomFont)) {
            throw new IllegalArgumentException("FontDescriptor must be instance of CustomFont, but is a " + desc.getClass().getName());
        }
        return (CustomFont)tempFont;
    }

    public PDFStream makeStream(String type, boolean add) {
        PDFStream obj = new PDFStream();
        obj.setDocument(this.getDocument());
        obj.getFilterList().addDefaultFilters(this.getDocument().getFilterMap(), type);
        if (add) {
            this.getDocument().registerObject(obj);
        }
        return obj;
    }

    public PDFICCStream makePDFICCStream() {
        PDFICCStream iccStream = new PDFICCStream();
        this.getDocument().registerObject(iccStream);
        return iccStream;
    }

    public PDFICCBasedColorSpace makeICCBasedColorSpace(PDFResourceContext res, String explicitName, PDFICCStream iccStream) {
        PDFICCBasedColorSpace cs = new PDFICCBasedColorSpace(explicitName, iccStream);
        this.getDocument().registerObject(cs);
        if (res != null) {
            res.getPDFResources().addColorSpace(cs);
        } else {
            this.getDocument().getResources().addColorSpace(cs);
        }
        return cs;
    }

    public PDFSeparationColorSpace makeSeparationColorSpace(PDFResourceContext res, NamedColorSpace ncs) {
        String colorName = ncs.getColorName();
        Double zero = new Double(0.0);
        Double one = new Double(1.0);
        List<Double> theDomain = Arrays.asList(zero, one);
        List<Double> theRange = Arrays.asList(zero, one, zero, one, zero, one);
        List<Double> theCZero = Arrays.asList(one, one, one);
        ArrayList<Double> theCOne = new ArrayList<Double>();
        float[] comps = ncs.getRGBColor().getColorComponents(null);
        int c = comps.length;
        for (int i = 0; i < c; ++i) {
            theCOne.add(new Double(comps[i]));
        }
        PDFFunction tintFunction = this.makeFunction(2, theDomain, theRange, theCZero, theCOne, 1.0);
        PDFSeparationColorSpace cs = new PDFSeparationColorSpace(colorName, tintFunction);
        this.getDocument().registerObject(cs);
        if (res != null) {
            res.getPDFResources().addColorSpace(cs);
        } else {
            this.getDocument().getResources().addColorSpace(cs);
        }
        return cs;
    }

    public PDFArray makeArray(int[] values) {
        PDFArray array = new PDFArray(null, values);
        this.getDocument().registerObject(array);
        return array;
    }

    public PDFGState makeGState(Map settings, PDFGState current) {
        PDFGState wanted = new PDFGState();
        wanted.addValues(PDFGState.DEFAULT);
        wanted.addValues(settings);
        PDFGState existing = this.getDocument().findGState(wanted, current);
        if (existing != null) {
            return existing;
        }
        PDFGState gstate = new PDFGState();
        gstate.addValues(settings);
        this.getDocument().registerObject(gstate);
        return gstate;
    }

    public PDFAnnotList makeAnnotList() {
        PDFAnnotList obj = new PDFAnnotList();
        this.getDocument().assignObjectNumber(obj);
        return obj;
    }
}

