/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.bitmap;

import java.util.EnumMap;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.fonts.DefaultFontConfig;
import org.apache.fop.render.RendererConfigOption;
import org.apache.fop.render.bitmap.BitmapRendererConfig;
import org.apache.fop.render.bitmap.TIFFCompressionValue;

public final class TIFFRendererConfig
extends BitmapRendererConfig {
    private final EnumMap<TIFFRendererOption, Object> params = new EnumMap(TIFFRendererOption.class);

    private TIFFRendererConfig(DefaultFontConfig fontConfig) {
        super(fontConfig);
    }

    public TIFFCompressionValue getCompressionType() {
        return (TIFFCompressionValue)((Object)this.params.get(TIFFRendererOption.COMPRESSION));
    }

    public Boolean isSingleStrip() {
        return (Boolean)this.params.get(TIFFRendererOption.SINGLE_STRIP);
    }

    public static final class TIFFRendererConfigParser
    extends BitmapRendererConfig.BitmapRendererConfigParser {
        private TIFFRendererConfig config;

        public TIFFRendererConfigParser() {
            super("image/tiff");
        }

        private void setParam(TIFFRendererOption option, Object value) {
            this.config.params.put(option, value != null ? value : option.getDefaultValue());
        }

        private String getValue(Configuration cfg, TIFFRendererOption option) {
            return cfg.getChild(option.getName()).getValue(null);
        }

        public TIFFRendererConfig build(FOUserAgent userAgent, Configuration cfg) throws FOPException {
            this.config = new TIFFRendererConfig(new DefaultFontConfig.DefaultFontConfigParser().parse(cfg, userAgent.validateStrictly()));
            super.build(this.config, userAgent, cfg);
            if (cfg != null) {
                this.setParam(TIFFRendererOption.COMPRESSION, (Object)TIFFCompressionValue.getType(this.getValue(cfg, TIFFRendererOption.COMPRESSION)));
                this.setParam(TIFFRendererOption.SINGLE_STRIP, Boolean.valueOf(this.getValue(cfg, TIFFRendererOption.SINGLE_STRIP)));
            }
            return this.config;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TIFFRendererOption implements RendererConfigOption
    {
        COMPRESSION("compression", (Object)((Object)TIFFCompressionValue.PACKBITS)),
        SINGLE_STRIP("single-strip", Boolean.FALSE);

        private final String name;
        private final Object defaultValue;

        private TIFFRendererOption(String name, Object defaultValue) {
            this.name = name;
            this.defaultValue = defaultValue;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public Object getDefaultValue() {
            return this.defaultValue;
        }
    }
}

