/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.java2d;

import java.io.InputStream;
import java.net.URI;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.io.InternalResourceResolver;
import org.apache.fop.fonts.CustomFont;
import org.apache.fop.fonts.EmbedFontInfo;
import org.apache.fop.fonts.FontCollection;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontLoader;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.fonts.LazyFont;
import org.apache.fop.fonts.Typeface;
import org.apache.fop.render.java2d.CustomFontMetricsMapper;
import org.apache.xmlgraphics.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfiguredFontCollection
implements FontCollection {
    private static Log log = LogFactory.getLog(ConfiguredFontCollection.class);
    private final InternalResourceResolver resourceResolver;
    private final List<EmbedFontInfo> embedFontInfoList;
    private final boolean useComplexScripts;

    public ConfiguredFontCollection(InternalResourceResolver resourceResolver, List<EmbedFontInfo> customFonts, boolean useComplexScriptFeatures) {
        this.resourceResolver = resourceResolver;
        this.embedFontInfoList = customFonts;
        this.useComplexScripts = useComplexScriptFeatures;
    }

    @Override
    public int setup(int start, FontInfo fontInfo) {
        int num = start;
        if (this.embedFontInfoList == null || this.embedFontInfoList.size() < 1) {
            log.debug((Object)"No user configured fonts found.");
            return num;
        }
        String internalName = null;
        for (EmbedFontInfo configFontInfo : this.embedFontInfoList) {
            internalName = "F" + num++;
            try {
                Typeface fontMetrics;
                URI fontURI = configFontInfo.getEmbedURI();
                CustomFontMetricsMapper font = null;
                URI metricsURI = configFontInfo.getMetricsURI();
                if (metricsURI != null) {
                    fontMetrics = new LazyFont(configFontInfo, this.resourceResolver, this.useComplexScripts);
                    Resource fontSource = this.resourceResolver.getResource(fontURI);
                    font = new CustomFontMetricsMapper((LazyFont)fontMetrics, (InputStream)fontSource);
                } else {
                    fontMetrics = FontLoader.loadFont(fontURI, null, true, configFontInfo.getEmbeddingMode(), configFontInfo.getEncodingMode(), configFontInfo.getKerning(), configFontInfo.getAdvanced(), this.resourceResolver);
                    font = new CustomFontMetricsMapper((CustomFont)fontMetrics);
                }
                fontInfo.addMetrics(internalName, font);
                for (FontTriplet triplet : configFontInfo.getFontTriplets()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Registering: " + triplet + " under " + internalName));
                    }
                    fontInfo.addFontProperties(internalName, triplet);
                }
            }
            catch (Exception e) {
                log.warn((Object)("Unable to load custom font from file '" + configFontInfo.getEmbedURI() + "'"), (Throwable)e);
            }
        }
        return num;
    }
}

