/*
 * Decompiled with CFR 0.152.
 */
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonReader;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Helper {
    public static void main(String[] args) {
        if (args.length == 0) {
            System.exit(1);
        }
        if (!(args[0].equals("downloadupdate") || args[0].equals("cleandatabase") || args[0].equals("createxml") || args[0].equals("generaterksv") || args[0].equals("testrksv"))) {
            System.exit(2);
        }
        if (args[0].equals("downloadupdate")) {
            Helper.DownloadCurrentUpdateFolder();
        }
        if (args[0].equals("testrksv")) {
            try {
                Helper.TestRKSV();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                System.exit(1);
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
        if (args[0].equals("createxml")) {
            try {
                Helper.CreateXmlFiles(Integer.parseInt(args[1]), Integer.parseInt(args[2]), Integer.parseInt(args[3]), Integer.parseInt(args[4]), Integer.parseInt(args[5]), args[6], args[7], args[8], args[9], args[10], args[11], args[12], args[13]);
            }
            catch (IOException | ParserConfigurationException | TransformerException | SAXException e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
        if (args[0].equals("generaterksv")) {
            Helper.GenerateRKSVConfig(args[1], args[2]);
        }
        if (args[0].equals("cleandatabase")) {
            try {
                Helper.CleanDatabase(args[1]);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
                System.exit(1);
            }
            catch (SQLException e) {
                e.printStackTrace();
                System.exit(1);
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
    }

    public static void TestRKSV() throws IOException {
        String path = Helper.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        String decodedPath = null;
        try {
            decodedPath = URLDecoder.decode(path, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            System.exit(1);
        }
        decodedPath = decodedPath.substring(0, decodedPath.lastIndexOf("/") + 1);
        String filePath = decodedPath = String.valueOf(decodedPath) + "/results/0000_app.json";
        Gson gson = new Gson();
        JsonReader reader = new JsonReader(new FileReader(filePath));
        Map map = (Map)gson.fromJson(reader, (Type)((Object)Map.class));
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.equals("verificationState")) continue;
            String value = (String)entry.getValue();
            if (!key.equals("verificationState") || !value.equals("PASS")) continue;
            System.exit(0);
        }
        reader.close();
        System.exit(1);
    }

    public static void GenerateRKSVConfig(String tenantNo, String posCdSmall) {
        String path = Helper.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        String decodedPath = null;
        try {
            decodedPath = URLDecoder.decode(path, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            System.exit(1);
        }
        decodedPath = decodedPath.substring(0, decodedPath.lastIndexOf("/") + 1);
        String baseUrl = "http://localhost:8080/s" + tenantNo + "t" + posCdSmall.split("p")[1];
        String cert = "";
        String baseSerial = "";
        String hexSerial = "";
        String baseAes = new RandomString(32).nextString();
        String aes = "";
        String sum = "";
        BufferedReader httpResponseReader = null;
        try {
            String lineRead;
            URL certUrl = new URL(String.valueOf(baseUrl) + "/servlet?cmd=cert");
            HttpURLConnection urlConnection = (HttpURLConnection)certUrl.openConnection();
            urlConnection.setRequestMethod("GET");
            if (urlConnection.getResponseCode() != 200) {
                System.exit(1);
            }
            httpResponseReader = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
            while ((lineRead = httpResponseReader.readLine()) != null) {
                if (lineRead.trim().isEmpty()) continue;
                if (lineRead.equals("-")) {
                    System.exit(2);
                    continue;
                }
                cert = String.valueOf(cert) + lineRead;
            }
            URL serialUrl = new URL(String.valueOf(baseUrl) + "/servlet?cmd=serial");
            HttpURLConnection serialConnection = (HttpURLConnection)serialUrl.openConnection();
            serialConnection.setRequestMethod("GET");
            if (serialConnection.getResponseCode() != 200) {
                System.exit(1);
            }
            httpResponseReader = new BufferedReader(new InputStreamReader(serialConnection.getInputStream()));
            lineRead = "";
            while ((lineRead = httpResponseReader.readLine()) != null) {
                if (lineRead.trim().isEmpty()) continue;
                baseSerial = String.valueOf(baseSerial) + lineRead;
            }
            hexSerial = new String(Base64.getDecoder().decode(baseSerial.getBytes("UTF-8")), "UTF-8");
            aes = Base64.getEncoder().encodeToString(baseAes.getBytes("UTF-8"));
            try {
                MessageDigest d = MessageDigest.getInstance("SHA-256");
                byte[] hashKey = d.digest(aes.getBytes("UTF-8"));
                byte[] in = new byte[3];
                int i = 0;
                while (i < 3) {
                    in[i] = hashKey[i];
                    ++i;
                }
                sum = Base64.getEncoder().encodeToString(in);
            }
            catch (NoSuchAlgorithmException ex) {
                ex.printStackTrace();
                System.exit(3);
            }
            catch (UnsupportedEncodingException ex) {
                ex.printStackTrace();
                System.exit(3);
            }
            FileWriter file = new FileWriter(String.valueOf(decodedPath) + "/rksv.temp");
            file.write("#SERIAL\r\n");
            file.write(String.valueOf(hexSerial) + "\r\n");
            file.write("#END\r\n");
            file.write("#AES\r\n");
            file.write(String.valueOf(aes) + "\r\n");
            file.write("#END\r\n");
            file.write("#SUM\r\n");
            file.write(String.valueOf(sum) + "\r\n");
            file.write("#END\r\n");
            file.close();
            JsonObject id = new JsonObject();
            id.addProperty("id", hexSerial);
            id.addProperty("signatureDeviceType", "CERTIFICATE");
            id.addProperty("signatureCertificateOrPublicKey", cert);
            JsonObject certificateOrPublicKeyMap = new JsonObject();
            certificateOrPublicKeyMap.add(hexSerial, id);
            JsonObject rksv = new JsonObject();
            rksv.addProperty("base64AESKey", aes);
            rksv.add("certificateOrPublicKeyMap", certificateOrPublicKeyMap);
            FileWriter jsonFile = new FileWriter(String.valueOf(decodedPath) + "/params.json");
            jsonFile.write(rksv.toString());
            jsonFile.close();
            String configPath = "";
            configPath = OsUtils.isWindows() ? "c:/timeglobe/pos/possat-8080/conf/Catalina/localhost/" : "/Users/Shared/timeglobe/pos/possat-8080/conf/Catalina/localhost/";
            String t = String.valueOf(configPath) + "s" + tenantNo + "t" + posCdSmall.split("p")[1] + ".xml";
            String p = String.valueOf(configPath) + "s" + tenantNo + "p" + posCdSmall.split("p")[1] + ".xml";
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document pos = docBuilder.parse(t);
            Node context = pos.getFirstChild();
            NodeList childs = context.getChildNodes();
            int i = 0;
            while (i < childs.getLength()) {
                Node child = childs.item(i);
                block6 : switch (child.getNodeName()) {
                    case "Environment": {
                        String type;
                        switch (type = child.getAttributes().getNamedItem("name").getNodeValue()) {
                            case "cert-serial": {
                                child.getAttributes().getNamedItem("value").setTextContent(hexSerial);
                                break block6;
                            }
                        }
                    }
                }
                ++i;
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(pos);
            StreamResult result = new StreamResult(new File(t));
            transformer.transform(source, result);
            pos = docBuilder.parse(p);
            context = pos.getFirstChild();
            childs = context.getChildNodes();
            int i2 = 0;
            while (i2 < childs.getLength()) {
                block40: {
                    String type;
                    Node child = childs.item(i2);
                    if (!child.getNodeName().equals("Environment")) break block40;
                    switch (type = child.getAttributes().getNamedItem("name").getNodeValue()) {
                        case "aes-key": {
                            child.getAttributes().getNamedItem("value").setTextContent(aes);
                            break;
                        }
                        case "cert-serial": {
                            child.getAttributes().getNamedItem("value").setTextContent(hexSerial);
                        }
                    }
                }
                ++i2;
            }
            transformerFactory = TransformerFactory.newInstance();
            transformer = transformerFactory.newTransformer();
            source = new DOMSource(pos);
            result = new StreamResult(p);
            transformer.transform(source, result);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static void CleanDatabase(String url) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException {
        String path = Helper.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        String decodedPath = null;
        try {
            decodedPath = URLDecoder.decode(path, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            System.exit(1);
        }
        decodedPath = decodedPath.substring(0, decodedPath.lastIndexOf("/") + 1);
        String dbURL = "jdbc:derby:" + url + ";create=false";
        Connection conn = null;
        Class.forName("org.apache.derby.jdbc.ClientDriver").newInstance();
        conn = DriverManager.getConnection(dbURL);
        BufferedReader reader = new BufferedReader(new FileReader(String.valueOf(decodedPath) + "/clean.sql"));
        String line = reader.readLine();
        while (line != null) {
            line = reader.readLine();
            if (line == null || line.isEmpty()) continue;
            line = line.replace(";", "");
            Statement stm = conn.createStatement();
            stm.execute(line);
            stm.close();
        }
        conn.close();
        reader.close();
    }

    public static void CreateXmlFiles(Integer country, Integer tenantNo, Integer companyNo, Integer departmentNo, Integer businessunitNo, String posCd, String posCdSmall, String esafe_saloon, String esafe_station, String esafe_pw, String esafe_pos_cd, String isPlanet, String planetPw) throws ParserConfigurationException, SAXException, IOException, TransformerException {
        StreamResult result;
        DOMSource source;
        Transformer transformer;
        TransformerFactory transformerFactory;
        Node context;
        Document pos;
        DocumentBuilder docBuilder;
        String t;
        String configPath;
        block132: {
            String type;
            Node child;
            String path = Helper.class.getProtectionDomain().getCodeSource().getLocation().getPath();
            String decodedPath = null;
            try {
                decodedPath = URLDecoder.decode(path, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                System.exit(1);
            }
            decodedPath = decodedPath.substring(0, decodedPath.lastIndexOf("/") + 1);
            configPath = "";
            configPath = OsUtils.isWindows() ? "c:/timeglobe/pos/possat-8080/conf/Catalina/localhost/" : "/Users/Shared/timeglobe/pos/possat-8080/conf/Catalina/localhost/";
            String rConfigPath = "";
            rConfigPath = OsUtils.isWindows() ? "c:/timeglobe/pos/possat-8080/conf/Catalina/" : "/Users/Shared/timeglobe/pos/possat-8080/conf/Catalina/";
            if (country != 1) {
                rConfigPath = configPath;
            }
            String p = null;
            String a = null;
            String r = null;
            t = null;
            if (country == 1) {
                p = String.valueOf(decodedPath) + "/pos/configs/AT/s1p1.xml";
                a = String.valueOf(decodedPath) + "/pos/configs/AT/s1a1.xml";
                r = String.valueOf(decodedPath) + "/pos/configs/AT/s1r1.xml";
                t = String.valueOf(decodedPath) + "/pos/configs/AT/s1t1.xml";
            } else if (country == 2) {
                p = String.valueOf(decodedPath) + "/pos/configs/CH/s1p1.xml";
                a = String.valueOf(decodedPath) + "/pos/configs/CH/s1a1.xml";
                r = String.valueOf(decodedPath) + "/pos/configs/CH/s1r1.xml";
                t = String.valueOf(decodedPath) + "/pos/configs/CH/s1t1.xml";
            } else if (country == 3) {
                p = String.valueOf(decodedPath) + "/pos/configs/DE/s1p1.xml";
                a = String.valueOf(decodedPath) + "/pos/configs/DE/s1a1.xml";
                r = String.valueOf(decodedPath) + "/pos/configs/DE/s1r1.xml";
                t = String.valueOf(decodedPath) + "/pos/configs/DE/s1t1.xml";
            }
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            docBuilder = docFactory.newDocumentBuilder();
            pos = docBuilder.parse(p);
            context = pos.getFirstChild();
            context.getAttributes().getNamedItem("displayName").setTextContent("s" + tenantNo + posCdSmall);
            context.getAttributes().getNamedItem("path").setTextContent("/s" + tenantNo + posCdSmall);
            context.getAttributes().getNamedItem("workDir").setTextContent("work/s" + tenantNo + posCdSmall);
            NodeList childs = context.getChildNodes();
            int i = 0;
            while (i < childs.getLength()) {
                Node child2 = childs.item(i);
                block5 : switch (child2.getNodeName()) {
                    case "Environment": {
                        String type2;
                        switch (type2 = child2.getAttributes().getNamedItem("name").getNodeValue()) {
                            case "url": {
                                child2.getAttributes().getNamedItem("value").setTextContent("http://localhost:8080/s" + tenantNo + posCdSmall);
                                break block5;
                            }
                            case "client-no": {
                                child2.getAttributes().getNamedItem("value").setTextContent("" + tenantNo);
                                break block5;
                            }
                            case "tenant-no": {
                                child2.getAttributes().getNamedItem("value").setTextContent("" + tenantNo);
                                break block5;
                            }
                            case "company-no": {
                                child2.getAttributes().getNamedItem("value").setTextContent("" + companyNo);
                                break block5;
                            }
                            case "department-no": {
                                child2.getAttributes().getNamedItem("value").setTextContent("" + departmentNo);
                                break block5;
                            }
                            case "businessunit-no": {
                                child2.getAttributes().getNamedItem("value").setTextContent("" + businessunitNo);
                                break block5;
                            }
                            case "pos-cd": {
                                child2.getAttributes().getNamedItem("value").setTextContent(posCd);
                                break block5;
                            }
                            case "forms-url": {
                                child2.getAttributes().getNamedItem("value").setTextContent("http://localhost:8080/" + tenantNo + posCdSmall);
                                break block5;
                            }
                            case "reports-url": {
                                child2.getAttributes().getNamedItem("value").setTextContent("http://localhost:8080/" + tenantNo + posCdSmall + "/reports");
                                break block5;
                            }
                            case "esafe-owner-cd": {
                                child2.getAttributes().getNamedItem("value").setTextContent(esafe_saloon);
                                break block5;
                            }
                            case "esafe-site-cd": {
                                child2.getAttributes().getNamedItem("value").setTextContent(esafe_station);
                                break block5;
                            }
                            case "esafe-station-cd": {
                                child2.getAttributes().getNamedItem("value").setTextContent(esafe_pos_cd);
                            }
                            case "tse-backup-dir": {
                                if (OsUtils.isWindows()) break block5;
                                child2.getAttributes().getNamedItem("value").setTextContent("/Users/Shared/timeglobe/pos/backup/tarBackups");
                                break block5;
                            }
                            case "has-planet": {
                                if (isPlanet.equals("true")) {
                                    child2.getAttributes().getNamedItem("value").setTextContent("true");
                                    break block5;
                                }
                                child2.getAttributes().getNamedItem("value").setTextContent("false");
                                break block5;
                            }
                            case "qr-url": {
                                child2.getAttributes().getNamedItem("value").setTextContent("http://localhost:8080/s" + tenantNo + posCdSmall + "/qr");
                                break block5;
                            }
                            case "trust-url": {
                                child2.getAttributes().getNamedItem("value").setTextContent("http://localhost:8080/s" + tenantNo + "t" + posCdSmall.split("p")[1] + "/servlet");
                                break block5;
                            }
                            case "at-pos-cd": {
                                child2.getAttributes().getNamedItem("value").setTextContent("TG" + tenantNo + posCd);
                                break block5;
                            }
                            case "webSocketUri": {
                                child2.getAttributes().getNamedItem("value").setTextContent("ws://127.0.0.1:8080/s" + tenantNo + posCdSmall + "/satellitews");
                                break block5;
                            }
                            case "backup-dir": {
                                if (OsUtils.isWindows()) break block5;
                                child2.getAttributes().getNamedItem("value").setTextContent("/Users/Shared/timeglobe/pos/backup");
                                break block5;
                            }
                        }
                        break;
                    }
                    case "Resource": {
                        if (OsUtils.isWindows()) {
                            child2.getAttributes().getNamedItem("url").setTextContent("jdbc:derby:../database/db_pos_s" + tenantNo + posCdSmall + ";create=true");
                            break;
                        }
                        child2.getAttributes().getNamedItem("url").setTextContent("jdbc:derby:/Users/Shared/timeglobe/pos/database/db_pos_s" + tenantNo + posCdSmall + ";create=true");
                    }
                }
                ++i;
            }
            transformerFactory = TransformerFactory.newInstance();
            transformer = transformerFactory.newTransformer();
            source = new DOMSource(pos);
            result = new StreamResult(new File(String.valueOf(configPath) + "s" + tenantNo + posCdSmall + ".xml"));
            transformer.transform(source, result);
            pos = docBuilder.parse(a);
            context = pos.getFirstChild();
            context.getAttributes().getNamedItem("displayName").setTextContent("s" + tenantNo + "a" + posCdSmall.split("p")[1]);
            context.getAttributes().getNamedItem("path").setTextContent("/s" + tenantNo + "a" + posCdSmall.split("p")[1]);
            context.getAttributes().getNamedItem("workDir").setTextContent("work/s" + tenantNo + "a" + posCdSmall.split("p")[1]);
            childs = context.getChildNodes();
            int i2 = 0;
            while (i2 < childs.getLength()) {
                block130: {
                    child = childs.item(i2);
                    if (!child.getNodeName().equals("Environment")) break block130;
                    switch (type = child.getAttributes().getNamedItem("name").getNodeValue()) {
                        case "url": {
                            child.getAttributes().getNamedItem("value").setTextContent("http://localhost:8080/s" + tenantNo + "a" + posCdSmall.split("p")[1]);
                            break;
                        }
                        case "pos-url": {
                            child.getAttributes().getNamedItem("value").setTextContent("http://localhost:8080/s" + tenantNo + "p" + posCdSmall.split("p")[1]);
                            break;
                        }
                        case "client-no": {
                            child.getAttributes().getNamedItem("value").setTextContent("" + tenantNo);
                            break;
                        }
                        case "tenant-no": {
                            child.getAttributes().getNamedItem("value").setTextContent("" + tenantNo);
                        }
                    }
                }
                ++i2;
            }
            transformerFactory = TransformerFactory.newInstance();
            transformer = transformerFactory.newTransformer();
            source = new DOMSource(pos);
            result = new StreamResult(new File(String.valueOf(configPath) + "s" + tenantNo + "a" + posCdSmall.split("p")[1] + ".xml"));
            transformer.transform(source, result);
            if (!isPlanet.equals("true")) break block132;
            pos = docBuilder.parse(r);
            context = pos.getFirstChild();
            context.getAttributes().getNamedItem("displayName").setTextContent("s" + tenantNo + "r" + posCdSmall.split("p")[1]);
            context.getAttributes().getNamedItem("path").setTextContent("/s" + tenantNo + "r" + posCdSmall.split("p")[1]);
            context.getAttributes().getNamedItem("workDir").setTextContent("work/s" + tenantNo + "r" + posCdSmall.split("p")[1]);
            childs = context.getChildNodes();
            i2 = 0;
            while (i2 < childs.getLength()) {
                block133: {
                    child = childs.item(i2);
                    if (!child.getNodeName().equals("Environment")) break block133;
                    switch (type = child.getAttributes().getNamedItem("name").getNodeValue()) {
                        case "tenant-no": {
                            child.getAttributes().getNamedItem("value").setTextContent("" + tenantNo);
                            break;
                        }
                        case "company-no": {
                            child.getAttributes().getNamedItem("value").setTextContent("" + companyNo);
                            break;
                        }
                        case "department-no": {
                            child.getAttributes().getNamedItem("value").setTextContent("" + departmentNo);
                            break;
                        }
                        case "businessunit-no": {
                            child.getAttributes().getNamedItem("value").setTextContent("" + businessunitNo);
                            break;
                        }
                        case "pos-cd": {
                            child.getAttributes().getNamedItem("value").setTextContent(posCd);
                            break;
                        }
                        case "planet-url": {
                            child.getAttributes().getNamedItem("value").setTextContent("https://planet10.time-globe-crs.de/pp" + tenantNo + "/");
                            break;
                        }
                        case "satellite-url": {
                            child.getAttributes().getNamedItem("value").setTextContent("http://localhost:8080/s" + tenantNo + posCdSmall + "/");
                            break;
                        }
                        case "planet-rep-password": {
                            child.getAttributes().getNamedItem("value").setTextContent(planetPw);
                        }
                    }
                }
                ++i2;
            }
            transformerFactory = TransformerFactory.newInstance();
            transformer = transformerFactory.newTransformer();
            source = new DOMSource(pos);
            result = new StreamResult(new File(String.valueOf(rConfigPath) + "s" + tenantNo + "r" + posCdSmall.split("p")[1] + ".xml"));
            transformer.transform(source, result);
        }
        if (country == 1) {
            pos = docBuilder.parse(t);
            context = pos.getFirstChild();
            context.getAttributes().getNamedItem("displayName").setTextContent("s" + tenantNo + "t" + posCdSmall.split("p")[1]);
            context.getAttributes().getNamedItem("path").setTextContent("/s" + tenantNo + "t" + posCdSmall.split("p")[1]);
            context.getAttributes().getNamedItem("workDir").setTextContent("work/s" + tenantNo + "t" + posCdSmall.split("p")[1]);
            transformerFactory = TransformerFactory.newInstance();
            transformer = transformerFactory.newTransformer();
            source = new DOMSource(pos);
            result = new StreamResult(new File(String.valueOf(configPath) + "s" + tenantNo + "t" + posCdSmall.split("p")[1] + ".xml"));
            transformer.transform(source, result);
        }
    }

    public static void DownloadCurrentUpdateFolder() {
        block30: {
            String webPage = "https://hades.time-globe-crs.de/pos-install/02_UPDATE/Aktuelle_Versionen/";
            String name = "abc";
            String password = "test$daten99";
            String authString = String.valueOf(name) + ":" + password;
            String basicAuthPayload = "Basic " + Base64.getEncoder().encodeToString(authString.getBytes());
            BufferedReader httpResponseReader = null;
            try {
                try {
                    String lineRead;
                    URL serverUrl = new URL(webPage);
                    HttpURLConnection urlConnection = (HttpURLConnection)serverUrl.openConnection();
                    urlConnection.setRequestMethod("GET");
                    urlConnection.addRequestProperty("Authorization", basicAuthPayload);
                    if (urlConnection.getResponseCode() != 200) {
                        System.exit(3);
                    }
                    httpResponseReader = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
                    ArrayList<String> pageLines = new ArrayList<String>();
                    while ((lineRead = httpResponseReader.readLine()) != null) {
                        pageLines.add(lineRead);
                    }
                    int pos = -1;
                    int i = 0;
                    while (i < pageLines.size()) {
                        if (((String)pageLines.get(i)).trim().startsWith("<table>")) {
                            pos = i + 3;
                            break;
                        }
                        ++i;
                    }
                    if (pos == -1) {
                        System.exit(3);
                    }
                    ArrayList<String> vName = new ArrayList<String>();
                    int i2 = pos;
                    while (i2 < pageLines.size()) {
                        String tr = (String)pageLines.get(i2);
                        if (tr.trim().startsWith("</table>")) break;
                        if (!tr.contains("alt=\"[DIR]\"") && !tr.contains("alt=\"[PARENTDIR]\"") && tr.contains("href")) {
                            String[] splits = tr.split("<a");
                            splits = splits[1].split("href=\"");
                            splits = splits[1].split(".zip");
                            vName.add(splits[0]);
                        }
                        ++i2;
                    }
                    Helper h = new Helper();
                    ArrayList<Object> versions = new ArrayList<Object>();
                    for (String v : vName) {
                        Version version = h.new Version();
                        String[] var = v.split("\\.");
                        int i3 = 0;
                        while (i3 < var.length) {
                            switch (i3) {
                                case 0: {
                                    version.setMain(var[i3]);
                                }
                                case 1: {
                                    version.setMinor(var[i3]);
                                }
                                case 2: {
                                    version.setPatch(var[i3]);
                                }
                            }
                            ++i3;
                        }
                        versions.add(version);
                    }
                    Version highestversion = null;
                    for (Version version : versions) {
                        if (versions.indexOf(version) == 0) {
                            highestversion = version;
                            continue;
                        }
                        if (version.isSmallerThan(highestversion)) continue;
                        highestversion = version;
                    }
                    URL uRL = new URL("https://hades.time-globe-crs.de/pos-install/02_UPDATE/Aktuelle_Versionen/" + highestversion.getAsString() + ".zip");
                    HttpURLConnection connection = (HttpURLConnection)uRL.openConnection();
                    connection.setRequestMethod("GET");
                    connection.addRequestProperty("Authorization", basicAuthPayload);
                    InputStream in = connection.getInputStream();
                    ZipInputStream zipIn = new ZipInputStream(in);
                    String path = Helper.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                    String decodedPath = null;
                    try {
                        decodedPath = URLDecoder.decode(path, "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                        System.exit(1);
                    }
                    decodedPath = decodedPath.substring(0, decodedPath.lastIndexOf("/") + 1);
                    File destDir = new File(String.valueOf(decodedPath) + "/temp");
                    destDir.mkdirs();
                    ZipUtils.extract(zipIn, destDir);
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    System.exit(1);
                    if (httpResponseReader == null) break block30;
                    try {
                        httpResponseReader.close();
                    }
                    catch (IOException ioe2) {
                        ioe2.printStackTrace();
                    }
                }
            }
            finally {
                if (httpResponseReader != null) {
                    try {
                        httpResponseReader.close();
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                }
            }
        }
    }

    public static File newFile(File destinationDir, ZipEntry zipEntry) throws IOException {
        File destFile = new File(destinationDir, zipEntry.getName());
        if (zipEntry.isDirectory()) {
            destFile.mkdirs();
            return null;
        }
        String destDirPath = destinationDir.getCanonicalPath();
        String destFilePath = destFile.getCanonicalPath();
        if (!destFilePath.startsWith(String.valueOf(destDirPath) + File.separator)) {
            System.exit(1);
            throw new IOException("Entry is outside of the target dir: " + zipEntry.getName());
        }
        return destFile;
    }

    public static final class OsUtils {
        private static String OS = null;

        public static String getOsName() {
            if (OS == null) {
                OS = System.getProperty("os.name");
            }
            return OS;
        }

        public static boolean isWindows() {
            return OsUtils.getOsName().startsWith("Windows");
        }
    }

    public class Version {
        int main;
        int minor;
        int patch;

        public boolean isSmallerThan(Version highestversion) {
            if (highestversion.main > this.main) {
                return true;
            }
            if (highestversion.main == this.main) {
                if (highestversion.minor > this.minor) {
                    return true;
                }
                if (highestversion.minor == this.minor) {
                    return highestversion.patch > this.patch;
                }
                return false;
            }
            return false;
        }

        public Integer getMain() {
            return this.main;
        }

        public Integer getMinor() {
            return this.minor;
        }

        public Integer getPatch() {
            return this.patch;
        }

        public void setMain(String main) {
            if (main != null && !main.isEmpty()) {
                try {
                    this.main = Integer.parseInt(main);
                }
                catch (Exception e) {
                    this.main = -1;
                }
            }
        }

        public void setMinor(String minor) {
            if (minor != null && !minor.isEmpty()) {
                try {
                    this.minor = Integer.parseInt(minor);
                }
                catch (Exception e) {
                    this.minor = -1;
                }
            }
        }

        public void setPatch(String patch) {
            if (patch != null && !patch.isEmpty()) {
                try {
                    this.patch = Integer.parseInt(patch);
                }
                catch (Exception e) {
                    this.patch = -1;
                }
            }
        }

        public String getAsString() {
            String v = "";
            if (this.main != -1) {
                v = String.valueOf(v) + this.main;
            }
            if (this.minor != -1) {
                v = String.valueOf(v) + "." + this.minor;
            }
            if (this.patch != -1) {
                v = String.valueOf(v) + "." + this.patch;
            }
            return v;
        }
    }

    public static final class ZipUtils {
        private static final int BUFFER_SIZE = 4096;

        public static void extract(ZipInputStream zip, File target) throws IOException {
            try {
                ZipEntry entry;
                while ((entry = zip.getNextEntry()) != null) {
                    int count;
                    File file = new File(target, entry.getName());
                    if (!file.toPath().normalize().startsWith(target.toPath())) {
                        throw new IOException("Bad zip entry");
                    }
                    if (entry.isDirectory()) {
                        file.mkdirs();
                        continue;
                    }
                    byte[] buffer = new byte[4096];
                    file.getParentFile().mkdirs();
                    BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
                    while ((count = zip.read(buffer)) != -1) {
                        out.write(buffer, 0, count);
                    }
                    out.close();
                }
            }
            finally {
                zip.close();
            }
        }
    }
}

