/*
 * Decompiled with CFR 0.152.
 */
package at.asitplus.regkassen.verification.common;

import at.asitplus.regkassen.verification.common.annotations.VerificationModule;
import at.asitplus.regkassen.verification.common.data.I18nDetailedMessageID;
import at.asitplus.regkassen.verification.common.data.VerificationID;
import at.asitplus.regkassen.verification.common.data.VerificationInputOutput;
import at.asitplus.regkassen.verification.common.data.VerificationProperty;
import at.asitplus.regkassen.verification.common.data.VerificationResult;
import at.asitplus.regkassen.verification.common.data.VerificationState;
import com.google.common.base.Throwables;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public abstract class BaseVerificationModule {
    private static boolean debug;
    private static final Logger LOGGER;
    public static final String PATTERN_DATE_WITH_TIMEZONE = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    public static final String PATTERN_DATE = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    public static final DateTimeFormatter DATE_FORMAT;
    public static final DateTimeFormatter DATE_FORMAT_RECEIPT;

    public BaseVerificationModule() {
        if (!Modifier.isAbstract(this.getClass().getModifiers())) {
            VerificationModule verificationModule = this.getClass().getAnnotation(VerificationModule.class);
            if (verificationModule == null) {
                throw new RuntimeException("Class " + this.getClass().getCanonicalName() + " does not have annotation " + VerificationModule.class.getCanonicalName());
            }
            BaseVerificationModule.debug("Verification module " + this.getClass().getCanonicalName() + " has the following properties set:\n VerificationID: " + (Object)((Object)verificationModule.verificationID()) + "\nInput Properties: " + Arrays.toString((Object[])verificationModule.inputProperties()) + "\nVersion: " + verificationModule.version());
            return;
        }
        if (debug) {
            BaseVerificationModule.debug("Verification module " + this.getClass().getCanonicalName() + " is abstract");
        }
    }

    private static void debug(String string) {
        if (debug) {
            LOGGER.info(string);
        }
    }

    public static <M extends BaseVerificationModule> VerificationInputOutput[] getInputProperties(Class<M> clazz) {
        return clazz.getAnnotation(VerificationModule.class).inputProperties();
    }

    public final <M extends BaseVerificationModule> VerificationID getVerificationID(Class<M> clazz) {
        return clazz.getAnnotation(VerificationModule.class).verificationID();
    }

    protected static boolean hasInput(VerificationResult verificationResult, VerificationInputOutput ... object) {
        Map<VerificationInputOutput, VerificationProperty> map = verificationResult.getInputData((VerificationInputOutput[])object);
        if (!map.keySet().containsAll(Arrays.asList(object))) {
            verificationResult.setVerificationState(VerificationState.FAIL);
            verificationResult.setDetailedMessage(I18nDetailedMessageID.INPUT_INCOMPLETE, Arrays.asList(object).toString());
            return false;
        }
        for (VerificationProperty verificationProperty : map.values()) {
            if (verificationProperty.getValue() != null && !"".equals(verificationProperty.getValue())) continue;
            verificationResult.setVerificationState(VerificationState.FAIL);
            verificationResult.setDetailedMessage(I18nDetailedMessageID.INPUT_INCOMPLETE_EMPTY_VALUE, map.values().toString());
            return false;
        }
        return true;
    }

    protected Map<VerificationInputOutput, VerificationProperty> getInputData(VerificationResult verificationResult) {
        return verificationResult.getInputData(BaseVerificationModule.getInputProperties(this));
    }

    public VerificationResult prepareInput(VerificationResult verificationResult) {
        return BaseVerificationModule.prepareInput(verificationResult, this.getClass());
    }

    public static <M extends BaseVerificationModule> VerificationResult prepareInput(VerificationResult verificationResult, Class<M> clazz) {
        HashSet<VerificationProperty> hashSet = new HashSet<VerificationProperty>();
        hashSet.retainAll(verificationResult.getOutputData());
        hashSet.addAll(verificationResult.getInputData(BaseVerificationModule.getInputProperties(clazz)).values());
        return BaseVerificationModule.prepareInput(hashSet);
    }

    public static VerificationResult prepareInput(Collection<VerificationProperty> object) {
        VerificationResult verificationResult = new VerificationResult();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        object = object.iterator();
        while (object.hasNext()) {
            VerificationProperty verificationProperty = (VerificationProperty)object.next();
            hashMap.put(verificationProperty.getKey().name(), verificationProperty.getValue());
        }
        verificationResult.setVerificationResultList(new LinkedList<VerificationResult>());
        verificationResult.setInput(hashMap);
        return verificationResult;
    }

    public static VerificationResult prepareInput(VerificationProperty ... verificationPropertyArray) {
        return BaseVerificationModule.prepareInput(Arrays.asList(verificationPropertyArray));
    }

    protected VerificationResult beforeVerify(VerificationResult verificationResult) {
        if (verificationResult == null) {
            BaseVerificationModule.debug("beforeVerify::" + this.getClass().getName() + " got an empty VerificationInput");
            verificationResult = new VerificationResult();
        }
        BaseVerificationModule.debug("beforeVerify::" + this.getClass().getName() + " setting VerificationID, Version, Timestamp and other Metadata");
        this.setMedatada(verificationResult);
        verificationResult.setVerificationState(VerificationState.NOT_EXECUTED);
        verificationResult.setVerificationTimestamp(Calendar.getInstance().getTime());
        return verificationResult;
    }

    protected void setMedatada(VerificationResult verificationResult) {
        VerificationID verificationID = this.getClass().getAnnotation(VerificationModule.class).verificationID();
        verificationResult.setVerificationId(verificationID);
        verificationResult.setVersion(this.getClass().getAnnotation(VerificationModule.class).version());
    }

    protected VerificationResult afterVerify(VerificationResult verificationResult) {
        BaseVerificationModule.debug("afterVerify::" + this.getClass().getName() + "\n" + verificationResult);
        return verificationResult;
    }

    public final VerificationResult verifySingle(VerificationResult verificationResult) {
        return BaseVerificationModule.verifySingle(this, verificationResult);
    }

    private static final <M extends BaseVerificationModule> VerificationResult verifySingle(M m, VerificationResult verificationResult) {
        verificationResult = m.beforeVerify(verificationResult);
        BaseVerificationModule.debug("beforeVerify::" + m.getClass().getName() + "\n" + verificationResult);
        if (BaseVerificationModule.hasInput(verificationResult, BaseVerificationModule.getInputProperties(m))) {
            VerificationResult verificationResult2;
            BaseVerificationModule.debug("doVerify::" + m.getClass().getName() + " all required input properties set");
            try {
                verificationResult2 = m.doVerify(verificationResult);
            }
            catch (Exception exception) {
                verificationResult2 = verificationResult;
                verificationResult2.setStackTrace(Throwables.getStackTraceAsString((Throwable)exception));
                verificationResult2.setVerificationState(VerificationState.FAIL);
                verificationResult2.setDetailedMessage(I18nDetailedMessageID.INVALID_INPUT, new String[0]);
            }
            return m.afterVerify(verificationResult2);
        }
        return m.afterVerify(verificationResult);
    }

    private static <M extends BaseVerificationModule> VerificationInputOutput[] getInputProperties(M m) {
        return m.getClass().getAnnotation(VerificationModule.class).inputProperties();
    }

    public final List<VerificationResult> verify(List<VerificationResult> object) {
        LinkedList<VerificationResult> linkedList = new LinkedList<VerificationResult>();
        if (object == null) {
            return linkedList;
        }
        object = object.iterator();
        while (object.hasNext()) {
            VerificationResult verificationResult = (VerificationResult)object.next();
            linkedList.add(BaseVerificationModule.verifySingle(this, verificationResult));
        }
        return linkedList;
    }

    protected abstract VerificationResult doVerify(VerificationResult var1);

    public static void setDebug(boolean bl) {
        debug = bl;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append(this.getClass().getSimpleName());
        if (!Modifier.isAbstract(this.getClass().getModifiers())) {
            stringBuilder.append(" ").append(Arrays.toString((Object[])BaseVerificationModule.getInputProperties(this)));
        }
        return stringBuilder.toString();
    }

    static {
        LOGGER = Logger.getLogger("VerificationModule");
        DATE_FORMAT = DateTimeFormat.forPattern((String)PATTERN_DATE);
        DATE_FORMAT_RECEIPT = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss");
    }
}

