/*
 * Decompiled with CFR 0.152.
 */
package at.asitplus.regkassen.verification.common.data;

import at.asitplus.regkassen.verification.common.data.I18nDetailedMessageID;
import at.asitplus.regkassen.verification.common.data.Placeholder;
import at.asitplus.regkassen.verification.common.data.VerificationID;
import at.asitplus.regkassen.verification.common.data.VerificationInputOutput;
import at.asitplus.regkassen.verification.common.data.VerificationProperty;
import at.asitplus.regkassen.verification.common.data.VerificationState;
import at.asitplus.regkassen.verification.common.rpc.DateTimeWithTimeZoneDeserializer;
import at.asitplus.regkassen.verification.common.rpc.DateTimeWithTimeZoneSerializer;
import at.asitplus.regkassen.verification.common.rpc.RKObjectMapper;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, creatorVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class VerificationResult {
    protected VerificationID verificationId;
    protected int version;
    protected String verificationName;
    protected String verificationTextualDescription;
    protected VerificationState verificationState;
    protected String verificationResultDetailedMessage;
    @JsonIgnore
    protected String stackTrace;
    @JsonIgnore
    protected I18nDetailedMessageID detailedMsgID;
    @JsonIgnore
    protected String[] detailedMsgParams;
    protected Map<String, String> input;
    private Map<String, String> output;
    @JsonSerialize(using=DateTimeWithTimeZoneSerializer.class)
    @JsonDeserialize(using=DateTimeWithTimeZoneDeserializer.class)
    private Date verificationTimestamp;
    @JacksonXmlElementWrapper(localName="verificationResultList")
    @JacksonXmlProperty(localName="verificationResult")
    protected List<VerificationResult> verificationResultList;

    public VerificationResult() {
    }

    public VerificationResult(VerificationResult verificationResult) {
        this.verificationId = verificationResult.verificationId;
        this.version = verificationResult.version;
        this.verificationName = verificationResult.verificationName;
        this.verificationTextualDescription = verificationResult.verificationTextualDescription;
        this.verificationState = verificationResult.verificationState;
        this.verificationResultDetailedMessage = verificationResult.verificationResultDetailedMessage;
        this.stackTrace = verificationResult.stackTrace;
        this.detailedMsgID = verificationResult.detailedMsgID;
        if (verificationResult.detailedMsgParams != null) {
            this.detailedMsgParams = new String[verificationResult.detailedMsgParams.length];
            System.arraycopy(verificationResult.detailedMsgParams, 0, this.detailedMsgParams, 0, verificationResult.detailedMsgParams.length);
        }
        if (verificationResult.input != null) {
            this.input = new HashMap<String, String>();
            for (String object : verificationResult.input.keySet()) {
                this.input.put(object, verificationResult.input.get(object));
            }
        }
        if (verificationResult.output != null) {
            this.output = new HashMap<String, String>();
            for (String string : verificationResult.output.keySet()) {
                this.output.put(string, verificationResult.output.get(string));
            }
        }
        if (verificationResult.verificationTimestamp != null) {
            this.verificationTimestamp = new Date(verificationResult.verificationTimestamp.getTime());
        }
        if (verificationResult.verificationResultList != null) {
            this.verificationResultList = new LinkedList<VerificationResult>();
            for (VerificationResult verificationResult2 : verificationResult.verificationResultList) {
                this.verificationResultList.add(new VerificationResult(verificationResult2));
            }
        }
    }

    @JsonIgnore
    public I18nDetailedMessageID getDetailedMsgID() {
        return this.detailedMsgID;
    }

    @JsonIgnore
    public String[] getDetailedMsgParams() {
        return this.detailedMsgParams;
    }

    public String getVerificationName() {
        return this.verificationName;
    }

    public void setVerificationName(String string) {
        this.verificationName = string;
    }

    public Date getVerificationTimestamp() {
        return this.verificationTimestamp;
    }

    public void setVerificationTimestamp(Date date) {
        this.verificationTimestamp = date;
    }

    public Map<String, String> getOutput() {
        if (this.output == null) {
            this.output = new HashMap<String, String>();
        }
        return this.output;
    }

    public void addOutput(VerificationInputOutput verificationInputOutput, String string) {
        if (this.output == null) {
            this.output = new HashMap<String, String>();
        }
        this.output.put(verificationInputOutput.name(), string);
    }

    public void addOutput(VerificationProperty verificationProperty) {
        if (this.output == null) {
            this.output = new HashMap<String, String>();
        }
        this.output.put(verificationProperty.getKey().name(), verificationProperty.getValue());
    }

    public VerificationResult addInput(VerificationProperty verificationProperty) {
        if (this.input == null) {
            this.input = new HashMap<String, String>();
        }
        this.input.put(verificationProperty.getKey().name(), verificationProperty.getValue());
        return this;
    }

    public VerificationProperty getOutputData(VerificationInputOutput verificationInputOutput) {
        if (this.output == null) {
            this.output = new HashMap<String, String>();
        }
        return new VerificationProperty(verificationInputOutput, this.output.get(verificationInputOutput.name()));
    }

    public Collection<VerificationProperty> getOutputData() {
        if (this.output == null) {
            this.output = new HashMap<String, String>();
        }
        HashSet<VerificationProperty> hashSet = new HashSet<VerificationProperty>();
        for (String string : this.output.keySet()) {
            hashSet.add(new VerificationProperty(VerificationInputOutput.valueOf(string), this.output.get(string)));
        }
        return hashSet;
    }

    public VerificationProperty getInputData(VerificationInputOutput verificationInputOutput) {
        if (this.input == null) {
            this.input = new HashMap<String, String>();
        }
        String string = verificationInputOutput.name();
        return new VerificationProperty(verificationInputOutput, this.getInput().get(string));
    }

    public boolean hasPlaceholderNullInput(VerificationInputOutput verificationInputOutput) {
        return Placeholder.NULL.name().equals(this.getInputData(verificationInputOutput).getValue());
    }

    public Map<VerificationInputOutput, VerificationProperty> getInputData(VerificationInputOutput ... verificationInputOutputArray) {
        if (this.input == null) {
            this.input = new HashMap<String, String>();
        }
        HashMap<VerificationInputOutput, VerificationProperty> hashMap = new HashMap<VerificationInputOutput, VerificationProperty>();
        for (VerificationInputOutput verificationInputOutput : verificationInputOutputArray) {
            if (!this.input.containsKey(verificationInputOutput.name()) || this.input.get(verificationInputOutput.name()) == null) continue;
            hashMap.put(verificationInputOutput, new VerificationProperty(verificationInputOutput, this.input.get(verificationInputOutput.name())));
        }
        return hashMap;
    }

    public VerificationID getVerificationId() {
        return this.verificationId;
    }

    public void setVerificationId(VerificationID verificationID) {
        this.verificationId = verificationID;
    }

    public String getVerificationTextualDescription() {
        return this.verificationTextualDescription;
    }

    public void setVerificationTextualDescription(String string) {
        this.verificationTextualDescription = string;
    }

    public VerificationState getVerificationState() {
        return this.verificationState;
    }

    public void setVerificationState(VerificationState verificationState) {
        this.verificationState = verificationState;
    }

    public String getVerificationResultDetailedMessage() {
        return this.verificationResultDetailedMessage;
    }

    public void setVerificationResultDetailedMessage(String string) {
        this.verificationResultDetailedMessage = string;
    }

    public void setDetailedMessage(I18nDetailedMessageID i18nDetailedMessageID, String ... stringArray) {
        this.detailedMsgID = i18nDetailedMessageID;
        this.detailedMsgParams = stringArray;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    public void setStackTrace(String string) {
        this.stackTrace = string;
    }

    public List<VerificationResult> getVerificationResultList() {
        if (this.verificationResultList == null) {
            this.verificationResultList = new LinkedList<VerificationResult>();
        }
        return new LinkedList<VerificationResult>(this.verificationResultList);
    }

    public void removeSubResult(VerificationResult verificationResult) {
        this.verificationResultList.remove(verificationResult);
    }

    public void removeSubResult(VerificationID verificationID) {
        VerificationResult verificationResult = null;
        for (VerificationResult verificationResult2 : this.verificationResultList) {
            if (verificationResult2.verificationId != verificationID) continue;
            verificationResult = verificationResult2;
            break;
        }
        if (verificationResult != null) {
            this.verificationResultList.remove(verificationResult);
        }
    }

    public void setVerificationResultList(List<VerificationResult> list) {
        this.verificationResultList = list;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int n) {
        this.version = n;
    }

    public Map<String, String> getInput() {
        if (this.input == null) {
            this.input = new HashMap<String, String>();
        }
        return this.input;
    }

    public void setInput(Map<String, String> map) {
        this.input = map;
    }

    public String toString() {
        return RKObjectMapper.stringify(this);
    }

    public VerificationResult getSubResult(VerificationID verificationID) {
        for (VerificationResult verificationResult : this.getVerificationResultList()) {
            if (verificationResult.getVerificationId() == verificationID) {
                return verificationResult;
            }
            if (verificationResult.getVerificationResultList() == null || verificationResult.getVerificationResultList().isEmpty() || (verificationResult = verificationResult.getSubResult(verificationID)) == null) continue;
            return verificationResult;
        }
        return null;
    }

    public void addVerificationResult(VerificationResult verificationResult) {
        if (this.verificationResultList == null) {
            this.verificationResultList = new LinkedList<VerificationResult>();
        }
        this.verificationResultList.add(verificationResult);
    }

    public void clearVerificationResults() {
        if (this.verificationResultList != null) {
            this.verificationResultList.clear();
        }
    }
}

