/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.image.loader;

import java.io.IOException;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageException;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.XMLNamespaceEnabledImageFlavor;
import org.apache.xmlgraphics.image.loader.impl.AbstractImageConverter;
import org.apache.xmlgraphics.image.loader.impl.ImageXMLDOM;
import org.krysalis.barcode4j.BarcodeDimension;
import org.krysalis.barcode4j.BarcodeException;
import org.krysalis.barcode4j.BarcodeGenerator;
import org.krysalis.barcode4j.BarcodeUtil;
import org.krysalis.barcode4j.image.loader.ImageBarcode;
import org.krysalis.barcode4j.output.svg.SVGCanvasProvider;
import org.krysalis.barcode4j.tools.PageInfo;
import org.krysalis.barcode4j.tools.VariableUtil;

public class ImageConverterBarcode2SVG
extends AbstractImageConverter {
    private static final XMLNamespaceEnabledImageFlavor SVG_DOM = new XMLNamespaceEnabledImageFlavor(ImageFlavor.XML_DOM, "http://www.w3.org/2000/svg");

    public Image convert(Image src, Map hints) throws ImageException, IOException {
        this.checkSourceFlavor(src);
        ImageBarcode barcodeImage = (ImageBarcode)src;
        Configuration cfg = barcodeImage.getBarcodeXML();
        int orientation = BarcodeDimension.normalizeOrientation(cfg.getAttributeAsInteger("orientation", 0));
        try {
            String msg = barcodeImage.getMessage();
            PageInfo pageInfo = PageInfo.fromProcessingHints(hints);
            String expandedMsg = VariableUtil.getExpandedMessage(pageInfo, msg);
            BarcodeGenerator bargen = BarcodeUtil.getInstance().createBarcodeGenerator(cfg);
            SVGCanvasProvider canvas = new SVGCanvasProvider(true, orientation);
            bargen.generateBarcode(canvas, expandedMsg);
            ImageXMLDOM svgImage = new ImageXMLDOM(src.getInfo(), canvas.getDOM(), SVG_DOM);
            return svgImage;
        }
        catch (ConfigurationException ce) {
            throw new ImageException("Error in Barcode XML", (Throwable)ce);
        }
        catch (BarcodeException be) {
            throw new ImageException("Error while converting barcode to SVG", (Throwable)be);
        }
    }

    public ImageFlavor getSourceFlavor() {
        return ImageBarcode.BARCODE_IMAGE_FLAVOR;
    }

    public ImageFlavor getTargetFlavor() {
        return SVG_DOM;
    }
}

