/*
 * Decompiled with CFR 0.152.
 */
package at.asitplus.regkassen.verification.cmdline;

import at.asitplus.regkassen.common.MachineCodeValue;
import at.asitplus.regkassen.common.util.CashBoxUtils;
import at.asitplus.regkassen.core.base.cashboxsimulation.CryptographicMaterialContainer;
import at.asitplus.regkassen.core.modules.DEP.DEPExportFormat;
import at.asitplus.regkassen.verification.cmdline.Prueftool;
import at.asitplus.regkassen.verification.common.data.Placeholder;
import at.asitplus.regkassen.verification.common.data.VerificationID;
import at.asitplus.regkassen.verification.common.data.VerificationInputOutput;
import at.asitplus.regkassen.verification.common.data.VerificationProperty;
import at.asitplus.regkassen.verification.common.data.VerificationResult;
import at.asitplus.regkassen.verification.common.data.VerificationState;
import at.asitplus.regkassen.verification.common.rpc.RKObjectMapper;
import at.asitplus.regkassen.verification.modules.DEPVerificationModule;
import at.asitplus.regkassen.verification.resourceinjection.ResourceInjector;
import at.asitplus.regkassenprototyping.testdb.MockDBModule;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;

public class CheckDEPExportFormat
extends Prueftool {
    public static void main(String[] args) {
        try {
            CommandLine cmd = CheckDEPExportFormat.parseCommands(args);
            boolean verbose = cmd.hasOption("v");
            boolean future = cmd.hasOption('f');
            File outputDir = CheckDEPExportFormat.checkOutputDir(cmd.getOptionValue("o"));
            DEPExportFormat export = CheckDEPExportFormat.parseDEPInput(cmd.getOptionValue("i"), verbose);
            CryptographicMaterialContainer cryptographicMaterialContainer = Prueftool.parseCryptoContainer(cmd.getOptionValue("c"), verbose);
            List<VerificationResult> qrCodeRepList = CheckDEPExportFormat.extractReceipts(export, verbose);
            MockDBModule mockDBModule = CheckDEPExportFormat.setupDB(cryptographicMaterialContainer);
            System.out.println("-----------------------------------------------------------------------------");
            System.out.println("Step 1: DETAILED MACHINE-READABLE CODE VALIDATION: This process validates the machine readable codes within the RKSV-RKSV_DEP_EXPORT-Export. RKSV-RKSV_DEP_EXPORT-Export checks will be executed in Step 2.");
            ArrayList<VerificationResult> singleMachineCodeVerificationResults = new ArrayList<VerificationResult>();
            int index = 0;
            for (VerificationResult verificationInput : qrCodeRepList) {
                VerificationResult verificationResult = CheckDEPExportFormat.performSingleReceiptCheck(mockDBModule, verificationInput, future);
                System.out.println(CheckDEPExportFormat.dumpToString(verificationResult, index, verbose));
                singleMachineCodeVerificationResults.add(verificationResult);
                ++index;
            }
            CheckDEPExportFormat.writeSingleResults(outputDir, singleMachineCodeVerificationResults, verbose);
            System.out.println("-----------------------------------------------------------------------------");
            System.out.println("Step 1: DETAILED MACHINE-READABLE CODE VALIDATION complete.\n\n");
            System.out.println("-----------------------------------------------------------------------------");
            System.out.println("Step 2: RKSV-DEP-EXPORT Validation: This process validates the RKSV-DEP-EXPORT file.");
            ArrayList<VerificationResult> depResults = new ArrayList<VerificationResult>();
            boolean success = CheckDEPExportFormat.performDepValidation(singleMachineCodeVerificationResults, depResults, verbose);
            index = 0;
            for (VerificationResult depResult : depResults) {
                ResourceInjector.transform((VerificationResult)depResult, (Locale)new Locale("de"));
                CheckDEPExportFormat.writeRksvDepResultToFile(outputDir.getAbsolutePath(), index, depResult);
                ++index;
            }
            String outputFileString = outputDir + File.separator + "DEP.json";
            File outFile = new File(outputFileString);
            if (verbose) {
                System.out.format("Writing RKSV-DEP-EXPORT validation results to %s\n", outFile.getAbsolutePath());
            }
            try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(outFile)), "UTF-8");){
                out.write(RKObjectMapper.stringify(depResults));
                out.close();
            }
            if (!success) {
                String path = outFile.getPath();
                System.out.println("RKSV-DEP-EXPORT validation process failed, available results are available in the DEP.JSON file :" + path);
            } else {
                System.out.println("-----------------------------------------------------------------------------");
                System.out.println("Step 2: RKSV-DEP-EXPORT Validation complete.");
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("One of the provided files does not exist: " + e.getLocalizedMessage());
        }
        catch (IOException e) {
            System.out.println("Error while parsing the input files. Detailed error-stacktrace:\n");
            e.printStackTrace();
        }
        catch (ParseException e) {
            System.out.println("Error while parsing the input files. Detailed error-stacktrace:\n");
            e.printStackTrace();
        }
        catch (Throwable t) {
            System.out.println("Fatal internal error. Detailed error-stacktrace:\n");
            t.printStackTrace();
        }
    }

    public static boolean performDepValidation(Collection<VerificationResult> singleResults, List<VerificationResult> depResults, boolean verbose) {
        ArrayList<VerificationResult> orderedResults = new ArrayList<VerificationResult>(singleResults);
        DEPVerificationModule depVerify = new DEPVerificationModule();
        long turnoverSum = 0L;
        boolean error = false;
        String initialCashBoxIdString = "";
        VerificationProperty initialSystemType = null;
        for (int i = 0; i < orderedResults.size(); ++i) {
            VerificationResult prev;
            if (verbose) {
                System.out.format("Starting RKSV-DEP-EXPORT validation of receipt %d\n", i);
            }
            VerificationResult current = (VerificationResult)orderedResults.get(i);
            VerificationResult res = new VerificationResult();
            if (current.getVerificationState() == VerificationState.FAIL) {
                System.err.format("Single receipt verification for machine readable code with index %d was not successful. Details are stored within %04d_cashbox.json. Due to this error the RKSV_DEP_EXPORT-validation process will be stopped.\n", i, i);
                return false;
            }
            VerificationResult cryptoResult = current.getSubResult(VerificationID.CRYPTO_SIGNATURE);
            res.addInput(cryptoResult == null ? new VerificationProperty(VerificationInputOutput.RK_SUITE_ID, (Enum)Placeholder.NULL) : cryptoResult.getInputData(VerificationInputOutput.RK_SUITE_ID));
            VerificationProperty knownIDs = new VerificationProperty(VerificationInputOutput.KNOWN_RECEIPT_IDS, (Enum)Placeholder.NULL);
            res.addInput(knownIDs);
            VerificationProperty currentReceipt = current.getInputData(VerificationInputOutput.RECEIPT);
            res.addInput(currentReceipt);
            if (i == 0) {
                initialCashBoxIdString = CashBoxUtils.getValueFromMachineCode((String)currentReceipt.getValue(), (MachineCodeValue)MachineCodeValue.CASHBOX_ID);
                VerificationProperty systemType = current.getSubResult(VerificationID.RKSUITE).getOutputData(VerificationInputOutput.SYSTEM_TYPE);
                initialSystemType = new VerificationProperty(VerificationInputOutput.SYSTEM_TYPE_INITIAL, systemType.getValue());
            }
            res.addInput(new VerificationProperty(VerificationInputOutput.CASHBOX_ID_INITIAL, initialCashBoxIdString));
            res.addInput(initialSystemType);
            if (i < orderedResults.size()) {
                String currentCashBoxId = CashBoxUtils.getValueFromMachineCode((String)currentReceipt.getValue(), (MachineCodeValue)MachineCodeValue.CASHBOX_ID);
                res.addInput(new VerificationProperty(VerificationInputOutput.CASHBOX_ID, currentCashBoxId));
                VerificationProperty currentSystemType = current.getSubResult(VerificationID.RKSUITE).getOutputData(VerificationInputOutput.SYSTEM_TYPE);
                res.addInput(currentSystemType);
            } else {
                res.addInput(new VerificationProperty(VerificationInputOutput.CASHBOX_ID, (Enum)Placeholder.NULL));
                res.addInput(new VerificationProperty(VerificationInputOutput.SYSTEM_TYPE, (Enum)Placeholder.NULL));
            }
            VerificationProperty prevReceipt = new VerificationProperty(VerificationInputOutput.RECEIPT_PREV, (Enum)Placeholder.NULL);
            res.addInput(prevReceipt);
            VerificationResult typeResult = current.getSubResult(VerificationID.TYPE_OF_RECEIPT);
            res.addInput(typeResult == null ? new VerificationProperty(VerificationInputOutput.TYPE_RECEIPT, (Enum)Placeholder.NULL) : typeResult.getOutputData(VerificationInputOutput.TYPE_RECEIPT));
            VerificationProperty prevType = new VerificationProperty(VerificationInputOutput.TYPE_RECEIPT_PREV, (Enum)Placeholder.NULL);
            res.addInput(prevType);
            VerificationProperty prevSigned = new VerificationProperty(VerificationInputOutput.SIGNED_PREV, (Enum)Placeholder.NULL);
            res.addInput(prevSigned);
            VerificationProperty penultSigned = new VerificationProperty(VerificationInputOutput.SIGNED_PENULT, (Enum)Placeholder.NULL);
            res.addInput(penultSigned);
            VerificationResult turnoverResult = current.getSubResult(VerificationID.CRYPTO_TURNOVER_COUNTER);
            res.addInput(turnoverResult == null ? new VerificationProperty(VerificationInputOutput.DECRYPTED_TURNOVER_VALUE, (Enum)Placeholder.NULL) : turnoverResult.getOutputData(VerificationInputOutput.DECRYPTED_TURNOVER_VALUE));
            res.addInput(new VerificationProperty(VerificationInputOutput.TURNOVER_SUM, Long.toString(turnoverSum)));
            if (i > 0) {
                prev = (VerificationResult)orderedResults.get(i - 1);
                res.addInput(new VerificationProperty(VerificationInputOutput.RECEIPT_PREV, prev.getInputData(VerificationInputOutput.RECEIPT).getValue()));
                res.addInput(new VerificationProperty(VerificationInputOutput.TYPE_RECEIPT_PREV, prev.getSubResult(VerificationID.TYPE_OF_RECEIPT).getOutputData(VerificationInputOutput.TYPE_RECEIPT).getValue()));
                res.addInput(new VerificationProperty(VerificationInputOutput.SIGNED_PREV, prev.getSubResult(VerificationID.CRYPTO_SIGNATURE).getOutputData(VerificationInputOutput.RECEIPT_SIGNED).getValue()));
                res.addInput(depResults.get(depResults.size() - 1).getSubResult(VerificationID.DEP_UNIQUE_RECEIPT_ID).getOutputData(VerificationInputOutput.KNOWN_RECEIPT_IDS));
            }
            if (i > 1) {
                prev = (VerificationResult)orderedResults.get(i - 2);
                res.addInput(new VerificationProperty(VerificationInputOutput.SIGNED_PENULT, prev.getSubResult(VerificationID.CRYPTO_SIGNATURE).getOutputData(VerificationInputOutput.RECEIPT_SIGNED).getValue()));
            }
            VerificationResult depResult = depVerify.verifySingle(res);
            ResourceInjector.transform((VerificationResult)depResult, (Locale)new Locale("de"));
            System.out.print("RKSV-DEP-EXPORT-validation # " + i + ": ");
            boolean softfail = Boolean.parseBoolean(depResult.getOutputData(VerificationInputOutput.SOFTFAIL).getValue());
            if (depResult.getVerificationState() == VerificationState.PASS) {
                System.out.println("PASS");
                if (verbose) {
                    System.out.println("DETAILS: ");
                    System.out.println(depResult);
                    System.out.println("-----------------------------");
                }
                System.out.println();
            } else {
                System.out.println("FAIL");
                System.out.println(depResult);
                System.out.println("RKSV-DEP-EXPORT validation process failed for last receipt" + (softfail ? "" : ", stopping RKSV-DEP-EXPORT-validation."));
                System.out.println();
            }
            depResults.add(depResult);
            if (depResult.getVerificationState() == VerificationState.FAIL) {
                error = true;
                if (!softfail) break;
            }
            try {
                turnoverSum = Long.parseLong(depResult.getSubResult(VerificationID.DEP_TURNOVER_COMPARE).getOutputData(VerificationInputOutput.TURNOVER_SUM).getValue());
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return !error;
    }

    public static VerificationResult performSingleReceiptCheck(MockDBModule mockDBModule, VerificationResult qrCodeRepInput, boolean future) {
        VerificationResult result = CheckDEPExportFormat.checkReceipt(mockDBModule, qrCodeRepInput.getInputData(VerificationInputOutput.RECEIPT).getValue(), future);
        return result;
    }

    public static List<VerificationResult> performSingleReceiptCheck(MockDBModule mockDBModule, List<VerificationResult> qrCodeRepInput, boolean future) {
        ArrayList<VerificationResult> verificationResults = new ArrayList<VerificationResult>();
        for (VerificationResult verificationInput : qrCodeRepInput) {
            VerificationResult result = CheckDEPExportFormat.performSingleReceiptCheck(mockDBModule, verificationInput, future);
            verificationResults.add(result);
        }
        return verificationResults;
    }

    public static void writeSingleResults(File outputDir, List<VerificationResult> results, boolean verbose) {
        int i = 0;
        for (VerificationResult result : results) {
            VerificationResult clonedResult = new VerificationResult(result);
            CheckDEPExportFormat.writeMachineReadableCodeResultToFile(outputDir.getAbsolutePath(), i, clonedResult);
            ++i;
        }
    }
}

