/*
 * Decompiled with CFR 0.152.
 */
package at.asitplus.regkassen.verification.cmdline;

import at.asitplus.regkassen.core.base.cashboxsimulation.CryptographicMaterialContainer;
import at.asitplus.regkassen.verification.cmdline.Prueftool;
import at.asitplus.regkassen.verification.common.data.VerificationResult;
import at.asitplus.regkassenprototyping.testdb.MockDBModule;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;

public class CheckSingleReceipt
extends Prueftool {
    public static void main(String[] args) {
        try {
            CommandLine cmd = CheckSingleReceipt.parseCommands(args);
            boolean verbose = cmd.hasOption("v");
            boolean future = cmd.hasOption('f');
            File outputDir = CheckSingleReceipt.checkOutputDir(cmd.getOptionValue("o"));
            CryptographicMaterialContainer cryptographicMaterialContainer = Prueftool.parseCryptoContainer(cmd.getOptionValue("c"), verbose);
            List<String> qrCodeRepList = CheckSingleReceipt.loadSingleReceipts(cmd.getOptionValue("i"));
            MockDBModule mockDBModule = CheckSingleReceipt.setupDB(cryptographicMaterialContainer);
            System.out.println("-----------------------------------------------------------------------------");
            System.out.println("DETAILED MACHINE-READABLE CODE VALIDATION: This process validates the machine readable codes within the given input file.");
            ArrayList<VerificationResult> verificationResults = new ArrayList<VerificationResult>();
            for (String receipt : qrCodeRepList) {
                VerificationResult verificationResult = CheckSingleReceipt.checkReceipt(mockDBModule, receipt, future);
                verificationResults.add(verificationResult);
            }
            int index = 0;
            for (VerificationResult result : verificationResults) {
                System.out.println(CheckSingleReceipt.dumpToString(result, index, verbose));
                CheckSingleReceipt.writeMachineReadableCodeResultToFile(outputDir.getAbsolutePath(), index, result);
                ++index;
            }
            System.out.println("-----------------------------------------------------------------------------");
            System.out.println("DETAILED MACHINE-READABLE CODE VALIDATION complete.\n\n");
        }
        catch (FileNotFoundException e) {
            System.err.println("One of the provided files does not exist: " + e.getLocalizedMessage());
        }
        catch (IOException e) {
            System.err.println("Error while parsing the input files.");
        }
        catch (ParseException e) {
            System.err.println("Error while parsing the input files.");
        }
    }
}

