/*
 * Decompiled with CFR 0.152.
 */
package at.asitplus.regkassen.verification.cmdline;

import at.asitplus.regkassen.common.util.CashBoxUtils;
import at.asitplus.regkassen.common.util.CryptoUtil;
import at.asitplus.regkassen.core.base.cashboxsimulation.CryptographicMaterialContainer;
import at.asitplus.regkassen.core.modules.DEP.DEPBelegDump;
import at.asitplus.regkassen.core.modules.DEP.DEPExportFormat;
import at.asitplus.regkassen.verification.ClassPathRepo;
import at.asitplus.regkassen.verification.CryptoContainerDB;
import at.asitplus.regkassen.verification.common.BaseVerificationModule;
import at.asitplus.regkassen.verification.common.data.AuthLevel;
import at.asitplus.regkassen.verification.common.data.CashBoxState;
import at.asitplus.regkassen.verification.common.data.VerificationID;
import at.asitplus.regkassen.verification.common.data.VerificationInputOutput;
import at.asitplus.regkassen.verification.common.data.VerificationProperty;
import at.asitplus.regkassen.verification.common.data.VerificationResult;
import at.asitplus.regkassen.verification.common.data.VerificationState;
import at.asitplus.regkassen.verification.common.dbinterface.RegkassenDB;
import at.asitplus.regkassen.verification.common.rpc.RKObjectMapper;
import at.asitplus.regkassen.verification.modules.RKSVDBModule;
import at.asitplus.regkassen.verification.modules.entrypoint.AppEntryPoint;
import at.asitplus.regkassen.verification.modules.entrypoint.CashBoxEntryPoint;
import at.asitplus.regkassen.verification.resourceinjection.ResourceInjector;
import at.asitplus.regkassen.verification.resourceinjection.ResourceRepository;
import at.asitplus.regkassenprototyping.testdb.GeneratedTestDB;
import at.asitplus.regkassenprototyping.testdb.MockDBModule;
import at.asitplus.regkassenprototyping.testdb.TestDB;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public abstract class Prueftool {
    private static final CashBoxEntryPoint TRANSFORM_CB;
    private static final AppEntryPoint TRANSFORM_APP;

    public static MockDBModule setupDB(CryptographicMaterialContainer cryptographicMaterialContainer) {
        MockDBModule mockDBModule = new MockDBModule();
        mockDBModule.setGeneratedTestDB((TestDB)new CryptoContainerDB(cryptographicMaterialContainer));
        RKSVDBModule.setDB((RegkassenDB)mockDBModule);
        return mockDBModule;
    }

    public static CryptographicMaterialContainer parseCryptoContainer(String cryptoMaterialContainerFile, boolean verbose) throws FileNotFoundException, IOException {
        return Prueftool.parseCrypto(cryptoMaterialContainerFile, verbose);
    }

    public static CryptographicMaterialContainer parseCryptoContainer(URI cryptoMaterialContainerFile, boolean verbose) throws FileNotFoundException, IOException {
        return Prueftool.parseCrypto(cryptoMaterialContainerFile, verbose);
    }

    private static CryptographicMaterialContainer parseCrypto(Object cryptoMaterialContainerFile, boolean verbose) throws FileNotFoundException, IOException {
        if (cryptoMaterialContainerFile == null) {
            throw new IOException("no crypto material container file provided");
        }
        CryptographicMaterialContainer cryptographicMaterialContainer = null;
        File cryptoContainerFile = cryptoMaterialContainerFile instanceof String ? new File((String)cryptoMaterialContainerFile) : new File((URI)cryptoMaterialContainerFile);
        if (!cryptoContainerFile.exists()) {
            throw new FileNotFoundException(String.format("Cryptographic material container file %s does not exist.\nExiting.", cryptoMaterialContainerFile));
        }
        if (verbose) {
            System.out.format("Parsing cryptographic material container from %s\n", cryptoContainerFile.getAbsolutePath());
        }
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(cryptoContainerFile));){
            cryptographicMaterialContainer = (CryptographicMaterialContainer)RKObjectMapper.load((InputStream)bufferedInputStream, CryptographicMaterialContainer.class);
        }
        return cryptographicMaterialContainer;
    }

    public static List<VerificationResult> extractReceipts(DEPExportFormat export, boolean verbose) {
        LinkedList<VerificationResult> qrCodeRepList = new LinkedList<VerificationResult>();
        if (verbose) {
            System.out.format("Extracting and transforming receipts from RKSV_DEP_EXPORT\n", new Object[0]);
        }
        for (DEPBelegDump dep : export.getBelegPackage()) {
            for (String receipt : dep.getBelegeDaten()) {
                try {
                    String qrRep = CashBoxUtils.getQRCodeRepresentationFromJWSCompactRepresentation((String)receipt);
                    qrCodeRepList.add(new VerificationResult().addInput(new VerificationProperty(VerificationInputOutput.RECEIPT, qrRep)));
                }
                catch (Exception e) {
                    qrCodeRepList.add(new VerificationResult().addInput(new VerificationProperty(VerificationInputOutput.RECEIPT, "not valid")));
                }
            }
        }
        return qrCodeRepList;
    }

    public static DEPExportFormat parseDEPInput(URI inputFileString, boolean verbose) throws IOException {
        return Prueftool.parseDEP(inputFileString, verbose);
    }

    public static DEPExportFormat parseDEPInput(String inputFileString, boolean verbose) throws IOException {
        return Prueftool.parseDEP(inputFileString, verbose);
    }

    private static DEPExportFormat parseDEP(Object input, boolean verbose) throws IOException {
        if (input == null) {
            throw new IOException("need a RKSV_DEP_EXPORT export file as input... specify file with -i");
        }
        File depIn = input instanceof String ? new File((String)input) : new File((URI)input);
        if (!depIn.exists()) {
            throw new IOException(String.format("RKSV_DEP_EXPORT file %s does not exist.\nExiting.", input));
        }
        if (verbose) {
            System.out.format("Loading RKSV_DEP_EXPORT from %s\n", depIn.getAbsolutePath());
        }
        try (FileInputStream json = new FileInputStream(depIn);){
            DEPExportFormat dEPExportFormat = (DEPExportFormat)RKObjectMapper.load((InputStream)json, DEPExportFormat.class);
            return dEPExportFormat;
        }
    }

    public static void writeMachineReadableCodeResultToFile(String outputDir, int index, VerificationResult result) {
        Throwable throwable;
        OutputStreamWriter out;
        VerificationResult resultApp = new VerificationResult(result);
        VerificationResult resultCashbox = new VerificationResult(result);
        VerificationResult resultCashboxFull = new VerificationResult(result);
        resultApp = TRANSFORM_APP.transform(resultApp);
        ResourceInjector.transform((VerificationResult)resultApp, (Locale)new Locale("de"));
        TRANSFORM_CB.setRemoveResultsWithStatePass(true);
        resultCashbox = TRANSFORM_CB.transform(resultCashbox);
        ResourceInjector.transform((VerificationResult)resultCashbox, (Locale)new Locale("de"));
        TRANSFORM_CB.setRemoveResultsWithStatePass(false);
        resultCashboxFull = TRANSFORM_CB.transform(resultCashboxFull);
        ResourceInjector.transform((VerificationResult)resultCashboxFull, (Locale)new Locale("de"));
        String outputFileString = String.format(outputDir + File.separator + "%04d_app.json", index);
        try {
            out = new OutputStreamWriter(new BufferedOutputStream(new FileOutputStream(outputFileString)));
            throwable = null;
            try {
                out.write(RKObjectMapper.stringify((Object)resultApp));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error writing result #" + index + ": " + e.getMessage());
        }
        outputFileString = String.format(outputDir + File.separator + "%04d_cashbox.json", index);
        try {
            out = new OutputStreamWriter(new BufferedOutputStream(new FileOutputStream(outputFileString)));
            throwable = null;
            try {
                out.write(RKObjectMapper.stringify((Object)resultCashbox));
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error writing result #" + index + ": " + e.getMessage());
        }
        outputFileString = String.format(outputDir + File.separator + "%04d_cashbox_full.json", index);
        try {
            out = new OutputStreamWriter(new BufferedOutputStream(new FileOutputStream(outputFileString)));
            throwable = null;
            try {
                out.write(RKObjectMapper.stringify((Object)resultCashboxFull));
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable7) {
                            throwable.addSuppressed(throwable7);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error writing result #" + index + ": " + e.getMessage());
        }
    }

    public static void writeRksvDepResultToFile(String outputDir, int index, VerificationResult rksvDepResult) {
        String outputFileString = String.format(outputDir + File.separator + "%04d_dep.json", index);
        try (OutputStreamWriter out = new OutputStreamWriter(new BufferedOutputStream(new FileOutputStream(outputFileString)));){
            out.write(RKObjectMapper.stringify((Object)rksvDepResult));
        }
        catch (Exception e) {
            System.err.println("Error writing result #" + index + ": " + e.getMessage());
        }
    }

    static VerificationResult checkReceipt(MockDBModule mockDBModule, String receipt, boolean allowFuture) {
        VerificationResult startType;
        VerificationResult preparedReceipt = null;
        try {
            preparedReceipt = GeneratedTestDB.prepareReceipt((String)receipt);
        }
        catch (Exception e) {
            preparedReceipt = BaseVerificationModule.prepareInput((VerificationProperty[])new VerificationProperty[]{new VerificationProperty(VerificationInputOutput.RECEIPT, receipt), new VerificationProperty(VerificationInputOutput.AUTH_LEVEL, (Enum)AuthLevel.CASHBOX), new VerificationProperty(VerificationInputOutput.LANGUAGE, "de"), new VerificationProperty(VerificationInputOutput.AUTH_CODE, "dummy"), new VerificationProperty(VerificationInputOutput.SID, "NULL")});
        }
        if (allowFuture) {
            preparedReceipt.addInput(new VerificationProperty(VerificationInputOutput.TIMEOFVERIFICATION, BaseVerificationModule.DATE_FORMAT.print(0x5FFFFFFFFFFFFFFDL)));
        }
        preparedReceipt.addInput(new VerificationProperty(VerificationInputOutput.AUTH_LEVEL, (Enum)AuthLevel.FULL));
        VerificationResult result = new RKSVDBModule().verifySingle(preparedReceipt);
        if (result.getVerificationState() == VerificationState.FAIL && (startType = result.getSubResult(VerificationID.TYPE_OF_RECEIPT_START)) != null && startType.getVerificationState() == VerificationState.PASS) {
            VerificationResult state = result.getSubResult(VerificationID.STATE_CONSOLIDATED);
            if (state == null || state.getVerificationState() == VerificationState.FAIL) {
                // empty if block
            }
            mockDBModule.setCanActivate(true);
            mockDBModule.setCashboxState1(CashBoxState.REGISTRIERT);
            mockDBModule.setCashboxState2(CashBoxState.REGISTRIERT);
            mockDBModule.setKeyForState2(true);
            result = new RKSVDBModule().verifySingle(preparedReceipt);
            mockDBModule.setCanActivate(false);
            mockDBModule.setCashboxState1(CashBoxState.IN_BETRIEB);
            mockDBModule.setCashboxState2(CashBoxState.IN_BETRIEB);
            mockDBModule.setKeyForState2(false);
        }
        return result;
    }

    public static void checkUnlimitedStrength() {
        if (!CryptoUtil.isUnlimitedStrengthPolicyAvailable()) {
            System.out.println("Your JVM does not provide the unlimited strength policy. However, this policy is required to enable strong cryptography (e.g. AES with 256 bits). Please install the required policy files.");
            System.exit(0);
        }
    }

    public static X509Certificate parseCertificate(InputStream inputStream) throws CertificateException {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        return (X509Certificate)certificateFactory.generateCertificate(inputStream);
    }

    public static List<String> loadSingleReceipts(String inputFileString) throws IOException {
        try (BufferedInputStream jsonIn = new BufferedInputStream(new FileInputStream(inputFileString));){
            List qrCodeRepList;
            List list = qrCodeRepList = (List)RKObjectMapper.load((InputStream)jsonIn, List.class);
            return list;
        }
    }

    public static CommandLine parseCommands(String[] args) throws ParseException {
        Options options = new Options();
        options.addOption("i", "dep-export-file-to-validate", true, "specifies a RKSV_DEP_EXPORT export file and verifies stored receipts (signature, chaining)");
        options.addOption("c", "crypto-material-container", true, "specifies a file that contains the AES key of a cashbox and the asymmetric key material used to verify the receipt signature");
        options.addOption("o", "output-directory", true, "specifies a directory to log outputs to");
        options.addOption("f", "future", false, "allow verification of receipts that were created in the future");
        options.addOption("v", "verbose", false, "verbose output");
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = parser.parse(options, args);
        return cmd;
    }

    public static File checkOutputDir(String outputDirString) throws IOException {
        File outputDir = null;
        if (outputDirString == null) {
            throw new IOException("need an OUTPUT directory for storing detailed results... specify dir with -o, the directory will be created if it does not exist");
        }
        outputDir = new File(outputDirString);
        if (outputDir.isFile()) {
            throw new IOException("the specified OUTPUT directory is a file, you need to specify a directory");
        }
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        return outputDir;
    }

    public static String dumpToString(VerificationResult result, int index, boolean verbose) {
        CashBoxEntryPoint cashboxTransform = new CashBoxEntryPoint();
        VerificationResult clonedResult = new VerificationResult(result);
        StringBuilder dump = new StringBuilder("");
        dump.append("Machine readable code validation # " + index + ": ");
        if (clonedResult.getVerificationState() == VerificationState.PASS) {
            dump.append("PASS\n");
        } else if (clonedResult.getVerificationState() == VerificationState.FAIL) {
            dump.append("FAIL\n");
        }
        if (clonedResult.getVerificationState() == VerificationState.FAIL || verbose) {
            cashboxTransform.transform(clonedResult);
            ResourceInjector.transform((VerificationResult)clonedResult, (Locale)new Locale("de"));
            dump.append("DETAILS:\n").append(clonedResult).append("\n");
            dump.append("-----------------------------\n");
        }
        return dump.append("").toString();
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
        Prueftool.checkUnlimitedStrength();
        try {
            ResourceInjector.setRsrcRepo((ResourceRepository)new ClassPathRepo());
        }
        catch (IOException e) {
            System.err.println("Could not load message strings.\nExiting");
            System.exit(-1);
        }
        TRANSFORM_CB = new CashBoxEntryPoint();
        TRANSFORM_APP = new AppEntryPoint();
    }
}

