/*
 * Decompiled with CFR 0.152.
 */
package at.asitplus.regkassen.verification.modules;

import at.asitplus.regkassen.common.MachineCodeValue;
import at.asitplus.regkassen.common.TypeOfReceipt;
import at.asitplus.regkassen.common.util.CashBoxUtils;
import at.asitplus.regkassen.verification.common.BaseVerificationModule;
import at.asitplus.regkassen.verification.common.annotations.VerificationModule;
import at.asitplus.regkassen.verification.common.data.I18nDetailedMessageID;
import at.asitplus.regkassen.verification.common.data.Placeholder;
import at.asitplus.regkassen.verification.common.data.VerificationID;
import at.asitplus.regkassen.verification.common.data.VerificationInputOutput;
import at.asitplus.regkassen.verification.common.data.VerificationProperty;
import at.asitplus.regkassen.verification.common.data.VerificationResult;
import at.asitplus.regkassen.verification.common.data.VerificationState;
import at.asitplus.regkassen.verification.modules.fragments.DEPChainingValueVerificationModule;
import at.asitplus.regkassen.verification.modules.fragments.DEPOnlyOneCashBoxIDModule;
import at.asitplus.regkassen.verification.modules.fragments.DEPOnlyOneSystemTypeModule;
import at.asitplus.regkassen.verification.modules.fragments.DEPStateVerificationModule;
import at.asitplus.regkassen.verification.modules.fragments.DEPTurnoverCompareModule;
import at.asitplus.regkassen.verification.modules.fragments.DEPUniqueReceiptIDModule;

@VerificationModule(inputProperties={VerificationInputOutput.RK_SUITE_ID, VerificationInputOutput.RECEIPT, VerificationInputOutput.RECEIPT_PREV, VerificationInputOutput.TYPE_RECEIPT, VerificationInputOutput.TYPE_RECEIPT_PREV, VerificationInputOutput.SIGNED_PREV, VerificationInputOutput.SIGNED_PENULT, VerificationInputOutput.DECRYPTED_TURNOVER_VALUE, VerificationInputOutput.TURNOVER_SUM, VerificationInputOutput.CASHBOX_ID_INITIAL, VerificationInputOutput.CASHBOX_ID, VerificationInputOutput.SYSTEM_TYPE_INITIAL, VerificationInputOutput.SYSTEM_TYPE, VerificationInputOutput.KNOWN_RECEIPT_IDS}, version=1, verificationID=VerificationID.RKSV_DEP_EXPORT)
public class DEPVerificationModule
extends BaseVerificationModule {
    private final DEPTurnoverCompareModule turnoverModule = new DEPTurnoverCompareModule();
    private final DEPChainingValueVerificationModule chainingModule = new DEPChainingValueVerificationModule();
    private final DEPStateVerificationModule depStateModule = new DEPStateVerificationModule();
    private final DEPOnlyOneCashBoxIDModule onlyOneCashBoxIDModule = new DEPOnlyOneCashBoxIDModule();
    private final DEPOnlyOneSystemTypeModule onlyOneSystemTypeModule = new DEPOnlyOneSystemTypeModule();
    private final DEPUniqueReceiptIDModule uniqueReceiptIDModule = new DEPUniqueReceiptIDModule();

    protected VerificationResult doVerify(VerificationResult verificationResult) {
        String current = verificationResult.getInputData(VerificationInputOutput.RECEIPT).getValue();
        VerificationResult stateResult = new VerificationResult();
        stateResult.addInput(verificationResult.getInputData(VerificationInputOutput.TYPE_RECEIPT));
        stateResult.addInput(verificationResult.getInputData(VerificationInputOutput.TYPE_RECEIPT_PREV));
        stateResult.addInput(verificationResult.getInputData(VerificationInputOutput.SIGNED_PREV));
        stateResult.addInput(verificationResult.getInputData(VerificationInputOutput.SIGNED_PENULT));
        stateResult = this.depStateModule.verifySingle(stateResult);
        verificationResult.addVerificationResult(stateResult);
        boolean softfail = Boolean.parseBoolean(stateResult.getOutputData(VerificationInputOutput.SOFTFAIL).getValue());
        if (!softfail && stateResult.getVerificationState() != VerificationState.PASS) {
            verificationResult.setDetailedMessage(stateResult.getDetailedMsgID(), stateResult.getDetailedMsgParams());
            verificationResult.setVerificationState(VerificationState.FAIL);
            return verificationResult;
        }
        if (softfail) {
            verificationResult.addOutput(VerificationInputOutput.SOFTFAIL, Boolean.toString(true));
        }
        if (current.equals(Placeholder.NULL.name())) {
            verificationResult.setVerificationState(stateResult.getVerificationState());
            return verificationResult;
        }
        VerificationResult uniqueIDResult = new VerificationResult();
        uniqueIDResult.addInput(verificationResult.getInputData(VerificationInputOutput.KNOWN_RECEIPT_IDS));
        uniqueIDResult.addInput(new VerificationProperty(VerificationInputOutput.RECEIPT_IDENTIFIER, CashBoxUtils.getValueFromMachineCode((String)verificationResult.getInputData(VerificationInputOutput.RECEIPT).getValue(), (MachineCodeValue)MachineCodeValue.RECEIPT_IDENTIFIER)));
        uniqueIDResult = this.uniqueReceiptIDModule.verifySingle(uniqueIDResult);
        verificationResult.addVerificationResult(uniqueIDResult);
        softfail = Boolean.parseBoolean(uniqueIDResult.getOutputData(VerificationInputOutput.SOFTFAIL).getValue());
        if (!softfail && uniqueIDResult.getVerificationState() != VerificationState.PASS) {
            verificationResult.setDetailedMessage(uniqueIDResult.getDetailedMsgID(), uniqueIDResult.getDetailedMsgParams());
            verificationResult.setVerificationState(VerificationState.FAIL);
            verificationResult.addOutput(VerificationInputOutput.SOFTFAIL, Boolean.toString(false));
            return verificationResult;
        }
        if (softfail) {
            verificationResult.addOutput(VerificationInputOutput.SOFTFAIL, Boolean.toString(true));
        }
        if (!verificationResult.getInputData(VerificationInputOutput.CASHBOX_ID).getValue().equals(Placeholder.NULL.toString())) {
            VerificationResult onlyOneCashBoxIdResult = new VerificationResult();
            onlyOneCashBoxIdResult.addInput(verificationResult.getInputData(VerificationInputOutput.CASHBOX_ID_INITIAL));
            onlyOneCashBoxIdResult.addInput(verificationResult.getInputData(VerificationInputOutput.CASHBOX_ID));
            onlyOneCashBoxIdResult = this.onlyOneCashBoxIDModule.verifySingle(onlyOneCashBoxIdResult);
            verificationResult.addVerificationResult(onlyOneCashBoxIdResult);
            softfail = Boolean.parseBoolean(onlyOneCashBoxIdResult.getOutputData(VerificationInputOutput.SOFTFAIL).getValue());
            if (!softfail && onlyOneCashBoxIdResult.getVerificationState() != VerificationState.PASS) {
                verificationResult.setVerificationState(VerificationState.FAIL);
                verificationResult.setDetailedMessage(onlyOneCashBoxIdResult.getDetailedMsgID(), onlyOneCashBoxIdResult.getDetailedMsgParams());
                verificationResult.addOutput(VerificationInputOutput.SOFTFAIL, Boolean.toString(false));
                return verificationResult;
            }
            if (softfail) {
                verificationResult.addOutput(VerificationInputOutput.SOFTFAIL, Boolean.toString(true));
            }
        }
        if (!verificationResult.getInputData(VerificationInputOutput.SYSTEM_TYPE).getValue().equals(Placeholder.NULL.toString())) {
            VerificationResult onlyOneSystemTypeResult = new VerificationResult();
            onlyOneSystemTypeResult.addInput(verificationResult.getInputData(VerificationInputOutput.SYSTEM_TYPE_INITIAL));
            onlyOneSystemTypeResult.addInput(verificationResult.getInputData(VerificationInputOutput.SYSTEM_TYPE));
            onlyOneSystemTypeResult = this.onlyOneSystemTypeModule.verifySingle(onlyOneSystemTypeResult);
            verificationResult.addVerificationResult(onlyOneSystemTypeResult);
            softfail = Boolean.parseBoolean(onlyOneSystemTypeResult.getOutputData(VerificationInputOutput.SOFTFAIL).getValue());
            if (!softfail && onlyOneSystemTypeResult.getVerificationState() != VerificationState.PASS) {
                verificationResult.setVerificationState(VerificationState.FAIL);
                verificationResult.setDetailedMessage(onlyOneSystemTypeResult.getDetailedMsgID(), onlyOneSystemTypeResult.getDetailedMsgParams());
                verificationResult.addOutput(VerificationInputOutput.SOFTFAIL, Boolean.toString(false));
                return verificationResult;
            }
            if (softfail) {
                verificationResult.addOutput(VerificationInputOutput.SOFTFAIL, Boolean.toString(true));
            }
        }
        VerificationProperty prevSum = verificationResult.getInputData(VerificationInputOutput.TURNOVER_SUM);
        VerificationResult turnoverResult = new VerificationResult();
        turnoverResult.addInput(prevSum);
        turnoverResult.addInput(verificationResult.getInputData(VerificationInputOutput.DECRYPTED_TURNOVER_VALUE));
        turnoverResult.addInput(verificationResult.getInputData(VerificationInputOutput.TYPE_RECEIPT));
        turnoverResult.addInput(new VerificationProperty(VerificationInputOutput.SUM_TAX_SET_BESONDERS, CashBoxUtils.getValueFromMachineCode((String)current, (MachineCodeValue)MachineCodeValue.SUM_TAX_SET_BESONDERS)));
        turnoverResult.addInput(new VerificationProperty(VerificationInputOutput.SUM_TAX_SET_ERMAESSIGT1, CashBoxUtils.getValueFromMachineCode((String)current, (MachineCodeValue)MachineCodeValue.SUM_TAX_SET_ERMAESSIGT1)));
        turnoverResult.addInput(new VerificationProperty(VerificationInputOutput.SUM_TAX_SET_ERMAESSIGT2, CashBoxUtils.getValueFromMachineCode((String)current, (MachineCodeValue)MachineCodeValue.SUM_TAX_SET_ERMAESSIGT2)));
        turnoverResult.addInput(new VerificationProperty(VerificationInputOutput.SUM_TAX_SET_NORMAL, CashBoxUtils.getValueFromMachineCode((String)current, (MachineCodeValue)MachineCodeValue.SUM_TAX_SET_NORMAL)));
        turnoverResult.addInput(new VerificationProperty(VerificationInputOutput.SUM_TAX_SET_NULL, CashBoxUtils.getValueFromMachineCode((String)current, (MachineCodeValue)MachineCodeValue.SUM_TAX_SET_NULL)));
        turnoverResult = this.turnoverModule.verifySingle(turnoverResult);
        verificationResult.addVerificationResult(turnoverResult);
        if (turnoverResult.getVerificationState() != VerificationState.PASS) {
            verificationResult.setVerificationState(VerificationState.FAIL);
            verificationResult.setDetailedMessage(turnoverResult.getDetailedMsgID(), turnoverResult.getDetailedMsgParams());
            verificationResult.addOutput(VerificationInputOutput.SOFTFAIL, Boolean.toString(false));
            return verificationResult;
        }
        TypeOfReceipt type = TypeOfReceipt.valueOf((String)verificationResult.getInputData(VerificationInputOutput.TYPE_RECEIPT).getValue());
        if (type != TypeOfReceipt.START_BELEG) {
            VerificationProperty prevReceipt = verificationResult.getInputData(VerificationInputOutput.RECEIPT_PREV);
            VerificationResult chainResult = new VerificationResult();
            chainResult.addInput(verificationResult.getInputData(VerificationInputOutput.RK_SUITE_ID));
            chainResult.addInput(new VerificationProperty(VerificationInputOutput.CHAINING_VALUE_PREVIOUS_RECEIPT, CashBoxUtils.getValueFromMachineCode((String)current, (MachineCodeValue)MachineCodeValue.CHAINING_VALUE_PREVIOUS_RECEIPT)));
            chainResult.addInput(new VerificationProperty(VerificationInputOutput.CHAINING_INPUT, CashBoxUtils.getJWSCompactRepresentationFromQRMachineCodeRepresentation((String)prevReceipt.getValue())));
            chainResult = this.chainingModule.verifySingle(chainResult);
            verificationResult.addVerificationResult(chainResult);
            if (chainResult.getVerificationState() != VerificationState.PASS) {
                verificationResult.setVerificationState(VerificationState.FAIL);
                verificationResult.setDetailedMessage(chainResult.getDetailedMsgID(), chainResult.getDetailedMsgParams());
                verificationResult.addOutput(VerificationInputOutput.SOFTFAIL, Boolean.toString(false));
                return verificationResult;
            }
        }
        verificationResult.setDetailedMessage(I18nDetailedMessageID.DEP_OK, new String[0]);
        verificationResult.setVerificationState(VerificationState.PASS);
        if (Boolean.parseBoolean(verificationResult.getOutputData(VerificationInputOutput.SOFTFAIL).getValue())) {
            verificationResult.setDetailedMessage(I18nDetailedMessageID.DEP_SOFTFAIL, new String[0]);
            verificationResult.setVerificationState(VerificationState.FAIL);
        }
        return verificationResult;
    }
}

