/*
 * Decompiled with CFR 0.152.
 */
package at.asitplus.regkassen.verification.modules.fragments;

import at.asitplus.regkassen.common.RKSuiteIdentifier;
import at.asitplus.regkassen.common.util.CashBoxUtils;
import at.asitplus.regkassen.verification.common.BaseVerificationModule;
import at.asitplus.regkassen.verification.common.annotations.VerificationModule;
import at.asitplus.regkassen.verification.common.data.I18nDetailedMessageID;
import at.asitplus.regkassen.verification.common.data.VerificationID;
import at.asitplus.regkassen.verification.common.data.VerificationInputOutput;
import at.asitplus.regkassen.verification.common.data.VerificationResult;
import at.asitplus.regkassen.verification.common.data.VerificationState;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

@VerificationModule(inputProperties={VerificationInputOutput.CHAINING_VALUE_PREVIOUS_RECEIPT, VerificationInputOutput.CHAINING_INPUT, VerificationInputOutput.RK_SUITE_ID}, verificationID=VerificationID.DEP_CHAINING_VALUE, version=1)
public class DEPChainingValueVerificationModule
extends BaseVerificationModule {
    protected VerificationResult doVerify(VerificationResult verificationResult) {
        MessageDigest messageDigest;
        String input = verificationResult.getInputData(VerificationInputOutput.CHAINING_INPUT).getValue();
        String chainingValue = verificationResult.getInputData(VerificationInputOutput.CHAINING_VALUE_PREVIOUS_RECEIPT).getValue();
        byte[] hashInput = input.getBytes(Charset.forName("UTF-8"));
        RKSuiteIdentifier rk = RKSuiteIdentifier.valueOf((String)verificationResult.getInputData(VerificationInputOutput.RK_SUITE_ID).getValue());
        try {
            messageDigest = MessageDigest.getInstance(rk.getHashAlgorithmForPreviousSignatureValue());
        }
        catch (NoSuchAlgorithmException e) {
            verificationResult.setDetailedMessage(I18nDetailedMessageID.DEP_FAIL_INTERNAL_TURNOVER, new String[0]);
            verificationResult.setVerificationState(VerificationState.FAIL);
            return verificationResult;
        }
        messageDigest.update(hashInput);
        byte[] hashValue = messageDigest.digest();
        byte[] chainValue = new byte[rk.getNumberOfBytesExtractedFromPrevSigHash()];
        System.arraycopy(hashValue, 0, chainValue, 0, rk.getNumberOfBytesExtractedFromPrevSigHash());
        String calculatedChainingValue = CashBoxUtils.base64Encode((byte[])chainValue, (boolean)false);
        boolean equals = calculatedChainingValue.equals(chainingValue);
        if (equals) {
            verificationResult.setVerificationState(VerificationState.PASS);
        } else {
            verificationResult.setVerificationState(VerificationState.FAIL);
            verificationResult.setDetailedMessage(I18nDetailedMessageID.DEP_FAIL_CHAIN, new String[0]);
        }
        return verificationResult;
    }
}

