/*
 * Decompiled with CFR 0.152.
 */
package at.asitplus.regkassen.verification.modules.fragments;

import at.asitplus.regkassen.common.TypeOfReceipt;
import at.asitplus.regkassen.verification.common.BaseVerificationModule;
import at.asitplus.regkassen.verification.common.annotations.VerificationModule;
import at.asitplus.regkassen.verification.common.data.I18nDetailedMessageID;
import at.asitplus.regkassen.verification.common.data.VerificationID;
import at.asitplus.regkassen.verification.common.data.VerificationInputOutput;
import at.asitplus.regkassen.verification.common.data.VerificationResult;
import at.asitplus.regkassen.verification.common.data.VerificationState;

@VerificationModule(inputProperties={VerificationInputOutput.TURNOVER_SUM, VerificationInputOutput.SUM_TAX_SET_BESONDERS, VerificationInputOutput.SUM_TAX_SET_ERMAESSIGT1, VerificationInputOutput.SUM_TAX_SET_ERMAESSIGT2, VerificationInputOutput.SUM_TAX_SET_NORMAL, VerificationInputOutput.SUM_TAX_SET_NULL, VerificationInputOutput.DECRYPTED_TURNOVER_VALUE, VerificationInputOutput.TYPE_RECEIPT}, verificationID=VerificationID.DEP_TURNOVER_COMPARE, version=1)
public class DEPTurnoverCompareModule
extends BaseVerificationModule {
    protected VerificationResult doVerify(VerificationResult verificationResult) {
        long computed = Long.parseLong(verificationResult.getInputData(VerificationInputOutput.TURNOVER_SUM).getValue());
        TypeOfReceipt type = TypeOfReceipt.valueOf((String)verificationResult.getInputData(VerificationInputOutput.TYPE_RECEIPT).getValue());
        if (type == TypeOfReceipt.TRAINING_BELEG) {
            verificationResult.setVerificationState(VerificationState.PASS);
            verificationResult.addOutput(VerificationInputOutput.TURNOVER_SUM, Long.toString(computed));
            return verificationResult;
        }
        computed += this.extractLongValueFromTaxSet(verificationResult, VerificationInputOutput.SUM_TAX_SET_BESONDERS);
        computed += this.extractLongValueFromTaxSet(verificationResult, VerificationInputOutput.SUM_TAX_SET_ERMAESSIGT1);
        computed += this.extractLongValueFromTaxSet(verificationResult, VerificationInputOutput.SUM_TAX_SET_ERMAESSIGT2);
        computed += this.extractLongValueFromTaxSet(verificationResult, VerificationInputOutput.SUM_TAX_SET_NORMAL);
        if (type != TypeOfReceipt.STORNO_BELEG && Long.parseLong(verificationResult.getInputData(VerificationInputOutput.DECRYPTED_TURNOVER_VALUE).getValue()) != (computed += this.extractLongValueFromTaxSet(verificationResult, VerificationInputOutput.SUM_TAX_SET_NULL))) {
            verificationResult.setDetailedMessage(I18nDetailedMessageID.DEP_FAIL_TURNOVER, new String[0]);
            verificationResult.setVerificationState(VerificationState.FAIL);
        } else {
            verificationResult.setVerificationState(VerificationState.PASS);
        }
        verificationResult.addOutput(VerificationInputOutput.TURNOVER_SUM, Long.toString(computed));
        return verificationResult;
    }

    private long extractLongValueFromTaxSet(VerificationResult verificationResult, VerificationInputOutput taxSet) {
        return Long.parseLong(verificationResult.getInputData(taxSet).getValue().replace(",", "").replace(".", ""));
    }
}

