/*
 * Decompiled with CFR 0.152.
 */
package at.asitplus.regkassen.verification.modules.fragments;

import at.asitplus.regkassen.verification.common.BaseVerificationModule;
import at.asitplus.regkassen.verification.common.annotations.VerificationModule;
import at.asitplus.regkassen.verification.common.data.I18nDetailedMessageID;
import at.asitplus.regkassen.verification.common.data.Placeholder;
import at.asitplus.regkassen.verification.common.data.VerificationID;
import at.asitplus.regkassen.verification.common.data.VerificationInputOutput;
import at.asitplus.regkassen.verification.common.data.VerificationResult;
import at.asitplus.regkassen.verification.common.data.VerificationState;
import java.util.Arrays;

@VerificationModule(inputProperties={VerificationInputOutput.KNOWN_RECEIPT_IDS, VerificationInputOutput.RECEIPT_IDENTIFIER}, verificationID=VerificationID.DEP_UNIQUE_RECEIPT_ID, version=1)
public class DEPUniqueReceiptIDModule
extends BaseVerificationModule {
    protected VerificationResult doVerify(VerificationResult verificationResult) {
        String id = verificationResult.getInputData(VerificationInputOutput.RECEIPT_IDENTIFIER).getValue();
        String idsString = verificationResult.getInputData(VerificationInputOutput.KNOWN_RECEIPT_IDS).getValue();
        if (idsString.equals(Placeholder.NULL.name())) {
            idsString = "";
        }
        String[] ids = idsString.split("_");
        idsString = idsString + "_" + id;
        verificationResult.addOutput(VerificationInputOutput.KNOWN_RECEIPT_IDS, idsString);
        if (Arrays.asList(ids).contains(id)) {
            verificationResult.setDetailedMessage(I18nDetailedMessageID.DEP_FAIL_UNIQUE_RECEIPT_ID, new String[]{id});
            verificationResult.addOutput(VerificationInputOutput.SOFTFAIL, Boolean.toString(true));
            verificationResult.setVerificationState(VerificationState.FAIL);
            return verificationResult;
        }
        verificationResult.setVerificationState(VerificationState.PASS);
        return verificationResult;
    }
}

