/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.fonts;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.afp.AFPEventProducer;
import org.apache.fop.afp.fonts.AbstractOutlineFont;
import org.apache.fop.afp.fonts.CharacterSet;

public class DoubleByteFont
extends AbstractOutlineFont {
    private static final Log log = LogFactory.getLog(DoubleByteFont.class);
    private final Set<Integer> charsProcessed = new HashSet<Integer>();
    private static final Set<Character.UnicodeBlock> IDEOGRAPHIC = new HashSet<Character.UnicodeBlock>();

    public DoubleByteFont(String name, boolean embeddable, CharacterSet charSet, AFPEventProducer eventProducer) {
        super(name, embeddable, charSet, eventProducer);
    }

    public int getWidth(int character, int size) {
        int charWidth;
        try {
            charWidth = this.charSet.getWidth(DoubleByteFont.toUnicodeCodepoint(character));
        }
        catch (IllegalArgumentException e) {
            if (!this.charsProcessed.contains(character)) {
                this.charsProcessed.add(character);
                this.getAFPEventProducer().charactersetMissingMetrics(this, (char)character, this.charSet.getName().trim());
            }
            charWidth = -1;
        }
        if (charWidth == -1) {
            charWidth = this.getDefaultCharacterWidth(character);
        }
        return charWidth * size;
    }

    private int getDefaultCharacterWidth(int character) {
        int nominalCharIncrement = this.charSet.getNominalCharIncrement();
        if (nominalCharIncrement > 0) {
            return nominalCharIncrement;
        }
        return this.inferCharWidth(character);
    }

    private int inferCharWidth(int character) {
        boolean isIdeographic = false;
        Character.UnicodeBlock charBlock = Character.UnicodeBlock.of((char)character);
        isIdeographic = charBlock == null ? false : IDEOGRAPHIC.contains(charBlock);
        if (isIdeographic) {
            return this.charSet.getEmSpaceIncrement();
        }
        return this.charSet.getSpaceIncrement();
    }

    static {
        IDEOGRAPHIC.add(Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS);
        IDEOGRAPHIC.add(Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS);
        IDEOGRAPHIC.add(Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A);
    }
}

