/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.fonts;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.afp.fonts.AFPFont;
import org.apache.fop.afp.fonts.CharacterSet;
import org.apache.fop.afp.fonts.FontRuntimeException;

public class RasterFont
extends AFPFont {
    protected static final Log LOG = LogFactory.getLog((String)"org.apache.fop.afp.fonts");
    private final SortedMap<Integer, CharacterSet> charSets = new TreeMap<Integer, CharacterSet>();
    private Map<Integer, CharacterSet> substitutionCharSets;
    private CharacterSet charSet = null;

    public RasterFont(String name, boolean embeddable) {
        super(name, embeddable);
    }

    public void addCharacterSet(int size, CharacterSet characterSet) {
        this.charSets.put(new Integer(size), characterSet);
        this.charSet = characterSet;
    }

    public CharacterSet getCharacterSet(int sizeInMpt) {
        Integer requestedSize = sizeInMpt;
        CharacterSet csm = (CharacterSet)this.charSets.get(requestedSize);
        double sizeInPt = (double)sizeInMpt / 1000.0;
        if (csm != null) {
            return csm;
        }
        if (this.substitutionCharSets != null) {
            csm = this.substitutionCharSets.get(requestedSize);
        }
        if (csm == null && !this.charSets.isEmpty()) {
            SortedMap<Integer, CharacterSet> smallerSizes = this.charSets.headMap(requestedSize);
            SortedMap<Integer, CharacterSet> largerSizes = this.charSets.tailMap(requestedSize);
            int smallerSize = smallerSizes.isEmpty() ? 0 : smallerSizes.lastKey();
            int largerSize = largerSizes.isEmpty() ? Integer.MAX_VALUE : largerSizes.firstKey();
            Integer fontSize = !smallerSizes.isEmpty() && sizeInMpt - smallerSize <= largerSize - sizeInMpt ? Integer.valueOf(smallerSize) : Integer.valueOf(largerSize);
            csm = (CharacterSet)this.charSets.get(fontSize);
            if (csm != null) {
                if (this.substitutionCharSets == null) {
                    this.substitutionCharSets = new HashMap<Integer, CharacterSet>();
                }
                this.substitutionCharSets.put(requestedSize, csm);
                if (!(Math.abs((double)fontSize.intValue() / 1000.0 - sizeInPt) < 0.1)) {
                    String msg = "No " + sizeInPt + "pt font " + this.getFontName() + " found, substituted with " + (float)fontSize.intValue() / 1000.0f + "pt font";
                    LOG.warn((Object)msg);
                }
            }
        }
        if (csm == null) {
            String msg = "No font found for font " + this.getFontName() + " with point size " + sizeInPt;
            LOG.error((Object)msg);
            throw new FontRuntimeException(msg);
        }
        return csm;
    }

    public int getFirstChar() {
        Iterator<CharacterSet> it = this.charSets.values().iterator();
        if (it.hasNext()) {
            CharacterSet csm = it.next();
            return csm.getFirstChar();
        }
        String msg = "getFirstChar() - No character set found for font:" + this.getFontName();
        LOG.error((Object)msg);
        throw new FontRuntimeException(msg);
    }

    public int getLastChar() {
        Iterator<CharacterSet> it = this.charSets.values().iterator();
        if (it.hasNext()) {
            CharacterSet csm = it.next();
            return csm.getLastChar();
        }
        String msg = "getLastChar() - No character set found for font:" + this.getFontName();
        LOG.error((Object)msg);
        throw new FontRuntimeException(msg);
    }

    private int metricsToAbsoluteSize(CharacterSet cs, int value, int givenSize) {
        int nominalVerticalSize = cs.getNominalVerticalSize();
        if (nominalVerticalSize != 0) {
            return value * nominalVerticalSize;
        }
        return value * givenSize;
    }

    public int getAscender(int size) {
        CharacterSet cs = this.getCharacterSet(size);
        return this.metricsToAbsoluteSize(cs, cs.getAscender(), size);
    }

    public int getCapHeight(int size) {
        CharacterSet cs = this.getCharacterSet(size);
        return this.metricsToAbsoluteSize(cs, cs.getCapHeight(), size);
    }

    public int getDescender(int size) {
        CharacterSet cs = this.getCharacterSet(size);
        return this.metricsToAbsoluteSize(cs, cs.getDescender(), size);
    }

    public int getXHeight(int size) {
        CharacterSet cs = this.getCharacterSet(size);
        return this.metricsToAbsoluteSize(cs, cs.getXHeight(), size);
    }

    public int getWidth(int character, int size) {
        CharacterSet cs = this.getCharacterSet(size);
        return this.metricsToAbsoluteSize(cs, cs.getWidth(RasterFont.toUnicodeCodepoint(character)), size);
    }

    public int[] getWidths(int size) {
        CharacterSet cs = this.getCharacterSet(size);
        int[] widths = cs.getWidths();
        int c = widths.length;
        for (int i = 0; i < c; ++i) {
            widths[i] = this.metricsToAbsoluteSize(cs, widths[i], size);
        }
        return widths;
    }

    public int[] getWidths() {
        return this.getWidths(1000);
    }

    public boolean hasChar(char c) {
        return this.charSet.hasChar(c);
    }

    public char mapChar(char c) {
        return this.charSet.mapChar(c);
    }

    public String getEncodingName() {
        return this.charSet.getEncoding();
    }
}

