/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.apps.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.fop.apps.io.InternalResourceResolver;
import org.apache.xmlgraphics.io.Resource;
import org.apache.xmlgraphics.io.ResourceResolver;
import org.apache.xmlgraphics.io.TempResourceResolver;
import org.apache.xmlgraphics.io.TempResourceURIGenerator;

public final class ResourceResolverFactory {
    private ResourceResolverFactory() {
    }

    public static ResourceResolver createDefaultResourceResolver() {
        return DefaultResourceResolver.INSTANCE;
    }

    public static InternalResourceResolver createDefaultInternalResourceResolver(URI baseURI) {
        return new InternalResourceResolver(baseURI, ResourceResolverFactory.createDefaultResourceResolver());
    }

    public static InternalResourceResolver createInternalResourceResolver(URI baseURI, ResourceResolver resolver) {
        return new InternalResourceResolver(baseURI, resolver);
    }

    public static ResourceResolver createTempAwareResourceResolver(TempResourceResolver tempResourceResolver, ResourceResolver defaultResourceResolver) {
        return new TempAwareResourceResolver(tempResourceResolver, defaultResourceResolver);
    }

    public static SchemeAwareResourceResolverBuilder createSchemeAwareResourceResolverBuilder(ResourceResolver defaultResolver) {
        return new SchemeAwareResourceResolverBuilderImpl(defaultResolver);
    }

    private static final class SchemeAwareResourceResolverBuilderImpl
    implements SchemeAwareResourceResolverBuilder {
        private SchemeAwareResourceResolverBuilder delegate;

        private SchemeAwareResourceResolverBuilderImpl(ResourceResolver defaultResolver) {
            this.delegate = new ActiveSchemeAwareResourceResolverBuilder(defaultResolver);
        }

        public void registerResourceResolverForScheme(String scheme, ResourceResolver resourceResolver) {
            this.delegate.registerResourceResolverForScheme(scheme, resourceResolver);
        }

        public ResourceResolver build() {
            ResourceResolver resourceResolver = this.delegate.build();
            this.delegate = CompletedSchemeAwareResourceResolverBuilder.INSTANCE;
            return resourceResolver;
        }
    }

    private static final class ActiveSchemeAwareResourceResolverBuilder
    implements SchemeAwareResourceResolverBuilder {
        private final Map<String, ResourceResolver> schemeHandlingResourceResolvers = new HashMap<String, ResourceResolver>();
        private final ResourceResolver defaultResolver;

        private ActiveSchemeAwareResourceResolverBuilder(ResourceResolver defaultResolver) {
            this.defaultResolver = defaultResolver;
        }

        public void registerResourceResolverForScheme(String scheme, ResourceResolver resourceResolver) {
            this.schemeHandlingResourceResolvers.put(scheme, resourceResolver);
        }

        public ResourceResolver build() {
            return new SchemeAwareResourceResolver(Collections.unmodifiableMap(this.schemeHandlingResourceResolvers), this.defaultResolver);
        }
    }

    private static final class CompletedSchemeAwareResourceResolverBuilder
    implements SchemeAwareResourceResolverBuilder {
        private static final SchemeAwareResourceResolverBuilder INSTANCE = new CompletedSchemeAwareResourceResolverBuilder();

        private CompletedSchemeAwareResourceResolverBuilder() {
        }

        public ResourceResolver build() {
            throw new IllegalStateException("Resource resolver already built");
        }

        public void registerResourceResolverForScheme(String scheme, ResourceResolver resourceResolver) {
            throw new IllegalStateException("Resource resolver already built");
        }
    }

    public static interface SchemeAwareResourceResolverBuilder {
        public void registerResourceResolverForScheme(String var1, ResourceResolver var2);

        public ResourceResolver build();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SchemeAwareResourceResolver
    implements ResourceResolver {
        private final Map<String, ResourceResolver> schemeHandlingResourceResolvers;
        private final ResourceResolver defaultResolver;

        private SchemeAwareResourceResolver(Map<String, ResourceResolver> schemEHandlingResourceResolvers, ResourceResolver defaultResolver) {
            this.schemeHandlingResourceResolvers = schemEHandlingResourceResolvers;
            this.defaultResolver = defaultResolver;
        }

        private ResourceResolver getResourceResolverForScheme(URI uri) {
            String scheme = uri.getScheme();
            if (this.schemeHandlingResourceResolvers.containsKey(scheme)) {
                return this.schemeHandlingResourceResolvers.get(scheme);
            }
            return this.defaultResolver;
        }

        public Resource getResource(URI uri) throws IOException {
            return this.getResourceResolverForScheme(uri).getResource(uri);
        }

        public OutputStream getOutputStream(URI uri) throws IOException {
            return this.getResourceResolverForScheme(uri).getOutputStream(uri);
        }
    }

    private static class NormalResourceResolver
    implements ResourceResolver {
        private NormalResourceResolver() {
        }

        public Resource getResource(URI uri) throws IOException {
            return new Resource(uri.toURL().openStream());
        }

        public OutputStream getOutputStream(URI uri) throws IOException {
            return new FileOutputStream(new File(uri));
        }
    }

    private static class DefaultTempResourceResolver
    implements TempResourceResolver {
        private DefaultTempResourceResolver() {
        }

        private static File getTempFile(String path) throws IOException {
            File file = new File(System.getProperty("java.io.tmpdir"), path);
            file.deleteOnExit();
            return file;
        }

        public Resource getResource(String id) throws IOException {
            return new Resource(DefaultTempResourceResolver.getTempFile(id).toURI().toURL().openStream());
        }

        public OutputStream getOutputStream(String id) throws IOException {
            File file = DefaultTempResourceResolver.getTempFile(id);
            if (file.createNewFile()) {
                return new FileOutputStream(file);
            }
            throw new IOException("Filed to create temporary file: " + id);
        }
    }

    private static final class TempAwareResourceResolver
    implements ResourceResolver {
        private final TempResourceResolver tempResourceResolver;
        private final ResourceResolver defaultResourceResolver;

        public TempAwareResourceResolver(TempResourceResolver tempResourceHandler, ResourceResolver defaultResourceResolver) {
            this.tempResourceResolver = tempResourceHandler;
            this.defaultResourceResolver = defaultResourceResolver;
        }

        private static boolean isTempURI(URI uri) {
            return TempResourceURIGenerator.isTempURI((URI)uri);
        }

        public Resource getResource(URI uri) throws IOException {
            if (TempAwareResourceResolver.isTempURI(uri)) {
                return this.tempResourceResolver.getResource(uri.getPath());
            }
            return this.defaultResourceResolver.getResource(uri);
        }

        public OutputStream getOutputStream(URI uri) throws IOException {
            if (TempAwareResourceResolver.isTempURI(uri)) {
                return this.tempResourceResolver.getOutputStream(uri.getPath());
            }
            return this.defaultResourceResolver.getOutputStream(uri);
        }
    }

    private static final class DefaultResourceResolver
    implements ResourceResolver {
        private static final ResourceResolver INSTANCE = new DefaultResourceResolver();
        private final TempAwareResourceResolver delegate = new TempAwareResourceResolver(new DefaultTempResourceResolver(), new NormalResourceResolver());

        private DefaultResourceResolver() {
        }

        public Resource getResource(URI uri) throws IOException {
            return this.delegate.getResource(uri);
        }

        public OutputStream getOutputStream(URI uri) throws IOException {
            return this.delegate.getOutputStream(uri);
        }
    }
}

