/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.io.InternalResourceResolver;
import org.apache.fop.apps.io.ResourceResolverFactory;
import org.apache.fop.fonts.FontManager;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.fonts.substitute.FontSubstitutions;
import org.apache.fop.fonts.substitute.FontSubstitutionsConfigurator;
import org.apache.fop.util.LogUtil;
import org.apache.xmlgraphics.io.ResourceResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FontManagerConfigurator {
    private static Log log = LogFactory.getLog(FontManagerConfigurator.class);
    private final Configuration cfg;
    private final URI defaultBaseUri;
    private final ResourceResolver resourceResolver;

    public FontManagerConfigurator(Configuration cfg, URI defaultBaseUri, ResourceResolver resourceResolver) {
        this.cfg = cfg;
        this.defaultBaseUri = defaultBaseUri;
        this.resourceResolver = resourceResolver;
    }

    public void configure(FontManager fontManager, boolean strict) throws FOPException {
        Configuration fontsCfg;
        if (this.cfg.getChild("font-base", false) != null) {
            try {
                URI fontBase = InternalResourceResolver.getBaseURI(this.cfg.getChild("font-base").getValue(null));
                fontManager.setResourceResolver(ResourceResolverFactory.createInternalResourceResolver(this.defaultBaseUri.resolve(fontBase), this.resourceResolver));
            }
            catch (URISyntaxException use) {
                LogUtil.handleException(log, use, true);
            }
        } else {
            fontManager.setResourceResolver(ResourceResolverFactory.createInternalResourceResolver(this.defaultBaseUri, this.resourceResolver));
        }
        if (this.cfg.getChild("use-cache", false) != null) {
            try {
                if (!this.cfg.getChild("use-cache").getValueAsBoolean()) {
                    fontManager.disableFontCache();
                } else if (this.cfg.getChild("cache-file", false) != null) {
                    fontManager.setCacheFile(URI.create(this.cfg.getChild("cache-file").getValue()));
                }
            }
            catch (ConfigurationException mfue) {
                LogUtil.handleException(log, (Exception)((Object)mfue), true);
            }
        }
        if (this.cfg.getChild("base14-kerning", false) != null) {
            try {
                fontManager.setBase14KerningEnabled(this.cfg.getChild("base14-kerning").getValueAsBoolean());
            }
            catch (ConfigurationException e) {
                LogUtil.handleException(log, (Exception)((Object)e), true);
            }
        }
        if ((fontsCfg = this.cfg.getChild("fonts", false)) != null) {
            Configuration referencedFontsCfg;
            Configuration substitutionsCfg = fontsCfg.getChild("substitutions", false);
            if (substitutionsCfg != null) {
                FontSubstitutions substitutions = new FontSubstitutions();
                new FontSubstitutionsConfigurator(substitutionsCfg).configure(substitutions);
                fontManager.setFontSubstitutions(substitutions);
            }
            if ((referencedFontsCfg = fontsCfg.getChild("referenced-fonts", false)) != null) {
                FontTriplet.Matcher matcher = FontManagerConfigurator.createFontsMatcher(referencedFontsCfg, strict);
                fontManager.setReferencedFontsMatcher(matcher);
            }
        }
    }

    public static FontTriplet.Matcher createFontsMatcher(Configuration cfg, boolean strict) throws FOPException {
        ArrayList<FontFamilyRegExFontTripletMatcher> matcherList = new ArrayList<FontFamilyRegExFontTripletMatcher>();
        Configuration[] matches = cfg.getChildren("match");
        for (int i = 0; i < matches.length; ++i) {
            try {
                matcherList.add(new FontFamilyRegExFontTripletMatcher(matches[i].getAttribute("font-family")));
                continue;
            }
            catch (ConfigurationException ce) {
                LogUtil.handleException(log, (Exception)((Object)ce), strict);
            }
        }
        OrFontTripletMatcher orMatcher = new OrFontTripletMatcher(matcherList.toArray(new FontTriplet.Matcher[matcherList.size()]));
        return orMatcher;
    }

    public static FontTriplet.Matcher createFontsMatcher(List<String> fontFamilies, boolean strict) throws FOPException {
        ArrayList<FontFamilyRegExFontTripletMatcher> matcherList = new ArrayList<FontFamilyRegExFontTripletMatcher>();
        for (String fontFamily : fontFamilies) {
            matcherList.add(new FontFamilyRegExFontTripletMatcher(fontFamily));
        }
        OrFontTripletMatcher orMatcher = new OrFontTripletMatcher(matcherList.toArray(new FontTriplet.Matcher[matcherList.size()]));
        return orMatcher;
    }

    private static class FontFamilyRegExFontTripletMatcher
    implements FontTriplet.Matcher {
        private final Pattern regex;

        public FontFamilyRegExFontTripletMatcher(String regex) {
            this.regex = Pattern.compile(regex);
        }

        public boolean matches(FontTriplet triplet) {
            return this.regex.matcher(triplet.getName()).matches();
        }
    }

    private static class OrFontTripletMatcher
    implements FontTriplet.Matcher {
        private final FontTriplet.Matcher[] matchers;

        public OrFontTripletMatcher(FontTriplet.Matcher[] matchers) {
            this.matchers = matchers;
        }

        public boolean matches(FontTriplet triplet) {
            int c = this.matchers.length;
            for (int i = 0; i < c; ++i) {
                if (!this.matchers[i].matches(triplet)) continue;
                return true;
            }
            return false;
        }
    }
}

