/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf;

import java.awt.color.ICC_Profile;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.EnumMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.io.InternalResourceResolver;
import org.apache.fop.fo.extensions.xmp.XMPMetadata;
import org.apache.fop.pdf.PDFAMode;
import org.apache.fop.pdf.PDFArray;
import org.apache.fop.pdf.PDFConformanceException;
import org.apache.fop.pdf.PDFDictionary;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFEmbeddedFile;
import org.apache.fop.pdf.PDFEmbeddedFiles;
import org.apache.fop.pdf.PDFEncryptionManager;
import org.apache.fop.pdf.PDFEncryptionParams;
import org.apache.fop.pdf.PDFFileSpec;
import org.apache.fop.pdf.PDFICCBasedColorSpace;
import org.apache.fop.pdf.PDFICCStream;
import org.apache.fop.pdf.PDFInfo;
import org.apache.fop.pdf.PDFMetadata;
import org.apache.fop.pdf.PDFNames;
import org.apache.fop.pdf.PDFOutputIntent;
import org.apache.fop.pdf.PDFPageLabels;
import org.apache.fop.pdf.PDFReference;
import org.apache.fop.pdf.PDFText;
import org.apache.fop.pdf.PDFXMode;
import org.apache.fop.pdf.Version;
import org.apache.fop.pdf.VersionController;
import org.apache.fop.render.pdf.PDFEncryptionOption;
import org.apache.fop.render.pdf.PDFRendererOption;
import org.apache.fop.render.pdf.PDFRendererOptionsConfig;
import org.apache.fop.render.pdf.extensions.PDFEmbeddedFileExtensionAttachment;
import org.apache.xmlgraphics.io.Resource;
import org.apache.xmlgraphics.java2d.color.profile.ColorProfileUtil;
import org.apache.xmlgraphics.xmp.Metadata;
import org.apache.xmlgraphics.xmp.schemas.XMPBasicAdapter;
import org.apache.xmlgraphics.xmp.schemas.XMPBasicSchema;

class PDFRenderingUtil {
    private static Log log = LogFactory.getLog(PDFRenderingUtil.class);
    private FOUserAgent userAgent;
    private PDFDocument pdfDoc;
    private PDFRendererOptionsConfig rendererConfig;
    private PDFICCStream outputProfile;
    private PDFICCBasedColorSpace sRGBColorSpace;

    PDFRenderingUtil(FOUserAgent userAgent) {
        this.userAgent = userAgent;
        this.initialize();
    }

    private void initialize() {
        this.rendererConfig = PDFRendererOptionsConfig.DEFAULT.merge(PDFRenderingUtil.createFromUserAgent(this.userAgent));
        if (this.rendererConfig.getPDFAMode().isLevelA()) {
            this.userAgent.getRendererOptions().put("accessibility", Boolean.TRUE);
        }
    }

    private static PDFRendererOptionsConfig createFromUserAgent(FOUserAgent userAgent) {
        EnumMap<PDFRendererOption, Object> properties = new EnumMap<PDFRendererOption, Object>(PDFRendererOption.class);
        for (PDFRendererOption option : PDFRendererOption.values()) {
            Object value = userAgent.getRendererOption(option);
            properties.put(option, option.parse(value));
        }
        PDFEncryptionParams encryptionConfig = new EncryptionParamsBuilder().createParams(userAgent);
        return new PDFRendererOptionsConfig(properties, encryptionConfig);
    }

    void mergeRendererOptionsConfig(PDFRendererOptionsConfig config) {
        this.rendererConfig = this.rendererConfig.merge(config);
    }

    private void updateInfo() {
        PDFInfo info = this.pdfDoc.getInfo();
        info.setCreator(this.userAgent.getCreator());
        info.setCreationDate(this.userAgent.getCreationDate());
        info.setAuthor(this.userAgent.getAuthor());
        info.setTitle(this.userAgent.getTitle());
        info.setSubject(this.userAgent.getSubject());
        info.setKeywords(this.userAgent.getKeywords());
    }

    private void updatePDFProfiles() {
        this.pdfDoc.getProfile().setPDFAMode(this.rendererConfig.getPDFAMode());
        this.pdfDoc.getProfile().setPDFXMode(this.rendererConfig.getPDFXMode());
    }

    private void addsRGBColorSpace() throws IOException {
        if (this.rendererConfig.getDisableSRGBColorSpace().booleanValue()) {
            if (this.rendererConfig.getPDFAMode() != PDFAMode.DISABLED || this.rendererConfig.getPDFXMode() != PDFXMode.DISABLED || this.rendererConfig.getOutputProfileURI() != null) {
                throw new IllegalStateException("It is not possible to disable the sRGB color space if PDF/A or PDF/X functionality is enabled or an output profile is set!");
            }
        } else {
            if (this.sRGBColorSpace != null) {
                return;
            }
            this.sRGBColorSpace = PDFICCBasedColorSpace.setupsRGBAsDefaultRGBColorSpace(this.pdfDoc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDefaultOutputProfile() throws IOException {
        if (this.outputProfile != null) {
            return;
        }
        Resource in = null;
        URI outputProfileUri = this.rendererConfig.getOutputProfileURI();
        if (outputProfileUri != null) {
            ICC_Profile profile;
            this.outputProfile = this.pdfDoc.getFactory().makePDFICCStream();
            in = this.userAgent.getResourceResolver().getResource(this.rendererConfig.getOutputProfileURI());
            try {
                profile = ColorProfileUtil.getICC_Profile((InputStream)in);
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
            this.outputProfile.setColorSpace(profile, null);
        } else {
            this.outputProfile = this.sRGBColorSpace.getICCStream();
        }
    }

    private void addPDFA1OutputIntent() throws IOException {
        this.addDefaultOutputProfile();
        String desc = ColorProfileUtil.getICCProfileDescription((ICC_Profile)this.outputProfile.getICCProfile());
        PDFOutputIntent outputIntent = this.pdfDoc.getFactory().makeOutputIntent();
        outputIntent.setSubtype("GTS_PDFA1");
        outputIntent.setDestOutputProfile(this.outputProfile);
        outputIntent.setOutputConditionIdentifier(desc);
        outputIntent.setInfo(outputIntent.getOutputConditionIdentifier());
        this.pdfDoc.getRoot().addOutputIntent(outputIntent);
    }

    private void addPDFXOutputIntent() throws IOException {
        this.addDefaultOutputProfile();
        String desc = ColorProfileUtil.getICCProfileDescription((ICC_Profile)this.outputProfile.getICCProfile());
        int deviceClass = this.outputProfile.getICCProfile().getProfileClass();
        if (deviceClass != 2) {
            throw new PDFConformanceException((Object)((Object)this.pdfDoc.getProfile().getPDFXMode()) + " requires that" + " the DestOutputProfile be an Output Device Profile. " + desc + " does not match that requirement.");
        }
        PDFOutputIntent outputIntent = this.pdfDoc.getFactory().makeOutputIntent();
        outputIntent.setSubtype("GTS_PDFX");
        outputIntent.setDestOutputProfile(this.outputProfile);
        outputIntent.setOutputConditionIdentifier(desc);
        outputIntent.setInfo(outputIntent.getOutputConditionIdentifier());
        this.pdfDoc.getRoot().addOutputIntent(outputIntent);
    }

    public void renderXMPMetadata(XMPMetadata metadata) {
        Metadata docXMP = metadata.getMetadata();
        Metadata fopXMP = PDFMetadata.createXMPFromPDFDocument(this.pdfDoc);
        fopXMP.mergeInto(docXMP);
        XMPBasicAdapter xmpBasic = XMPBasicSchema.getAdapter((Metadata)docXMP);
        xmpBasic.setMetadataDate(new Date());
        PDFMetadata.updateInfoFromMetadata(docXMP, this.pdfDoc.getInfo());
        PDFMetadata pdfMetadata = this.pdfDoc.getFactory().makeMetadata(docXMP, metadata.isReadOnly());
        this.pdfDoc.getRoot().setMetadata(pdfMetadata);
    }

    public void generateDefaultXMPMetadata() {
        if (this.pdfDoc.getRoot().getMetadata() == null) {
            Metadata xmp = PDFMetadata.createXMPFromPDFDocument(this.pdfDoc);
            PDFMetadata pdfMetadata = this.pdfDoc.getFactory().makeMetadata(xmp, true);
            this.pdfDoc.getRoot().setMetadata(pdfMetadata);
        }
    }

    public PDFDocument setupPDFDocument(OutputStream out) throws IOException {
        PDFAMode pdfAMode;
        PDFXMode pdfXMode;
        if (this.pdfDoc != null) {
            throw new IllegalStateException("PDFDocument already set up");
        }
        String producer = this.userAgent.getProducer() != null ? this.userAgent.getProducer() : "";
        Version maxPDFVersion = this.rendererConfig.getPDFVersion();
        if (maxPDFVersion == null) {
            this.pdfDoc = new PDFDocument(producer);
        } else {
            VersionController controller = VersionController.getFixedVersionController(maxPDFVersion);
            this.pdfDoc = new PDFDocument(producer, controller);
        }
        this.updateInfo();
        this.updatePDFProfiles();
        this.pdfDoc.setFilterMap(this.rendererConfig.getFilterMap());
        this.pdfDoc.outputHeader(out);
        PDFEncryptionManager.setupPDFEncryption(this.rendererConfig.getEncryptionParameters(), this.pdfDoc);
        this.addsRGBColorSpace();
        if (this.rendererConfig.getOutputProfileURI() != null) {
            this.addDefaultOutputProfile();
        }
        if ((pdfXMode = this.rendererConfig.getPDFXMode()) != PDFXMode.DISABLED) {
            log.debug((Object)((Object)((Object)pdfXMode) + " is active."));
            log.warn((Object)("Note: " + (Object)((Object)pdfXMode) + " support is work-in-progress and not fully implemented, yet!"));
            this.addPDFXOutputIntent();
        }
        if ((pdfAMode = this.rendererConfig.getPDFAMode()).isEnabled()) {
            log.debug((Object)("PDF/A is active. Conformance Level: " + (Object)((Object)pdfAMode)));
            this.addPDFA1OutputIntent();
        }
        this.pdfDoc.enableAccessibility(this.userAgent.isAccessibilityEnabled());
        return this.pdfDoc;
    }

    public void generatePageLabel(int pageIndex, String pageNumber) {
        PDFPageLabels pageLabels = this.pdfDoc.getRoot().getPageLabels();
        if (pageLabels == null) {
            pageLabels = this.pdfDoc.getFactory().makePageLabels();
            this.pdfDoc.getRoot().setPageLabels(pageLabels);
        }
        pageLabels.addPageLabel(pageIndex, pageNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEmbeddedFile(PDFEmbeddedFileExtensionAttachment embeddedFile) throws IOException {
        PDFArray nameArray;
        URI srcURI;
        this.pdfDoc.getProfile().verifyEmbeddedFilesAllowed();
        PDFNames names = this.pdfDoc.getRoot().getNames();
        if (names == null) {
            names = this.pdfDoc.getFactory().makeNames();
            this.pdfDoc.getRoot().setNames(names);
        }
        PDFEmbeddedFile file = new PDFEmbeddedFile();
        this.pdfDoc.registerObject(file);
        try {
            srcURI = InternalResourceResolver.cleanURI(embeddedFile.getSrc());
        }
        catch (URISyntaxException use) {
            throw new RuntimeException(use);
        }
        Resource in = this.userAgent.getResourceResolver().getResource(srcURI);
        if (in == null) {
            throw new FileNotFoundException(embeddedFile.getSrc());
        }
        try {
            OutputStream out = file.getBufferOutputStream();
            IOUtils.copyLarge((InputStream)in, (OutputStream)out);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
        PDFDictionary dict = new PDFDictionary();
        dict.put("F", file);
        String filename = PDFText.toPDFString(embeddedFile.getFilename(), '_');
        PDFFileSpec fileSpec = new PDFFileSpec(filename);
        fileSpec.setEmbeddedFile(dict);
        if (embeddedFile.getDesc() != null) {
            fileSpec.setDescription(embeddedFile.getDesc());
        }
        this.pdfDoc.registerObject(fileSpec);
        PDFEmbeddedFiles embeddedFiles = names.getEmbeddedFiles();
        if (embeddedFiles == null) {
            embeddedFiles = new PDFEmbeddedFiles();
            this.pdfDoc.assignObjectNumber(embeddedFiles);
            this.pdfDoc.addTrailerObject(embeddedFiles);
            names.setEmbeddedFiles(embeddedFiles);
        }
        if ((nameArray = embeddedFiles.getNames()) == null) {
            nameArray = new PDFArray();
            embeddedFiles.setNames(nameArray);
        }
        String name = PDFText.toPDFString(filename);
        nameArray.add(name);
        nameArray.add(new PDFReference(fileSpec));
    }

    private static final class EncryptionParamsBuilder {
        private PDFEncryptionParams params;

        private EncryptionParamsBuilder() {
        }

        private PDFEncryptionParams createParams(FOUserAgent userAgent) {
            Object noPrintHQ;
            Object noAssembleDoc;
            Object noAccessContent;
            Object noFillInForms;
            Object noAnnotations;
            Object noEditContent;
            Object noCopyContent;
            Object noPrint;
            String ownerPassword;
            this.params = (PDFEncryptionParams)userAgent.getRendererOptions().get("encryption-params");
            String userPassword = (String)userAgent.getRendererOption(PDFEncryptionOption.USER_PASSWORD);
            if (userPassword != null) {
                this.getEncryptionParams().setUserPassword(userPassword);
            }
            if ((ownerPassword = (String)userAgent.getRendererOption(PDFEncryptionOption.OWNER_PASSWORD)) != null) {
                this.getEncryptionParams().setOwnerPassword(ownerPassword);
            }
            if ((noPrint = userAgent.getRendererOption(PDFEncryptionOption.NO_PRINT)) != null) {
                this.getEncryptionParams().setAllowPrint(!EncryptionParamsBuilder.booleanValueOf(noPrint));
            }
            if ((noCopyContent = userAgent.getRendererOption(PDFEncryptionOption.NO_COPY_CONTENT)) != null) {
                this.getEncryptionParams().setAllowCopyContent(!EncryptionParamsBuilder.booleanValueOf(noCopyContent));
            }
            if ((noEditContent = userAgent.getRendererOption(PDFEncryptionOption.NO_EDIT_CONTENT)) != null) {
                this.getEncryptionParams().setAllowEditContent(!EncryptionParamsBuilder.booleanValueOf(noEditContent));
            }
            if ((noAnnotations = userAgent.getRendererOption(PDFEncryptionOption.NO_ANNOTATIONS)) != null) {
                this.getEncryptionParams().setAllowEditAnnotations(!EncryptionParamsBuilder.booleanValueOf(noAnnotations));
            }
            if ((noFillInForms = userAgent.getRendererOption(PDFEncryptionOption.NO_FILLINFORMS)) != null) {
                this.getEncryptionParams().setAllowFillInForms(!EncryptionParamsBuilder.booleanValueOf(noFillInForms));
            }
            if ((noAccessContent = userAgent.getRendererOption(PDFEncryptionOption.NO_ACCESSCONTENT)) != null) {
                this.getEncryptionParams().setAllowAccessContent(!EncryptionParamsBuilder.booleanValueOf(noAccessContent));
            }
            if ((noAssembleDoc = userAgent.getRendererOption(PDFEncryptionOption.NO_ASSEMBLEDOC)) != null) {
                this.getEncryptionParams().setAllowAssembleDocument(!EncryptionParamsBuilder.booleanValueOf(noAssembleDoc));
            }
            if ((noPrintHQ = userAgent.getRendererOption(PDFEncryptionOption.NO_PRINTHQ)) != null) {
                this.getEncryptionParams().setAllowPrintHq(!EncryptionParamsBuilder.booleanValueOf(noPrintHQ));
            }
            return this.params;
        }

        private PDFEncryptionParams getEncryptionParams() {
            if (this.params == null) {
                this.params = new PDFEncryptionParams();
            }
            return this.params;
        }

        private static boolean booleanValueOf(Object obj) {
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            if (obj instanceof String) {
                return Boolean.valueOf((String)obj);
            }
            throw new IllegalArgumentException("Boolean or \"true\" or \"false\" expected.");
        }
    }
}

