/*
 * Decompiled with CFR 0.152.
 */
package at.asitplus.regkassen.common;

public enum RKSuiteIdentifier {
    R1("1", "ES256", "SHA-256", "SHA256withECDSA", "ECDSA", 8);

    public static final String[] SUPPORTED_PREFIXES;
    protected final String suiteID;
    protected final String jwsSignatureAlgorithm;
    protected final String javaSignatureAlgorithm;
    protected final String javaPublicKeySpec;
    protected final String hashAlgorithmForPreviousSignatureValue;
    protected final int numberOfBytesExtractedFromPrevSigHash;

    private RKSuiteIdentifier(String suiteID, String jwsSignatureAlgorithm, String hashAlgorithmForPreviousSignatureValue, String javaSignatureAlgorithm, String javaPublicKeySpec, int numberOfBytesExtractedFromPrevSigHash) {
        this.suiteID = suiteID;
        this.jwsSignatureAlgorithm = jwsSignatureAlgorithm;
        this.hashAlgorithmForPreviousSignatureValue = hashAlgorithmForPreviousSignatureValue;
        this.numberOfBytesExtractedFromPrevSigHash = numberOfBytesExtractedFromPrevSigHash;
        this.javaSignatureAlgorithm = javaSignatureAlgorithm;
        this.javaPublicKeySpec = javaPublicKeySpec;
    }

    public String getJavaSignatureAlgorithm() {
        return this.javaSignatureAlgorithm;
    }

    public String getJavaPublicKeySpec() {
        return this.javaPublicKeySpec;
    }

    public String getSuiteID() {
        return "R" + this.suiteID;
    }

    public String getJwsSignatureAlgorithm() {
        return this.jwsSignatureAlgorithm;
    }

    public String getHashAlgorithmForPreviousSignatureValue() {
        return this.hashAlgorithmForPreviousSignatureValue;
    }

    public int getNumberOfBytesExtractedFromPrevSigHash() {
        return this.numberOfBytesExtractedFromPrevSigHash;
    }

    public static boolean isSupported(String rk) {
        return RKSuiteIdentifier.fromRKString(rk) != null;
    }

    public static RKSuiteIdentifier fromRKString(String rk) {
        if (rk == null || !RKSuiteIdentifier.prefixSupported(rk)) {
            return null;
        }
        try {
            String suiteID = rk.split("-")[0];
            return RKSuiteIdentifier.valueOf(suiteID);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static boolean prefixSupported(String mc) {
        if (mc == null) {
            return false;
        }
        for (String p : SUPPORTED_PREFIXES) {
            if (!mc.startsWith(p)) continue;
            return true;
        }
        return false;
    }

    static {
        SUPPORTED_PREFIXES = new String[]{"R1-AT"};
    }
}

