/*
 * Decompiled with CFR 0.152.
 */
package at.asitplus.regkassen.common.util;

import at.asitplus.regkassen.common.MachineCodeValue;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.commons.codec.binary.Base32;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class CashBoxUtils {
    public static String convertDateToISO8601(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        return dateFormat.format(date);
    }

    public static Date convertISO8601toDate(String dateString) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        Date date = dateFormat.parse(dateString);
        return date;
    }

    public static void writeReceiptsToFiles(List<byte[]> printedReceipts, String prefix, File baseDir) {
        try {
            int index = 1;
            for (byte[] printedReceipt : printedReceipts) {
                ByteArrayInputStream bIn = new ByteArrayInputStream(printedReceipt);
                File receiptFile = new File(baseDir, prefix + "Receipt " + index + ".pdf");
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(receiptFile));
                IOUtils.copy((InputStream)bIn, (OutputStream)bufferedOutputStream);
                bufferedOutputStream.close();
                ++index;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String base64Encode(byte[] data, boolean isUrlSafe) {
        Base64 encoder = new Base64(isUrlSafe);
        return new String(encoder.encode(data)).replace("\r\n", "");
    }

    public static byte[] base64Decode(String base64Data, boolean isUrlSafe) {
        Base64 decoder = new Base64(isUrlSafe);
        return decoder.decode(base64Data);
    }

    public static String base32Encode(byte[] data) {
        Base32 encoder = new Base32();
        return new String(encoder.encode(data)).replace("\r\n", "");
    }

    public static byte[] base32Decode(String base32Data) {
        Base32 decoder = new Base32();
        return decoder.decode(base32Data);
    }

    public static String getValueFromMachineCode(String machineCodeRepresentation, MachineCodeValue machineCodeValue) {
        return machineCodeRepresentation.split("_")[machineCodeValue.getIndex() + 1];
    }

    public static String getQRCodeRepresentationFromJWSCompactRepresentation(String jwsCompactRepresentationOfReceipt) {
        String jwsPayloadEncoded = jwsCompactRepresentationOfReceipt.split("\\.")[1];
        String jwsSignatureEncoded = jwsCompactRepresentationOfReceipt.split("\\.")[2];
        String payload = new String(CashBoxUtils.base64Decode(jwsPayloadEncoded, true), Charset.forName("UTF-8"));
        String signature = CashBoxUtils.base64Encode(CashBoxUtils.base64Decode(jwsSignatureEncoded, true), false);
        return payload + "_" + signature;
    }

    public static String getOCRCodeRepresentationFromJWSCompactRepresentation(String jwsCompactRepresentationOfReceipt) {
        String qrCodeRepresentation = CashBoxUtils.getQRCodeRepresentationFromJWSCompactRepresentation(jwsCompactRepresentationOfReceipt);
        String el1_rkSuite = CashBoxUtils.getValueFromMachineCode(qrCodeRepresentation, MachineCodeValue.RK_SUITE);
        String el2_cashboxID = CashBoxUtils.getValueFromMachineCode(qrCodeRepresentation, MachineCodeValue.CASHBOX_ID);
        String el3_receiptIdentifier = CashBoxUtils.getValueFromMachineCode(qrCodeRepresentation, MachineCodeValue.RECEIPT_IDENTIFIER);
        String el4_timeAndDate = CashBoxUtils.getValueFromMachineCode(qrCodeRepresentation, MachineCodeValue.RECEIPT_DATE_AND_TIME);
        String el5_taxSet_NORMAL = CashBoxUtils.getValueFromMachineCode(qrCodeRepresentation, MachineCodeValue.SUM_TAX_SET_NORMAL);
        String el6_taxSet_ERMAESSIGT1 = CashBoxUtils.getValueFromMachineCode(qrCodeRepresentation, MachineCodeValue.SUM_TAX_SET_ERMAESSIGT1);
        String el7_taxSet_ERMAESSIGT2 = CashBoxUtils.getValueFromMachineCode(qrCodeRepresentation, MachineCodeValue.SUM_TAX_SET_ERMAESSIGT2);
        String el8_taxSet_NULL = CashBoxUtils.getValueFromMachineCode(qrCodeRepresentation, MachineCodeValue.SUM_TAX_SET_NULL);
        String el9_taxSet_BESONDERS = CashBoxUtils.getValueFromMachineCode(qrCodeRepresentation, MachineCodeValue.SUM_TAX_SET_BESONDERS);
        String el10_encryptedTurnOverValue = CashBoxUtils.getValueFromMachineCode(qrCodeRepresentation, MachineCodeValue.ENCRYPTED_TURN_OVER_VALUE);
        String el11_certificateSerialNumberOrCompanyAndKeyID = CashBoxUtils.getValueFromMachineCode(qrCodeRepresentation, MachineCodeValue.CERTIFICATE_SERIAL_NUMBER_OR_COMPANYID_AND_KEYID);
        String el12_chainValue = CashBoxUtils.getValueFromMachineCode(qrCodeRepresentation, MachineCodeValue.CHAINING_VALUE_PREVIOUS_RECEIPT);
        String el13_signatureValue = CashBoxUtils.getValueFromMachineCode(qrCodeRepresentation, MachineCodeValue.SIGNATURE_VALUE);
        el10_encryptedTurnOverValue = CashBoxUtils.base32Encode(CashBoxUtils.base64Decode(el10_encryptedTurnOverValue, false));
        el12_chainValue = CashBoxUtils.base32Encode(CashBoxUtils.base64Decode(el12_chainValue, false));
        el13_signatureValue = CashBoxUtils.base32Encode(CashBoxUtils.base64Decode(el13_signatureValue, false));
        String ocrCodeRepresentation = "_" + el1_rkSuite + "_" + el2_cashboxID + "_" + el3_receiptIdentifier + "_" + el4_timeAndDate + "_" + el5_taxSet_NORMAL + "_" + el6_taxSet_ERMAESSIGT1 + "_" + el7_taxSet_ERMAESSIGT2 + "_" + el8_taxSet_NULL + "_" + el9_taxSet_BESONDERS + "_" + el10_encryptedTurnOverValue + "_" + el11_certificateSerialNumberOrCompanyAndKeyID + "_" + el12_chainValue + "_" + el13_signatureValue;
        return ocrCodeRepresentation;
    }

    public static String getPayloadFromQRCodeRepresentation(String qrCodeRepresentation) {
        String[] elements = qrCodeRepresentation.split("_");
        String payload = "";
        for (int i = 0; i < 13; ++i) {
            payload = payload + elements[i];
            if (i >= 12) continue;
            payload = payload + "_";
        }
        return payload;
    }

    public static String getJWSCompactRepresentationFromQRMachineCodeRepresentation(String qrMachineCodeRepresentation) {
        String payload = CashBoxUtils.getPayloadFromQRCodeRepresentation(qrMachineCodeRepresentation);
        String jwsPayload = CashBoxUtils.base64Encode(payload.getBytes(Charset.forName("UTF-8")), true);
        String jwsHeader = "eyJhbGciOiJFUzI1NiJ9";
        String jwsSignature = CashBoxUtils.base64Encode(CashBoxUtils.base64Decode(CashBoxUtils.getValueFromMachineCode(qrMachineCodeRepresentation, MachineCodeValue.SIGNATURE_VALUE), false), true);
        return jwsHeader + "." + jwsPayload + "." + jwsSignature;
    }

    public static double getDoubleFromTaxSet(String taxSetValue) throws Exception {
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.GERMAN);
        DecimalFormat decimalFormat = (DecimalFormat)nf;
        try {
            return decimalFormat.parse(taxSetValue).doubleValue();
        }
        catch (ParseException parseException) {
            nf = NumberFormat.getNumberInstance(Locale.US);
            decimalFormat = (DecimalFormat)nf;
            try {
                return decimalFormat.parse(taxSetValue).doubleValue();
            }
            catch (ParseException e) {
                ParseException parseException2 = e;
                throw parseException2;
            }
        }
    }

    public static boolean checkReceiptForDamagedSigatureCreationDevice(String jwsCompactRepresentation) {
        String encodedSignatureValueBase64 = jwsCompactRepresentation.split("\\.")[2];
        String decodedSignatureValue = new String(CashBoxUtils.base64Decode(encodedSignatureValueBase64, true));
        return "Sicherheitseinrichtung ausgefallen".equals(decodedSignatureValue);
    }

    public static double getTaxSetTurnOverSumFromQRMachineCodeRepresentation(String qrMachineCodeRepresentation, boolean calcAbsValue) throws Exception {
        double currentTaxSetNormal = CashBoxUtils.getDoubleFromTaxSet(CashBoxUtils.getValueFromMachineCode(qrMachineCodeRepresentation, MachineCodeValue.SUM_TAX_SET_NORMAL));
        double currentTaxSetErmaessigt1 = CashBoxUtils.getDoubleFromTaxSet(CashBoxUtils.getValueFromMachineCode(qrMachineCodeRepresentation, MachineCodeValue.SUM_TAX_SET_ERMAESSIGT1));
        double currentTaxSetErmaessigt2 = CashBoxUtils.getDoubleFromTaxSet(CashBoxUtils.getValueFromMachineCode(qrMachineCodeRepresentation, MachineCodeValue.SUM_TAX_SET_ERMAESSIGT2));
        double currentTaxSetNull = CashBoxUtils.getDoubleFromTaxSet(CashBoxUtils.getValueFromMachineCode(qrMachineCodeRepresentation, MachineCodeValue.SUM_TAX_SET_NULL));
        double currentTaxSetBesonders = CashBoxUtils.getDoubleFromTaxSet(CashBoxUtils.getValueFromMachineCode(qrMachineCodeRepresentation, MachineCodeValue.SUM_TAX_SET_BESONDERS));
        if (calcAbsValue) {
            return Math.abs(currentTaxSetNormal) + Math.abs(currentTaxSetErmaessigt1) + Math.abs(currentTaxSetErmaessigt2) + Math.abs(currentTaxSetNull) + Math.abs(currentTaxSetBesonders);
        }
        return currentTaxSetNormal + currentTaxSetErmaessigt1 + currentTaxSetErmaessigt2 + currentTaxSetNull + currentTaxSetBesonders;
    }

    public static X509Certificate parseCertificate(String base64EncodedCertificate) throws CertificateException {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream bIn = new ByteArrayInputStream(CashBoxUtils.base64Decode(base64EncodedCertificate, false));
        return (X509Certificate)certificateFactory.generateCertificate(bIn);
    }

    public static List<X509Certificate> parseCertificates(String[] base64EncodedCertificates) throws CertificateException {
        ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
        for (String base64EncodedCertificate : base64EncodedCertificates) {
            certificates.add(CashBoxUtils.parseCertificate(base64EncodedCertificate));
        }
        return certificates;
    }

    public static boolean isJWSCompactRepTrainingReceipt(String jwsCompactRepresentation) {
        return CashBoxUtils.isQRCodeRepTrainingReceipt(CashBoxUtils.getQRCodeRepresentationFromJWSCompactRepresentation(jwsCompactRepresentation));
    }

    public static boolean isQRCodeRepTrainingReceipt(String qrMachineCodeRepresentation) {
        String encryptedTurnOverCounter = CashBoxUtils.getValueFromMachineCode(qrMachineCodeRepresentation, MachineCodeValue.ENCRYPTED_TURN_OVER_VALUE);
        String decodedTurnOverCounter = new String(CashBoxUtils.base64Decode(encryptedTurnOverCounter, false));
        return "TRA".equals(decodedTurnOverCounter);
    }

    public static boolean isJWSCompactRepStornoReceipt(String jwsCompactRepresentation) {
        return CashBoxUtils.isQRCodeRepStornoReceipt(CashBoxUtils.getQRCodeRepresentationFromJWSCompactRepresentation(jwsCompactRepresentation));
    }

    public static boolean isQRCodeRepStornoReceipt(String qrMachineCodeRepresentation) {
        String encryptedTurnOverCounter = CashBoxUtils.getValueFromMachineCode(qrMachineCodeRepresentation, MachineCodeValue.ENCRYPTED_TURN_OVER_VALUE);
        String decodedTurnOverCounter = new String(CashBoxUtils.base64Decode(encryptedTurnOverCounter, false));
        return "STO".equals(decodedTurnOverCounter);
    }

    public static byte[] get2ComplementRepForLong(long value, int numberOfBytesFor2ComplementRepresentation) {
        if (numberOfBytesFor2ComplementRepresentation < 1 || numberOfBytesFor2ComplementRepresentation > 8) {
            throw new IllegalArgumentException();
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(8);
        byteBuffer.putLong(value);
        byte[] longRep = byteBuffer.array();
        if (numberOfBytesFor2ComplementRepresentation == 8) {
            return longRep;
        }
        byte[] byteRep = new byte[numberOfBytesFor2ComplementRepresentation];
        System.arraycopy(longRep, 8 - numberOfBytesFor2ComplementRepresentation, byteRep, 0, numberOfBytesFor2ComplementRepresentation);
        return byteRep;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

