/*
 * Decompiled with CFR 0.152.
 */
package at.asitplus.regkassen.common.util;

import at.asitplus.regkassen.common.RKSuiteIdentifier;
import at.asitplus.regkassen.common.util.CashBoxUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequenceGenerator;
import org.bouncycastle.asn1.x9.X9IntegerConverter;
import org.bouncycastle.crypto.CryptoException;

public class CryptoUtil {
    public static byte[] convertDEREncodedSignatureToJWSConcatenated(byte[] derEncodedSignatureValue) throws IOException {
        ASN1InputStream asn1InputStream = new ASN1InputStream(derEncodedSignatureValue);
        ASN1Primitive asn1Primitive = asn1InputStream.readObject();
        asn1InputStream.close();
        ASN1Sequence asn1Sequence = ASN1Sequence.getInstance((Object)asn1Primitive);
        ASN1Integer rASN1 = (ASN1Integer)asn1Sequence.getObjectAt(0);
        ASN1Integer sASN1 = (ASN1Integer)asn1Sequence.getObjectAt(1);
        X9IntegerConverter x9IntegerConverter = new X9IntegerConverter();
        byte[] r = x9IntegerConverter.integerToBytes(rASN1.getValue(), 32);
        byte[] s = x9IntegerConverter.integerToBytes(sASN1.getValue(), 32);
        byte[] concatenatedSignatureValue = new byte[64];
        System.arraycopy(r, 0, concatenatedSignatureValue, 0, 32);
        System.arraycopy(s, 0, concatenatedSignatureValue, 32, 32);
        return concatenatedSignatureValue;
    }

    public static byte[] convertJWSConcatenatedToDEREncodedSignature(byte[] concatenatedSignatureValue) throws IOException {
        byte[] r = new byte[33];
        byte[] s = new byte[33];
        System.arraycopy(concatenatedSignatureValue, 0, r, 1, 32);
        System.arraycopy(concatenatedSignatureValue, 32, s, 1, 32);
        BigInteger rBigInteger = new BigInteger(r);
        BigInteger sBigInteger = new BigInteger(s);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DERSequenceGenerator seqGen = new DERSequenceGenerator((OutputStream)bos);
        seqGen.addObject((ASN1Encodable)new ASN1Integer(rBigInteger.toByteArray()));
        seqGen.addObject((ASN1Encodable)new ASN1Integer(sBigInteger.toByteArray()));
        seqGen.close();
        bos.close();
        byte[] derEncodedSignatureValue = bos.toByteArray();
        return derEncodedSignatureValue;
    }

    public static SecretKey createAESKey() {
        try {
            KeyGenerator kgen = KeyGenerator.getInstance("AES");
            int keySize = 256;
            kgen.init(256);
            return kgen.generateKey();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean isUnlimitedStrengthPolicyAvailable() {
        try {
            return Cipher.getMaxAllowedKeyLength("AES") >= 256;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static SecretKey convertBase64KeyToSecretKey(String base64AESKey) {
        byte[] rawAesKey = CashBoxUtils.base64Decode(base64AESKey, false);
        SecretKeySpec aesKey = new SecretKeySpec(rawAesKey, "AES");
        return aesKey;
    }

    public static String encryptECB(byte[] concatenatedHashValue, Long turnoverCounter, SecretKey symmetricKey, int turnOverCounterLengthInBytes) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        ByteBuffer byteBufferIV = ByteBuffer.allocate(16);
        byteBufferIV.put(concatenatedHashValue);
        byte[] IV = byteBufferIV.array();
        ByteBuffer byteBufferData = ByteBuffer.allocate(16);
        byteBufferData.putLong(turnoverCounter);
        byte[] data = byteBufferData.array();
        byte[] turnOverCounterByteRep = CashBoxUtils.get2ComplementRepForLong(turnoverCounter, turnOverCounterLengthInBytes);
        System.arraycopy(turnOverCounterByteRep, 0, data, 0, turnOverCounterByteRep.length);
        Cipher cipher = Cipher.getInstance("AES/ECB/NoPadding", "BC");
        cipher.init(1, symmetricKey);
        byte[] intermediateResult = cipher.doFinal(IV);
        byte[] result = new byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            result[i] = (byte)(data[i] ^ intermediateResult[i]);
        }
        byte[] encryptedTurnOverValue = new byte[turnOverCounterLengthInBytes];
        System.arraycopy(result, 0, encryptedTurnOverValue, 0, turnOverCounterLengthInBytes);
        return CashBoxUtils.base64Encode(encryptedTurnOverValue, false);
    }

    public static long decryptECB(byte[] concatenatedHashValue, String base64EncryptedTurnOverValue, SecretKey symmetricKey) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        ByteBuffer byteBufferIV = ByteBuffer.allocate(16);
        byteBufferIV.put(concatenatedHashValue);
        byte[] IV = byteBufferIV.array();
        byte[] encryptedTurnOverValue = CashBoxUtils.base64Decode(base64EncryptedTurnOverValue, false);
        Cipher cipher = Cipher.getInstance("AES/ECB/NoPadding", "BC");
        cipher.init(1, symmetricKey);
        byte[] intermediateResult = cipher.doFinal(IV);
        byte[] result = new byte[encryptedTurnOverValue.length];
        for (int i = 0; i < encryptedTurnOverValue.length; ++i) {
            result[i] = (byte)(encryptedTurnOverValue[i] ^ intermediateResult[i]);
        }
        return CryptoUtil.getLong(result);
    }

    public static String encryptCFB(byte[] concatenatedHashValue, Long turnoverCounter, SecretKey symmetricKey, int turnOverCounterLengthInBytes) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        ByteBuffer byteBufferIV = ByteBuffer.allocate(16);
        byteBufferIV.put(concatenatedHashValue);
        byte[] IV = byteBufferIV.array();
        ByteBuffer byteBufferData = ByteBuffer.allocate(16);
        byteBufferData.putLong(turnoverCounter);
        byte[] data = byteBufferData.array();
        byte[] turnOverCounterByteRep = CashBoxUtils.get2ComplementRepForLong(turnoverCounter, turnOverCounterLengthInBytes);
        System.arraycopy(turnOverCounterByteRep, 0, data, 0, turnOverCounterByteRep.length);
        IvParameterSpec ivSpec = new IvParameterSpec(IV);
        Cipher cipher = Cipher.getInstance("AES/CFB/NoPadding", "BC");
        cipher.init(1, (Key)symmetricKey, ivSpec);
        byte[] encryptedTurnOverValueComplete = cipher.doFinal(data);
        byte[] encryptedTurnOverValue = new byte[turnOverCounterLengthInBytes];
        System.arraycopy(encryptedTurnOverValueComplete, 0, encryptedTurnOverValue, 0, turnOverCounterLengthInBytes);
        String base64EncryptedTurnOverValue = CashBoxUtils.base64Encode(encryptedTurnOverValue, false);
        return base64EncryptedTurnOverValue;
    }

    public static long decryptCFB(byte[] concatenatedHashValue, String base64EncryptedTurnOverValue, SecretKey symmetricKey) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        ByteBuffer byteBufferIV = ByteBuffer.allocate(16);
        byteBufferIV.put(concatenatedHashValue);
        byte[] IV = byteBufferIV.array();
        byte[] encryptedTurnOverValue = CashBoxUtils.base64Decode(base64EncryptedTurnOverValue, false);
        IvParameterSpec ivSpec = new IvParameterSpec(IV);
        Cipher cipher = Cipher.getInstance("AES/CFB/NoPadding", "BC");
        cipher.init(2, (Key)symmetricKey, ivSpec);
        byte[] testPlainTurnOverValueComplete = cipher.doFinal(encryptedTurnOverValue);
        return CryptoUtil.getLong(testPlainTurnOverValueComplete);
    }

    static long getLong(byte[] bytes) {
        return new BigInteger(bytes).longValue();
    }

    public static String encryptCTR(byte[] concatenatedHashValue, Long turnoverCounter, SecretKey symmetricKey, int turnOverCounterLengthInBytes) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        ByteBuffer byteBufferIV = ByteBuffer.allocate(16);
        byteBufferIV.put(concatenatedHashValue);
        byte[] IV = byteBufferIV.array();
        ByteBuffer byteBufferData = ByteBuffer.allocate(16);
        byteBufferData.putLong(turnoverCounter);
        byte[] data = byteBufferData.array();
        byte[] turnOverCounterByteRep = CashBoxUtils.get2ComplementRepForLong(turnoverCounter, turnOverCounterLengthInBytes);
        System.arraycopy(turnOverCounterByteRep, 0, data, 0, turnOverCounterByteRep.length);
        IvParameterSpec ivSpec = new IvParameterSpec(IV);
        Cipher cipher = Cipher.getInstance("AES/CTR/NoPadding", "BC");
        cipher.init(1, (Key)symmetricKey, ivSpec);
        byte[] encryptedTurnOverValueComplete = cipher.doFinal(data);
        byte[] encryptedTurnOverValue = new byte[turnOverCounterLengthInBytes];
        System.arraycopy(encryptedTurnOverValueComplete, 0, encryptedTurnOverValue, 0, turnOverCounterLengthInBytes);
        return CashBoxUtils.base64Encode(encryptedTurnOverValue, false);
    }

    public static long decryptCTR(byte[] concatenatedHashValue, String base64EncryptedTurnOverValue, SecretKey symmetricKey) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        ByteBuffer byteBufferIV = ByteBuffer.allocate(16);
        byteBufferIV.put(concatenatedHashValue);
        byte[] IV = byteBufferIV.array();
        byte[] encryptedTurnOverValue = CashBoxUtils.base64Decode(base64EncryptedTurnOverValue, false);
        IvParameterSpec ivSpec = new IvParameterSpec(IV);
        Cipher cipher = Cipher.getInstance("AES/CTR/NoPadding", "BC");
        cipher.init(2, (Key)symmetricKey, ivSpec);
        byte[] testPlainTurnOverValueComplete = cipher.doFinal(encryptedTurnOverValue);
        return CryptoUtil.getLong(testPlainTurnOverValueComplete);
    }

    public static long decryptTurnOverCounter(String encryptedTurnOverCounterBase64, String hashAlgorithm, String cashBoxIDUTF8String, String receiptIdentifierUTF8String, String aesKeyBase64) throws Exception {
        byte[] rawAesKey = CashBoxUtils.base64Decode(aesKeyBase64, false);
        SecretKeySpec aesKey = new SecretKeySpec(rawAesKey, "AES");
        return CryptoUtil.decryptTurnOverCounter(encryptedTurnOverCounterBase64, hashAlgorithm, cashBoxIDUTF8String, receiptIdentifierUTF8String, aesKey);
    }

    public static long decryptTurnOverCounter(String encryptedTurnOverCounterBase64, String hashAlgorithm, String cashBoxIDUTF8String, String receiptIdentifierUTF8String, SecretKey aesKey) throws Exception {
        String IVUTF8StringRepresentation = cashBoxIDUTF8String + receiptIdentifierUTF8String;
        MessageDigest messageDigest = MessageDigest.getInstance(hashAlgorithm);
        byte[] hashValue = messageDigest.digest(IVUTF8StringRepresentation.getBytes());
        byte[] concatenatedHashValue = new byte[16];
        System.arraycopy(hashValue, 0, concatenatedHashValue, 0, 16);
        ByteBuffer byteBufferIV = ByteBuffer.allocate(16);
        byteBufferIV.put(concatenatedHashValue);
        byte[] IV = byteBufferIV.array();
        IvParameterSpec ivSpec = new IvParameterSpec(IV);
        ByteBuffer encryptedTurnOverValueComplete = ByteBuffer.allocate(16);
        byte[] encryptedTurnOverValue = CashBoxUtils.base64Decode(encryptedTurnOverCounterBase64, false);
        int lengthOfEncryptedTurnOverValue = encryptedTurnOverValue.length;
        encryptedTurnOverValueComplete.put(encryptedTurnOverValue);
        Cipher cipher = Cipher.getInstance("AES/CTR/NoPadding", "BC");
        cipher.init(2, (Key)aesKey, ivSpec);
        byte[] plainTurnOverValueComplete = cipher.doFinal(encryptedTurnOverValue);
        byte[] plainTurnOverValueTruncated = new byte[lengthOfEncryptedTurnOverValue];
        System.arraycopy(plainTurnOverValueComplete, 0, plainTurnOverValueTruncated, 0, lengthOfEncryptedTurnOverValue);
        return new BigInteger(plainTurnOverValueTruncated).longValue();
    }

    public static String computeChainingValue(String input, RKSuiteIdentifier rkSuite) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(rkSuite.getHashAlgorithmForPreviousSignatureValue());
        md.update(input.getBytes());
        byte[] digest = md.digest();
        int bytesToExtract = rkSuite.getNumberOfBytesExtractedFromPrevSigHash();
        byte[] conDigest = new byte[bytesToExtract];
        System.arraycopy(digest, 0, conDigest, 0, bytesToExtract);
        return CashBoxUtils.base64Encode(conDigest, false);
    }

    public static String hashData(String data) throws CryptoException {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256", "BC");
            md.update(data.getBytes("UTF-8"));
            return new BigInteger(md.digest()).toString(16);
        }
        catch (Exception e) {
            throw new CryptoException(e.getMessage(), (Throwable)e);
        }
    }
}

