/*
 * Decompiled with CFR 0.152.
 */
package at.asitplus.regkassen.verification.modules;

import at.asitplus.regkassen.verification.common.BaseVerificationModule;
import at.asitplus.regkassen.verification.common.annotations.VerificationModule;
import at.asitplus.regkassen.verification.common.data.AuthLevel;
import at.asitplus.regkassen.verification.common.data.VerificationID;
import at.asitplus.regkassen.verification.common.data.VerificationInputOutput;
import at.asitplus.regkassen.verification.common.data.VerificationResult;
import at.asitplus.regkassen.verification.modules.entrypoint.AbstractEntryPoint;
import at.asitplus.regkassen.verification.modules.entrypoint.AppEntryPoint;
import at.asitplus.regkassen.verification.modules.entrypoint.CashBoxEntryPoint;
import at.asitplus.regkassen.verification.modules.entrypoint.NonTransformingEntryPoint;
import at.asitplus.regkassen.verification.resourceinjection.ResourceInjector;
import java.util.Locale;

@VerificationModule(inputProperties={VerificationInputOutput.RECEIPT, VerificationInputOutput.AUTH_LEVEL, VerificationInputOutput.AUTH_CODE, VerificationInputOutput.SID, VerificationInputOutput.LANGUAGE}, version=1, verificationID=VerificationID.TRANSPARENT_TOPLEVEL)
public class FullyTransparentToplevelModule
extends BaseVerificationModule {
    protected VerificationResult doVerify(VerificationResult verificationResult) {
        AuthLevel authLevel = AuthLevel.valueOf((String)verificationResult.getInputData(VerificationInputOutput.AUTH_LEVEL).getValue());
        AbstractEntryPoint abstractEntryPoint = null;
        switch (authLevel) {
            case APP: {
                abstractEntryPoint = new AppEntryPoint();
                break;
            }
            case CASHBOX: {
                abstractEntryPoint = new CashBoxEntryPoint();
                break;
            }
            case FULL: {
                abstractEntryPoint = new NonTransformingEntryPoint();
            }
        }
        Object object = verificationResult.getInputData(VerificationInputOutput.LANGUAGE).getValue();
        if (((String)object).contains("_")) {
            object = ((String)object).split("_")[0];
            object = new Locale((String)object);
        } else {
            object = new Locale((String)object);
        }
        verificationResult = abstractEntryPoint.verifySingle(abstractEntryPoint.prepareInput(verificationResult));
        ResourceInjector.transform(verificationResult, (Locale)object);
        if (authLevel == AuthLevel.APP) {
            verificationResult.setVerificationTextualDescription(null);
        }
        return verificationResult;
    }
}

