/*
 * Decompiled with CFR 0.152.
 */
package at.asitplus.regkassen.verification.modules;

import at.asitplus.regkassen.common.MachineCodeValue;
import at.asitplus.regkassen.common.util.CashBoxUtils;
import at.asitplus.regkassen.verification.common.BaseVerificationModule;
import at.asitplus.regkassen.verification.common.annotations.VerificationModule;
import at.asitplus.regkassen.verification.common.data.VerificationID;
import at.asitplus.regkassen.verification.common.data.VerificationInputOutput;
import at.asitplus.regkassen.verification.common.data.VerificationProperty;
import at.asitplus.regkassen.verification.common.data.VerificationResult;
import at.asitplus.regkassen.verification.common.data.VerificationState;
import at.asitplus.regkassen.verification.modules.BasicContraintsVerificationModule;
import at.asitplus.regkassen.verification.modules.basic.SemanticTimeofReceiptVerificationModule;
import at.asitplus.regkassen.verification.modules.format.FormatVerificationModule;
import java.util.HashSet;

@VerificationModule(inputProperties={VerificationInputOutput.RECEIPT, VerificationInputOutput.DATE_LATEST}, version=1, verificationID=VerificationID.CONSTRAINTS_PRE_DB)
public class PreDbConstraintsCheckModule
extends BaseVerificationModule {
    private static final String DATE_EARLIEST = "2015-09-01T00:00:00";

    private VerificationResult verifyBasic(VerificationResult verificationResult) {
        BasicContraintsVerificationModule basicContraintsVerificationModule = new BasicContraintsVerificationModule();
        return basicContraintsVerificationModule.verifySingle(basicContraintsVerificationModule.prepareInput(verificationResult));
    }

    protected VerificationResult doVerify(VerificationResult verificationResult) {
        verificationResult.setVerificationState(VerificationState.FAIL);
        String string = verificationResult.getInputData(VerificationInputOutput.RECEIPT).getValue();
        Object object = this.verifyBasic(verificationResult);
        verificationResult.addVerificationResult(object);
        if (object.getVerificationState() == VerificationState.FAIL) {
            return verificationResult;
        }
        object = FormatVerificationModule.verifyRKSuite(string);
        verificationResult.addVerificationResult(object);
        if (object.getVerificationState() == VerificationState.FAIL) {
            return verificationResult;
        }
        object = FormatVerificationModule.verifySerialNumber(string, object);
        verificationResult.addVerificationResult(object);
        if (object.getVerificationState() == VerificationState.FAIL) {
            return verificationResult;
        }
        object = FormatVerificationModule.verifyTimeAndDateFormat(string);
        verificationResult.addVerificationResult(object);
        if (object.getVerificationState() == VerificationState.FAIL) {
            return verificationResult;
        }
        object = CashBoxUtils.getValueFromMachineCode((String)string, (MachineCodeValue)MachineCodeValue.RECEIPT_DATE_AND_TIME);
        VerificationProperty verificationProperty = new VerificationProperty(VerificationInputOutput.DATE_EARLIEST, DATE_EARLIEST);
        VerificationProperty verificationProperty2 = verificationResult.getInputData(VerificationInputOutput.DATE_LATEST);
        HashSet<VerificationProperty> hashSet = new HashSet<VerificationProperty>();
        hashSet.add(verificationProperty2);
        hashSet.add(verificationProperty);
        hashSet.add(new VerificationProperty(VerificationInputOutput.RECEIPT_DATE_AND_TIME, (String)object));
        object = new SemanticTimeofReceiptVerificationModule();
        object = object.verifySingle(BaseVerificationModule.prepareInput(hashSet));
        verificationResult.addVerificationResult(object);
        if (object.getVerificationState() != VerificationState.PASS) {
            return verificationResult;
        }
        verificationResult.addOutput(new VerificationProperty(VerificationInputOutput.CERTIFICATE_SERIAL_NUMBER_OR_COMPANYID_AND_KEYID, CashBoxUtils.getValueFromMachineCode((String)string, (MachineCodeValue)MachineCodeValue.CERTIFICATE_SERIAL_NUMBER_OR_COMPANYID_AND_KEYID)));
        verificationResult.addOutput(new VerificationProperty(VerificationInputOutput.CASHBOX_ID, CashBoxUtils.getValueFromMachineCode((String)string, (MachineCodeValue)MachineCodeValue.CASHBOX_ID)));
        verificationResult.setVerificationState(VerificationState.PASS);
        return verificationResult;
    }
}

