/*
 * Decompiled with CFR 0.152.
 */
package at.asitplus.regkassen.verification.modules;

import at.asitplus.regkassen.common.util.CryptoUtil;
import at.asitplus.regkassen.verification.common.BaseVerificationModule;
import at.asitplus.regkassen.verification.common.annotations.VerificationModule;
import at.asitplus.regkassen.verification.common.data.I18nDetailedMessageID;
import at.asitplus.regkassen.verification.common.data.Placeholder;
import at.asitplus.regkassen.verification.common.data.VerificationID;
import at.asitplus.regkassen.verification.common.data.VerificationInputOutput;
import at.asitplus.regkassen.verification.common.data.VerificationProperty;
import at.asitplus.regkassen.verification.common.data.VerificationResult;
import at.asitplus.regkassen.verification.common.data.VerificationState;
import at.asitplus.regkassen.verification.common.dbinterface.RegkassenDB;
import at.asitplus.regkassen.verification.common.rpc.RKObjectMapper;
import at.asitplus.regkassen.verification.modules.DetailVerificationModule;
import at.asitplus.regkassen.verification.modules.PreDbConstraintsCheckModule;
import at.asitplus.regkassen.verification.modules.semantic.SemanticMatchCompanyVerificationModule;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Logger;
import org.bouncycastle.crypto.CryptoException;

@VerificationModule(inputProperties={VerificationInputOutput.RECEIPT, VerificationInputOutput.SID, VerificationInputOutput.AUTH_LEVEL, VerificationInputOutput.AUTH_CODE}, verificationID=VerificationID.RKSVDB, version=1)
public class RKSVDBModule
extends BaseVerificationModule {
    private static final Logger LOG = Logger.getLogger(BaseVerificationModule.class.getName());
    private final RegkassenDB db;
    private static RegkassenDB staticDB = null;

    public static void setDB(RegkassenDB regkassenDB) {
        staticDB = regkassenDB;
    }

    public RKSVDBModule() {
        if (staticDB == null) {
            throw new NullPointerException("NO DB MODULE SET!\nplease invoke RKSVDBModule.setDB()");
        }
        this.db = staticDB;
    }

    protected VerificationResult doVerify(VerificationResult verificationResult) {
        VerificationResult verificationResult2;
        VerificationResult verificationResult3;
        VerificationProperty verificationProperty;
        String string;
        verificationResult.setVerificationState(VerificationState.FAIL);
        try {
            string = CryptoUtil.hashData((String)verificationResult.getInputData(VerificationInputOutput.RECEIPT).getValue());
            verificationProperty = new VerificationProperty(VerificationInputOutput.HASH, string);
            verificationResult3 = new VerificationResult().addInput(verificationResult.getInputData(VerificationInputOutput.SID)).addInput(verificationProperty);
            verificationResult2 = this.db.getCachedVerificationResult(verificationResult3);
            if (verificationResult2.getVerificationState() == VerificationState.PASS) {
                verificationResult2.clearVerificationResults();
                verificationResult.setVerificationState(VerificationState.PASS);
                verificationResult.addVerificationResult(verificationResult2);
                return verificationResult;
            }
        }
        catch (CryptoException cryptoException) {
            VerificationResult verificationResult4 = new VerificationResult();
            verificationResult4.setVerificationId(VerificationID.DBCALL_CHECK_CACHED_RESULT);
            verificationResult4.setVerificationState(VerificationState.FAIL);
            verificationResult.setDetailedMessage(I18nDetailedMessageID.FAIL_INTERNAL, new String[0]);
            verificationResult.addVerificationResult(verificationResult4);
            return verificationResult;
        }
        string = this.db.registerVerificationProcess(verificationResult);
        verificationResult.addVerificationResult((VerificationResult)string);
        if (string.getVerificationState() != VerificationState.PASS) {
            verificationResult.setDetailedMessage(I18nDetailedMessageID.FAIL_INTERNAL, new String[0]);
            return verificationResult;
        }
        verificationResult3 = string.getOutputData(VerificationInputOutput.TIMEOFVERIFICATION);
        verificationResult2 = BaseVerificationModule.prepareInput((VerificationResult)verificationResult, PreDbConstraintsCheckModule.class);
        verificationResult2.addInput(new VerificationProperty(VerificationInputOutput.DATE_LATEST, verificationResult3.getValue()));
        verificationResult2 = new PreDbConstraintsCheckModule().verifySingle(verificationResult2);
        string = string.getOutputData(VerificationInputOutput.TOKEN);
        verificationResult.addVerificationResult(verificationResult2);
        if (verificationResult2.getVerificationState() != VerificationState.PASS) {
            this.logVerfication(verificationResult, verificationProperty, (VerificationProperty)string, false);
            return verificationResult;
        }
        VerificationProperty verificationProperty2 = verificationResult2.getSubResult(VerificationID.RKSUITE).getOutputData(VerificationInputOutput.ZDA_ID);
        VerificationProperty verificationProperty3 = verificationResult2.getSubResult(VerificationID.RKSUITE).getOutputData(VerificationInputOutput.SYSTEM_TYPE);
        VerificationProperty verificationProperty4 = verificationResult2.getSubResult(VerificationID.RKSUITE).getOutputData(VerificationInputOutput.RK_SUITE_ID);
        VerificationProperty verificationProperty5 = verificationResult2.getOutputData(VerificationInputOutput.CERTIFICATE_SERIAL_NUMBER_OR_COMPANYID_AND_KEYID);
        VerificationProperty verificationProperty6 = verificationResult2.getOutputData(VerificationInputOutput.CASHBOX_ID);
        verificationResult2 = verificationResult2.getSubResult(VerificationID.FORMAT_CHECK_TIMEANDDATE).getOutputData(VerificationInputOutput.TIMEOFRECEIPT);
        Object object = new HashSet();
        object.add(verificationProperty2);
        object.add(string);
        object.add(verificationProperty5);
        object.add(verificationResult.getInputData(VerificationInputOutput.RECEIPT));
        Object object2 = this.db.getSID(RKSVDBModule.prepareInput(object));
        verificationResult.addVerificationResult(object2);
        if (object2.getVerificationState() != VerificationState.PASS) {
            verificationResult.setDetailedMessage(I18nDetailedMessageID.FAIL_INTERNAL, new String[0]);
            this.logVerfication(verificationResult, verificationProperty, (VerificationProperty)string, false);
            return verificationResult;
        }
        VerificationProperty verificationProperty7 = object2.getOutputData(VerificationInputOutput.SID);
        object = new VerificationProperty(VerificationInputOutput.SID_FROM_USER, verificationResult.getInputData(VerificationInputOutput.SID).getValue());
        Object object3 = new HashSet();
        object3.add(verificationProperty7);
        object3.add(object);
        object = RKSVDBModule.prepareInput(object3);
        object = new SemanticMatchCompanyVerificationModule().verifySingle((VerificationResult)object);
        verificationResult.addVerificationResult((VerificationResult)object);
        if (object.getVerificationState() == VerificationState.FAIL) {
            this.logVerfication(verificationResult, verificationProperty, (VerificationProperty)string, false);
            return verificationResult;
        }
        object = new HashSet<VerificationProperty>();
        object.add(verificationResult.getInputData(VerificationInputOutput.SID));
        object.add(string);
        object.add(verificationResult2);
        object.add(verificationResult3);
        object.add(verificationProperty6);
        object3 = this.db.getCashboxStatesAndKeys(BaseVerificationModule.prepareInput((Collection)object));
        verificationResult.addVerificationResult(object3);
        if (object3.getVerificationState() == VerificationState.FAIL) {
            this.logVerfication(verificationResult, verificationProperty, (VerificationProperty)string, false);
            return verificationResult;
        }
        object = new HashSet<VerificationProperty>();
        object.add(verificationProperty2);
        object.add(string);
        object.add(verificationProperty5);
        object.add(verificationResult2);
        object.add(verificationResult3);
        verificationResult3 = this.db.getSigDeviceStatesAndKey(BaseVerificationModule.prepareInput((Collection)object));
        verificationResult.addVerificationResult(verificationResult3);
        if (verificationResult3.getVerificationState() == VerificationState.FAIL) {
            verificationResult.setDetailedMessage(I18nDetailedMessageID.FAIL_INTERNAL, new String[0]);
            this.logVerfication(verificationResult, verificationProperty, (VerificationProperty)string, false);
            return verificationResult;
        }
        if (Placeholder.NULL.name().equals(verificationResult3.getOutputData(VerificationInputOutput.CERIFICATE_OR_PUBKEY).getValue())) {
            verificationResult.setDetailedMessage(I18nDetailedMessageID.FAIL_INTERNAL, new String[0]);
            verificationResult3.setVerificationState(VerificationState.FAIL);
            return verificationResult;
        }
        verificationProperty2 = BaseVerificationModule.prepareInput((VerificationResult)object2, DetailVerificationModule.class);
        verificationProperty2.addInput(verificationResult.getInputData(VerificationInputOutput.RECEIPT));
        verificationProperty5 = object3.getOutputData(VerificationInputOutput.CAN_ACTIVATE);
        boolean bl = Boolean.parseBoolean(verificationProperty5.getValue());
        object2 = object3.getOutputData(bl ? VerificationInputOutput.AESKEY_STATE_TIMEOFVERIFICATION : VerificationInputOutput.AESKEY_TIMEOFRECEIPT).getValue();
        object3 = object3.getOutputData(bl ? VerificationInputOutput.STATE_CASHBOX_TIMEOFVERIFICATION : VerificationInputOutput.STATE_CASHBOX_TIMEOFRECEIPT).getValue();
        VerificationProperty verificationProperty8 = verificationResult3.getOutputData(VerificationInputOutput.CERIFICATE_OR_PUBKEY);
        VerificationProperty verificationProperty9 = verificationResult3.getOutputData(VerificationInputOutput.STATE_SIGDEVICE_TIMEOFRECEIPT);
        verificationResult3 = verificationResult3.getOutputData(VerificationInputOutput.STATE_SIGDEVICE_TIMEOFVERIFICATION);
        verificationProperty2.addInput(new VerificationProperty(VerificationInputOutput.AESKEY, (String)object2));
        verificationProperty2.addInput(new VerificationProperty(VerificationInputOutput.STATE_CASHBOX_TIMEOFRECEIPT, (String)object3));
        verificationProperty2.addInput(new VerificationProperty(VerificationInputOutput.STATE_CASHBOX_TIMEOFVERIFICATION, (String)object3));
        verificationProperty2.addInput(new VerificationProperty(VerificationInputOutput.USING_CASHBOX_KEY_FROM_TIMEOFVERIFICATION, Boolean.toString(bl)));
        verificationProperty2.addInput(verificationProperty9);
        verificationProperty2.addInput((VerificationProperty)verificationResult3);
        verificationProperty2.addInput(verificationProperty8);
        verificationProperty2.addInput(verificationProperty3);
        verificationProperty2.addInput(verificationProperty4);
        verificationProperty2.addInput((VerificationProperty)verificationResult2);
        verificationProperty2.addInput(verificationProperty5);
        verificationProperty2 = new DetailVerificationModule().verifySingle((VerificationResult)verificationProperty2);
        verificationResult.addVerificationResult((VerificationResult)verificationProperty2);
        if (verificationProperty2.getVerificationState() != VerificationState.PASS) {
            verificationResult.setVerificationState(VerificationState.FAIL);
            this.logVerfication(verificationResult, verificationProperty, (VerificationProperty)string, false);
            return verificationResult;
        }
        verificationResult.setVerificationState(VerificationState.PASS);
        if (Boolean.parseBoolean(verificationProperty5.getValue()) && verificationResult.getVerificationState() == VerificationState.PASS && (verificationResult3 = verificationResult.getSubResult(VerificationID.TYPE_OF_RECEIPT_START)) != null && verificationResult3.getVerificationState() == VerificationState.PASS) {
            verificationResult3 = this.db.activateCashbox(new VerificationResult().addInput(verificationProperty7).addInput(verificationProperty6).addInput((VerificationProperty)verificationResult2));
            verificationResult.addVerificationResult(verificationResult3);
            if (verificationResult3.getVerificationState() != VerificationState.PASS) {
                verificationResult.setVerificationState(VerificationState.FAIL);
            }
        }
        this.logVerfication(verificationResult, verificationProperty, (VerificationProperty)string, true);
        return verificationResult;
    }

    public RegkassenDB getDb() {
        return this.db;
    }

    private void logVerfication(VerificationResult verificationResult, VerificationProperty verificationProperty, VerificationProperty verificationProperty2, boolean bl) {
        HashSet<VerificationProperty> hashSet = new HashSet<VerificationProperty>();
        VerificationResult verificationResult2 = verificationResult.getSubResult(VerificationID.TYPE_OF_RECEIPT);
        if (verificationResult2 != null) {
            if (verificationResult2.getVerificationState() == VerificationState.PASS) {
                hashSet.add(verificationResult2.getOutputData(VerificationInputOutput.TYPE_RECEIPT));
            }
        } else {
            hashSet.add(new VerificationProperty(VerificationInputOutput.TYPE_RECEIPT, Placeholder.NULL.name()));
        }
        hashSet.add(verificationProperty);
        hashSet.add(verificationProperty2);
        hashSet.add(new VerificationProperty(VerificationInputOutput.RESULT_FULL, RKObjectMapper.stringify((Object)verificationResult)));
        hashSet.add(new VerificationProperty(VerificationInputOutput.VERFICATION_HIGH_LEVEL_STATE, (Enum)verificationResult.getVerificationState()));
        verificationProperty = this.db.logVerificationResult(BaseVerificationModule.prepareInput(hashSet));
        if (verificationProperty.getVerificationState() != VerificationState.PASS) {
            verificationResult.setVerificationState(VerificationState.FAIL);
            verificationResult.addVerificationResult((VerificationResult)verificationProperty);
            verificationResult.setDetailedMessage(I18nDetailedMessageID.FAIL_INTERNAL, new String[0]);
            return;
        }
        if (bl) {
            verificationResult.addVerificationResult((VerificationResult)verificationProperty);
        }
    }
}

