/*
 * Decompiled with CFR 0.152.
 */
package at.asitplus.regkassen.verification.modules.basic;

import at.asitplus.regkassen.verification.common.BaseVerificationModule;
import at.asitplus.regkassen.verification.common.annotations.VerificationModule;
import at.asitplus.regkassen.verification.common.data.VerificationID;
import at.asitplus.regkassen.verification.common.data.VerificationInputOutput;
import at.asitplus.regkassen.verification.common.data.VerificationResult;
import at.asitplus.regkassen.verification.common.data.VerificationState;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

@VerificationModule(inputProperties={VerificationInputOutput.RECEIPT_DATE_AND_TIME, VerificationInputOutput.DATE_EARLIEST, VerificationInputOutput.DATE_LATEST}, verificationID=VerificationID.TIMEOFRECEIPT_WITHIN_PERIOD, version=1)
public class SemanticTimeofReceiptVerificationModule
extends BaseVerificationModule {
    protected VerificationResult doVerify(VerificationResult verificationResult) {
        verificationResult.setVerificationState(VerificationState.FAIL);
        DateTime dateTime = BaseVerificationModule.DATE_FORMAT_RECEIPT.parseDateTime(verificationResult.getInputData(VerificationInputOutput.RECEIPT_DATE_AND_TIME).getValue());
        DateTime dateTime2 = BaseVerificationModule.DATE_FORMAT_RECEIPT.parseDateTime(verificationResult.getInputData(VerificationInputOutput.DATE_EARLIEST).getValue());
        DateTime dateTime3 = BaseVerificationModule.DATE_FORMAT.parseDateTime(verificationResult.getInputData(VerificationInputOutput.DATE_LATEST).getValue()).plusMinutes(1);
        if (dateTime2.isEqual((ReadableInstant)dateTime) || dateTime3.isEqual((ReadableInstant)dateTime)) {
            verificationResult.setVerificationState(VerificationState.PASS);
            return verificationResult;
        }
        if (dateTime2.isBefore((ReadableInstant)dateTime) && dateTime3.isAfter((ReadableInstant)dateTime)) {
            verificationResult.setVerificationState(VerificationState.PASS);
            return verificationResult;
        }
        return verificationResult;
    }
}

